/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.io.BindingException;
import gov.nist.secauto.metaschema.binding.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.json.IJsonWritingContext;
import gov.nist.secauto.metaschema.binding.io.json.JsonUtil;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.AbstractClassBinding;
import gov.nist.secauto.metaschema.binding.model.AssemblyConstraintSupport;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.IAssemblyConstraintFeature;
import gov.nist.secauto.metaschema.binding.model.IBoundAssemblyInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundFieldInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundFlagInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundNamedInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundNamedModelInstance;
import gov.nist.secauto.metaschema.binding.model.ModelUtil;
import gov.nist.secauto.metaschema.binding.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.binding.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.binding.model.annotations.BoundField;
import gov.nist.secauto.metaschema.binding.model.annotations.Ignore;
import gov.nist.secauto.metaschema.binding.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.binding.model.annotations.ValueConstraints;
import gov.nist.secauto.metaschema.model.common.IChoiceInstance;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.INamedInstance;
import gov.nist.secauto.metaschema.model.common.constraint.IAssemblyConstraintSupport;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.CustomCollectors;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import nl.talsmasoftware.lazy4j.Lazy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultAssemblyClassBinding
extends AbstractClassBinding
implements IAssemblyClassBinding,
IAssemblyConstraintFeature {
    private static final Logger LOGGER = LogManager.getLogger(DefaultAssemblyClassBinding.class);
    private final MetaschemaAssembly metaschemaAssembly;
    private Map<String, IBoundNamedModelInstance> modelInstances;
    private final QName xmlRootQName;
    private final Lazy<IAssemblyConstraintSupport> constraints;

    @NonNull
    public static DefaultAssemblyClassBinding createInstance(@NonNull Class<?> clazz, @NonNull IBindingContext bindingContext) {
        return new DefaultAssemblyClassBinding(clazz, bindingContext);
    }

    protected DefaultAssemblyClassBinding(@NonNull Class<?> clazz, @NonNull IBindingContext bindingContext) {
        super(clazz, bindingContext);
        Objects.requireNonNull(clazz, "clazz");
        if (!clazz.isAnnotationPresent(MetaschemaAssembly.class)) {
            throw new IllegalArgumentException(String.format("Class '%s' is missing the '%s' annotation.", clazz.getName(), MetaschemaAssembly.class.getName()));
        }
        this.metaschemaAssembly = (MetaschemaAssembly)ObjectUtils.notNull((Object)clazz.getAnnotation(MetaschemaAssembly.class));
        String namespace = (String)ObjectUtils.notNull((Object)ModelUtil.resolveNamespace(this.metaschemaAssembly.rootNamespace(), this));
        String localName = ModelUtil.resolveLocalName(this.metaschemaAssembly.rootName(), null);
        this.xmlRootQName = localName == null ? null : new QName(namespace, localName);
        this.constraints = Lazy.lazy(() -> new AssemblyConstraintSupport(clazz.getAnnotation(ValueConstraints.class), clazz.getAnnotation(AssemblyConstraints.class), IConstraint.InternalModelSource.instance()));
    }

    public MetaschemaAssembly getMetaschemaAssemblyAnnotation() {
        return this.metaschemaAssembly;
    }

    public String getFormalName() {
        return ModelUtil.resolveToString(this.getMetaschemaAssemblyAnnotation().formalName());
    }

    public MarkupLine getDescription() {
        return ModelUtil.resolveToMarkupLine(this.getMetaschemaAssemblyAnnotation().description());
    }

    @Nullable
    public MarkupMultiline getRemarks() {
        return ModelUtil.resolveToMarkupMultiline(this.getMetaschemaAssemblyAnnotation().description());
    }

    public String getName() {
        return this.getMetaschemaAssemblyAnnotation().name();
    }

    @Override
    public boolean isInline() {
        return false;
    }

    public IBoundAssemblyInstance getInlineInstance() {
        return null;
    }

    public boolean isRoot() {
        return this.getRootXmlQName() != null;
    }

    public String getRootName() {
        QName qname = this.getRootXmlQName();
        return qname == null ? null : qname.getLocalPart();
    }

    public QName getRootXmlQName() {
        return this.xmlRootQName;
    }

    protected Stream<IBoundNamedModelInstance> getModelInstanceFieldStream(Class<?> clazz) {
        Class<?> superClass = clazz.getSuperclass();
        Stream<Object> superInstances = superClass == null ? Stream.empty() : this.getModelInstanceFieldStream(superClass);
        return Stream.concat(superInstances, Arrays.stream(clazz.getDeclaredFields()).filter(field -> !field.isAnnotationPresent(Ignore.class)).filter(field -> field.isAnnotationPresent(BoundField.class) || field.isAnnotationPresent(BoundAssembly.class)).map(field -> {
            assert (field != null);
            return this.newModelInstance(clazz, (Field)field);
        }).filter(Objects::nonNull).map(ObjectUtils::notNull));
    }

    protected IBoundNamedModelInstance newModelInstance(@NonNull Class<?> clazz, @NonNull Field field) {
        IBoundNamedModelInstance retval;
        if (field.isAnnotationPresent(BoundAssembly.class) && this.getBindingContext().getClassBinding(IBoundNamedModelInstance.getItemType(field)) != null) {
            retval = IBoundAssemblyInstance.newInstance(field, this);
        } else if (field.isAnnotationPresent(BoundField.class)) {
            retval = IBoundFieldInstance.newInstance(field, this);
        } else {
            throw new IllegalStateException(String.format("The field '%s' on class '%s' is not bound", field.getName(), clazz.getName()));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initalizeModelInstances() {
        DefaultAssemblyClassBinding defaultAssemblyClassBinding = this;
        synchronized (defaultAssemblyClassBinding) {
            if (this.modelInstances == null) {
                this.modelInstances = this.getModelInstanceFieldStream(this.getBoundClass()).collect(Collectors.toMap(instance -> instance.getEffectiveName(), Function.identity(), CustomCollectors.useLastMapper(), LinkedHashMap::new));
            }
        }
    }

    @Override
    public Collection<? extends IBoundNamedModelInstance> getModelInstances() {
        return this.getNamedModelInstances();
    }

    @Override
    public IBoundNamedModelInstance getModelInstanceByName(String name) {
        return this.getNamedModelInstanceMap().get(name);
    }

    @NonNull
    private Map<String, ? extends IBoundNamedModelInstance> getNamedModelInstanceMap() {
        this.initalizeModelInstances();
        return this.modelInstances;
    }

    @Override
    public Collection<? extends IBoundNamedModelInstance> getNamedModelInstances() {
        return this.getNamedModelInstanceMap().values();
    }

    @Override
    public Map<String, ? extends IBoundNamedInstance> getNamedInstances(Predicate<IBoundFlagInstance> flagFilter) {
        return (Map)ObjectUtils.notNull((Object)Stream.concat(super.getNamedInstances(flagFilter).values().stream().map(ObjectUtils::notNull), this.getNamedModelInstances().stream()).collect(Collectors.toMap(instance -> instance.getJsonName(), Function.identity(), CustomCollectors.useLastMapper(), LinkedHashMap::new)));
    }

    @NonNull
    private Map<String, ? extends IBoundFieldInstance> getFieldInstanceMap() {
        return (Map)ObjectUtils.notNull((Object)this.getNamedModelInstances().stream().filter(instance -> instance instanceof IBoundFieldInstance).map(instance -> (IBoundFieldInstance)instance).map(ObjectUtils::notNull).collect(Collectors.toMap(INamedInstance::getEffectiveName, Function.identity(), CustomCollectors.useLastMapper(), LinkedHashMap::new)));
    }

    @Override
    public Collection<? extends IBoundFieldInstance> getFieldInstances() {
        return this.getFieldInstanceMap().values();
    }

    @Override
    public IBoundFieldInstance getFieldInstanceByName(String name) {
        return this.getFieldInstanceMap().get(name);
    }

    @NonNull
    private Map<String, ? extends IBoundAssemblyInstance> getAssemblyInstanceMap() {
        return (Map)ObjectUtils.notNull((Object)this.getNamedModelInstances().stream().filter(instance -> instance instanceof IBoundAssemblyInstance).map(instance -> (IBoundAssemblyInstance)instance).map(ObjectUtils::notNull).collect(Collectors.toMap(INamedInstance::getEffectiveName, Function.identity(), CustomCollectors.useLastMapper(), LinkedHashMap::new)));
    }

    @Override
    @NonNull
    public Collection<? extends IBoundAssemblyInstance> getAssemblyInstances() {
        return this.getAssemblyInstanceMap().values();
    }

    @Override
    public IBoundAssemblyInstance getAssemblyInstanceByName(String name) {
        return this.getAssemblyInstanceMap().get(name);
    }

    public List<? extends IChoiceInstance> getChoiceInstances() {
        return CollectionUtil.emptyList();
    }

    @Override
    public IAssemblyConstraintSupport getConstraintSupport() {
        return (IAssemblyConstraintSupport)this.constraints.get();
    }

    @Override
    public Object readObject(IJsonParsingContext context) throws IOException {
        JsonParser parser = (JsonParser)context.getReader();
        JsonUtil.assertAndAdvance(parser, JsonToken.START_OBJECT);
        try {
            Object instance = this.newInstance();
            this.readInternal(instance, null, context);
            JsonUtil.assertAndAdvance(parser, JsonToken.END_OBJECT);
            return instance;
        }
        catch (BindingException ex) {
            throw new IOException(String.format("Failed to parse JSON object for '%s'", this.getBoundClass().getName()), ex);
        }
    }

    @Override
    protected void readBody(Object instance, StartElement start, IXmlParsingContext context) throws IOException, XMLStreamException {
        HashSet<IBoundNamedModelInstance> unhandledProperties = new HashSet<IBoundNamedModelInstance>();
        for (IBoundNamedModelInstance iBoundNamedModelInstance : this.getModelInstances()) {
            if (iBoundNamedModelInstance.read(instance, start, context)) continue;
            unhandledProperties.add(iBoundNamedModelInstance);
        }
        for (IBoundNamedModelInstance iBoundNamedModelInstance : unhandledProperties) {
            iBoundNamedModelInstance.setValue(instance, iBoundNamedModelInstance.newPropertyCollector().getValue());
        }
    }

    @Override
    public List<Object> readItem(Object parentInstance, boolean requiresJsonKey, IJsonParsingContext context) throws IOException {
        JsonUtil.assertCurrent((JsonParser)context.getReader(), JsonToken.FIELD_NAME, JsonToken.END_OBJECT);
        try {
            Object instance = this.newInstance();
            this.readInternal(instance, parentInstance, context);
            return CollectionUtil.singletonList(instance);
        }
        catch (BindingException ex) {
            throw new IOException(ex);
        }
    }

    protected void readInternal(@NonNull Object instance, @Nullable Object parentInstance, @NonNull IJsonParsingContext context) throws IOException {
        Map<String, ? extends IBoundNamedInstance> properties;
        JsonParser parser = (JsonParser)context.getReader();
        JsonUtil.assertCurrent(parser, JsonToken.FIELD_NAME, JsonToken.END_OBJECT);
        try {
            this.callBeforeDeserialize(instance, parentInstance);
        }
        catch (BindingException ex) {
            throw new IOException("an error occured calling the beforeDeserialize() method", ex);
        }
        IBoundFlagInstance jsonKey = this.getJsonKeyFlagInstance();
        if (jsonKey == null) {
            properties = this.getNamedInstances(null);
        } else {
            properties = this.getNamedInstances(flag -> !jsonKey.equals(flag));
            String key = (String)ObjectUtils.notNull((Object)parser.getCurrentName());
            Object value = jsonKey.readValueFromString(key);
            jsonKey.setValue(instance, value.toString());
            JsonUtil.assertAndAdvance(parser, JsonToken.FIELD_NAME);
        }
        HashSet<Object> handledProperties = new HashSet<Object>();
        while (!JsonToken.END_OBJECT.equals((Object)parser.currentToken())) {
            String propertyName = parser.getCurrentName();
            IBoundNamedInstance iBoundNamedInstance = properties.get(propertyName);
            boolean handled = false;
            if (iBoundNamedInstance != null) {
                handled = iBoundNamedInstance.read(instance, context);
            }
            if (handled) {
                handledProperties.add(propertyName);
                continue;
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Unrecognized property named '{}' at '{}'", (Object)propertyName, (Object)JsonUtil.toString((JsonLocation)ObjectUtils.notNull((Object)parser.getCurrentLocation())));
            }
            JsonUtil.assertAndAdvance(parser, JsonToken.FIELD_NAME);
            JsonUtil.skipNextValue(parser);
        }
        for (Map.Entry entry : properties.entrySet()) {
            if (handledProperties.contains(entry.getKey())) continue;
            IBoundNamedInstance property = (IBoundNamedInstance)ObjectUtils.notNull((Object)((IBoundNamedInstance)entry.getValue()));
            property.setValue(instance, property.newPropertyCollector().getValue());
        }
        if (jsonKey != null) {
            JsonUtil.assertAndAdvance(parser, JsonToken.END_OBJECT);
        }
        try {
            this.callAfterDeserialize(instance, parentInstance);
        }
        catch (BindingException ex) {
            throw new IOException("an error occured calling the afterDeserialize() method", ex);
        }
        JsonUtil.assertCurrent(parser, JsonToken.END_OBJECT);
    }

    protected void writeInternal(@NonNull Object instance, boolean writeObjectWrapper, @NonNull IJsonWritingContext context) throws IOException {
        Map<String, ? extends IBoundNamedInstance> properties;
        IBoundFlagInstance jsonKey;
        JsonGenerator writer = (JsonGenerator)context.getWriter();
        if (writeObjectWrapper) {
            writer.writeStartObject();
        }
        if ((jsonKey = this.getJsonKeyFlagInstance()) == null) {
            properties = this.getNamedInstances(null);
        } else {
            properties = this.getNamedInstances(flag -> !jsonKey.equals(flag));
            Object flagValue = jsonKey.getValue(instance);
            String string = jsonKey.getValueAsString(flagValue);
            if (string == null) {
                throw new IOException(new NullPointerException("Null key value"));
            }
            writer.writeFieldName(string);
            writer.writeStartObject();
        }
        for (IBoundNamedInstance iBoundNamedInstance : properties.values()) {
            ((IBoundNamedInstance)ObjectUtils.notNull((Object)iBoundNamedInstance)).write(instance, context);
        }
        if (jsonKey != null) {
            writer.writeEndObject();
        }
        if (writeObjectWrapper) {
            writer.writeEndObject();
        }
    }

    @Override
    protected void writeBody(Object instance, QName parentName, IXmlWritingContext context) throws XMLStreamException, IOException {
        for (IBoundNamedModelInstance iBoundNamedModelInstance : this.getModelInstances()) {
            iBoundNamedModelInstance.write(instance, parentName, context);
        }
    }

    @Override
    public void writeItems(Collection<? extends Object> items, boolean writeObjectWrapper, IJsonWritingContext context) throws IOException {
        for (Object object : items) {
            assert (object != null);
            this.writeInternal(object, writeObjectWrapper, context);
        }
    }

    @Override
    protected void copyBoundObjectInternal(@NonNull Object fromInstance, @NonNull Object toInstance) throws BindingException {
        super.copyBoundObjectInternal(fromInstance, toInstance);
        for (IBoundNamedModelInstance iBoundNamedModelInstance : this.getModelInstances()) {
            iBoundNamedModelInstance.copyBoundObject(fromInstance, toInstance);
        }
    }

    @Override
    protected Class<? extends IMetaschema> getMetaschemaClass() {
        return this.getMetaschemaAssemblyAnnotation().metaschema();
    }
}

