/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.model.AbstractAssemblyProperty;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.ModelUtil;
import gov.nist.secauto.metaschema.binding.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.lang.reflect.Field;

class DefaultAssemblyProperty
extends AbstractAssemblyProperty {
    @NonNull
    private final BoundAssembly assembly;
    @NonNull
    private final IAssemblyClassBinding definition;

    protected DefaultAssemblyProperty(@NonNull Field field, @NonNull IAssemblyClassBinding definition, @NonNull IAssemblyClassBinding parentClassBinding) {
        super(field, parentClassBinding);
        if (!field.isAnnotationPresent(BoundAssembly.class)) {
            throw new IllegalArgumentException(String.format("BoundField '%s' on class '%s' is missing the '%s' annotation.", field.getName(), parentClassBinding.getBoundClass().getName(), BoundAssembly.class.getName()));
        }
        this.assembly = (BoundAssembly)ObjectUtils.notNull((Object)field.getAnnotation(BoundAssembly.class));
        this.definition = definition;
    }

    protected BoundAssembly getAssemblyAnnotation() {
        return this.assembly;
    }

    @Override
    public IAssemblyClassBinding getDefinition() {
        return this.definition;
    }

    public String getFormalName() {
        return ModelUtil.resolveToString(this.getAssemblyAnnotation().formalName());
    }

    public MarkupLine getDescription() {
        return ModelUtil.resolveToMarkupLine(this.getAssemblyAnnotation().description());
    }

    public MarkupMultiline getRemarks() {
        return ModelUtil.resolveToMarkupMultiline(this.getAssemblyAnnotation().remarks());
    }

    public String getUseName() {
        return ModelUtil.resolveToString(this.getAssemblyAnnotation().useName());
    }

    public String getXmlNamespace() {
        return (String)ObjectUtils.notNull((Object)ModelUtil.resolveNamespace(this.getAssemblyAnnotation().namespace(), this.getParentClassBinding()));
    }

    @Override
    public int getMinOccurs() {
        return this.getAssemblyAnnotation().minOccurs();
    }

    @Override
    public int getMaxOccurs() {
        return this.getAssemblyAnnotation().maxOccurs();
    }
}

