/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.io.BindingException;
import gov.nist.secauto.metaschema.binding.io.json.CollapseKeyBuilder;
import gov.nist.secauto.metaschema.binding.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.json.IJsonProblemHandler;
import gov.nist.secauto.metaschema.binding.io.json.IJsonWritingContext;
import gov.nist.secauto.metaschema.binding.io.json.JsonUtil;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.AbstractClassBinding;
import gov.nist.secauto.metaschema.binding.model.DefaultFieldValueProperty;
import gov.nist.secauto.metaschema.binding.model.IBoundFieldInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundFieldValueInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundFlagInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundNamedInstance;
import gov.nist.secauto.metaschema.binding.model.IFieldClassBinding;
import gov.nist.secauto.metaschema.binding.model.IValueConstraintFeature;
import gov.nist.secauto.metaschema.binding.model.ListPropertyCollector;
import gov.nist.secauto.metaschema.binding.model.ModelUtil;
import gov.nist.secauto.metaschema.binding.model.ValueConstraintSupport;
import gov.nist.secauto.metaschema.binding.model.annotations.Ignore;
import gov.nist.secauto.metaschema.binding.model.annotations.MetaschemaField;
import gov.nist.secauto.metaschema.binding.model.annotations.MetaschemaFieldValue;
import gov.nist.secauto.metaschema.binding.model.annotations.ValueConstraints;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IValueConstraintSupport;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.common.util.XmlEventUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import nl.talsmasoftware.lazy4j.Lazy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultFieldClassBinding
extends AbstractClassBinding
implements IFieldClassBinding,
IValueConstraintFeature {
    private static final Logger LOGGER = LogManager.getLogger(DefaultFieldClassBinding.class);
    @NonNull
    private final MetaschemaField metaschemaField;
    private IBoundFieldValueInstance fieldValue;
    private IBoundFlagInstance jsonValueKeyFlagInstance;
    private final Lazy<IValueConstraintSupport> constraints;

    @NonNull
    public static DefaultFieldClassBinding createInstance(@NonNull Class<?> clazz, @NonNull IBindingContext bindingContext) {
        Objects.requireNonNull(clazz, "clazz");
        if (!clazz.isAnnotationPresent(MetaschemaField.class)) {
            throw new IllegalArgumentException(String.format("Class '%s' is missing the '%s' annotation.", clazz.getName(), MetaschemaField.class.getName()));
        }
        return new DefaultFieldClassBinding(clazz, bindingContext);
    }

    protected DefaultFieldClassBinding(@NonNull Class<?> clazz, @NonNull IBindingContext bindingContext) {
        super(clazz, bindingContext);
        this.metaschemaField = (MetaschemaField)ObjectUtils.notNull((Object)clazz.getAnnotation(MetaschemaField.class));
        this.constraints = Lazy.lazy(() -> new ValueConstraintSupport(clazz.getAnnotation(ValueConstraints.class), IConstraint.InternalModelSource.instance()));
    }

    @NonNull
    public MetaschemaField getMetaschemaFieldAnnotation() {
        return this.metaschemaField;
    }

    @Override
    public IValueConstraintSupport getConstraintSupport() {
        return (IValueConstraintSupport)this.constraints.get();
    }

    public String getFormalName() {
        return ModelUtil.resolveToString(this.getMetaschemaFieldAnnotation().formalName());
    }

    public MarkupLine getDescription() {
        return ModelUtil.resolveToMarkupLine(this.getMetaschemaFieldAnnotation().description());
    }

    @Nullable
    public MarkupMultiline getRemarks() {
        return ModelUtil.resolveToMarkupMultiline(this.getMetaschemaFieldAnnotation().description());
    }

    public String getName() {
        return this.getMetaschemaFieldAnnotation().name();
    }

    public Object getDefaultValue() {
        return this.getFieldValueInstance().getDefaultValue();
    }

    protected Field getFieldValueField(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        Field retval = null;
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            retval = this.getFieldValueField(superClass);
        }
        if (retval == null) {
            for (Field field : fields) {
                if (!field.isAnnotationPresent(MetaschemaFieldValue.class) || field.isAnnotationPresent(Ignore.class)) continue;
                retval = field;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IBoundFieldValueInstance initalizeFieldValueInstance() {
        DefaultFieldClassBinding defaultFieldClassBinding = this;
        synchronized (defaultFieldClassBinding) {
            if (this.fieldValue == null) {
                Field field = this.getFieldValueField(this.getBoundClass());
                if (field == null) {
                    throw new IllegalArgumentException(String.format("Class '%s' is missing the '%s' annotation on one of its fields.", this.getBoundClass().getName(), MetaschemaFieldValue.class.getName()));
                }
                this.fieldValue = new DefaultFieldValueProperty(this, field);
            }
            return this.fieldValue;
        }
    }

    @Override
    public boolean isInline() {
        return false;
    }

    public IBoundFieldInstance getInlineInstance() {
        return null;
    }

    @Override
    public IBoundFieldValueInstance getFieldValueInstance() {
        return this.initalizeFieldValueInstance();
    }

    @Override
    public Object getFieldValue(@NonNull Object item) {
        return ObjectUtils.requireNonNull((Object)this.getFieldValueInstance().getValue(item));
    }

    @Override
    protected void initializeFlagInstance(IBoundFlagInstance instance) {
        super.initializeFlagInstance(instance);
        if (instance.isJsonValueKey()) {
            this.jsonValueKeyFlagInstance = instance;
        }
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="access is restricted using interface")
    public IBoundFlagInstance getJsonValueKeyFlagInstance() {
        this.initalizeFlagInstances();
        return this.jsonValueKeyFlagInstance;
    }

    public String getJsonValueKeyName() {
        return this.getFieldValueInstance().getJsonValueKeyName();
    }

    public boolean isCollapsible() {
        return this.getMetaschemaFieldAnnotation().isCollapsible();
    }

    @Override
    protected void readBody(Object instance, StartElement start, IXmlParsingContext context) throws IOException, XMLStreamException {
        if (!this.getFieldValueInstance().read(instance, start, context)) {
            throw new IOException(String.format("Missing field value at '%s", XmlEventUtil.toLocation((XMLEvent)start)));
        }
    }

    @Override
    public List<Object> readItem(Object parentInstance, boolean requiresJsonKey, IJsonParsingContext context) throws IOException {
        JsonParser jsonParser = (JsonParser)context.getReader();
        if (requiresJsonKey) {
            JsonUtil.assertCurrent(jsonParser, JsonToken.FIELD_NAME);
        } else {
            JsonUtil.assertCurrent(jsonParser, JsonToken.FIELD_NAME, JsonToken.END_OBJECT);
        }
        List retval = this.isCollapsible() ? this.readCollapsed(parentInstance, requiresJsonKey, context) : CollectionUtil.singletonList((Object)this.readNormal(parentInstance, requiresJsonKey, context));
        return retval;
    }

    @NonNull
    private Object readNormal(@Nullable Object parentInstance, boolean requiresJsonKey, @NonNull IJsonParsingContext context) throws IOException {
        IBoundFlagInstance jsonValueKey;
        Predicate<IBoundFlagInstance> flagFilter = null;
        IBoundFlagInstance jsonKey = null;
        if (requiresJsonKey) {
            IBoundFlagInstance instance = this.getJsonKeyFlagInstance();
            if (instance == null) {
                throw new IOException("This property is configured to use a JSON key, but no JSON key was found");
            }
            flagFilter = flag -> !instance.equals(flag);
            jsonKey = instance;
        }
        if ((jsonValueKey = this.getJsonValueKeyFlagInstance()) != null) {
            flagFilter = flagFilter == null ? flag -> !jsonValueKey.equals(flag) : flagFilter.and(flag -> !jsonValueKey.equals(flag));
        }
        Map properties = this.getNamedInstances((Predicate)flagFilter);
        try {
            Object instance = this.newInstance();
            this.callBeforeDeserialize(instance, parentInstance);
            JsonParser jsonParser = (JsonParser)context.getReader();
            if (jsonKey != null) {
                String key = jsonParser.currentName();
                assert (key != null);
                jsonKey.setValue(instance, jsonKey.readValueFromString(key));
                if (properties.isEmpty()) {
                    JsonUtil.assertAndAdvance(jsonParser, JsonToken.FIELD_NAME);
                } else {
                    JsonUtil.advanceAndAssert(jsonParser, JsonToken.START_OBJECT);
                    jsonParser.nextToken();
                }
            }
            HashSet<String> handledProperties = new HashSet<String>();
            if (properties.isEmpty()) {
                IBoundFieldValueInstance fieldValue = this.getFieldValueInstance();
                Object value = fieldValue.readValue(context);
                if (value != null) {
                    fieldValue.setValue(instance, value);
                }
                handledProperties.add(fieldValue.getJsonValueKeyName());
            } else {
                JsonUtil.assertCurrent(jsonParser, JsonToken.FIELD_NAME, JsonToken.END_OBJECT);
                boolean parsedValueKey = false;
                while (!jsonParser.hasTokenId(JsonToken.END_OBJECT.id())) {
                    String propertyName = jsonParser.getCurrentName();
                    assert (propertyName != null);
                    IBoundNamedInstance namedProperty = (IBoundNamedInstance)properties.get(propertyName);
                    boolean handled = false;
                    if (namedProperty != null) {
                        if (namedProperty.equals(jsonValueKey)) {
                            throw new IOException(String.format("JSON value key configured, but found standard flag for the value key '%s'", namedProperty.toCoordinates()));
                        }
                        Object value = namedProperty.read(context);
                        if (value != null) {
                            namedProperty.setValue(instance, value);
                            handled = true;
                        }
                    }
                    if (namedProperty == null && !parsedValueKey) {
                        parsedValueKey = this.getFieldValueInstance().read(instance, context);
                        if (parsedValueKey) {
                            handled = true;
                        } else if (((IJsonProblemHandler)context.getProblemHandler()).canHandleUnknownProperty(this, propertyName, context)) {
                            handled = ((IJsonProblemHandler)context.getProblemHandler()).handleUnknownProperty(this, propertyName, context);
                        }
                    }
                    if (handled) {
                        handledProperties.add(propertyName);
                        continue;
                    }
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Unrecognized property named '{}' at '{}'", (Object)propertyName, (Object)JsonUtil.toString((JsonLocation)ObjectUtils.notNull((Object)jsonParser.getCurrentLocation())));
                    }
                    JsonUtil.skipNextValue(jsonParser);
                }
            }
            for (Map.Entry entry : properties.entrySet()) {
                if (handledProperties.contains(entry.getKey())) continue;
                IBoundNamedInstance property = (IBoundNamedInstance)ObjectUtils.notNull((Object)((IBoundNamedInstance)entry.getValue()));
                property.setValue(instance, property.newPropertyCollector().getValue());
            }
            if (jsonKey != null && !properties.isEmpty()) {
                JsonUtil.assertAndAdvance(jsonParser, JsonToken.END_OBJECT);
            }
            if (properties.isEmpty()) {
                JsonUtil.assertCurrent(jsonParser, JsonToken.FIELD_NAME, JsonToken.END_OBJECT);
            } else {
                JsonUtil.assertCurrent(jsonParser, JsonToken.END_OBJECT);
            }
            this.callAfterDeserialize(instance, parentInstance);
            return instance;
        }
        catch (BindingException ex) {
            throw new IOException(ex);
        }
    }

    @NonNull
    private List<Object> readCollapsed(@Nullable Object parentInstance, boolean requiresJsonKey, IJsonParsingContext context) throws IOException {
        List<Object> retval;
        Supplier supplier;
        IBoundFlagInstance jsonValueKey;
        Predicate<IBoundFlagInstance> flagFilter = null;
        IBoundFlagInstance jsonKey = null;
        if (requiresJsonKey) {
            IBoundFlagInstance instance = this.getJsonKeyFlagInstance();
            if (instance == null) {
                throw new IOException("This property is configured to use a JSON key, but no JSON key was found");
            }
            flagFilter = flag -> !instance.equals(flag);
            jsonKey = instance;
        }
        if ((jsonValueKey = this.getJsonValueKeyFlagInstance()) != null) {
            flagFilter = flagFilter == null ? flag -> !jsonValueKey.equals(flag) : flagFilter.and(flag -> !jsonValueKey.equals(flag));
        }
        Map properties = this.getNamedInstances((Predicate)flagFilter);
        HashMap<IBoundNamedInstance, Supplier<Object>> parsedProperties = new HashMap<IBoundNamedInstance, Supplier<Object>>();
        JsonParser jsonParser = (JsonParser)context.getReader();
        JsonUtil.assertCurrent(jsonParser, JsonToken.FIELD_NAME, JsonToken.END_OBJECT);
        if (jsonKey != null) {
            String key = jsonParser.currentName();
            assert (key != null);
            Supplier<?> jsonKeySupplier = jsonKey.readValueAndSupply(key);
            parsedProperties.put(jsonKey, jsonKeySupplier);
            JsonUtil.advanceAndAssert(jsonParser, JsonToken.START_OBJECT);
            jsonParser.nextToken();
        }
        List<? extends Object> values = null;
        HashSet<Object> handledProperties = new HashSet<Object>();
        while (!jsonParser.hasTokenId(JsonToken.END_OBJECT.id())) {
            String propertyName = jsonParser.getCurrentName();
            IBoundNamedInstance iBoundNamedInstance = (IBoundNamedInstance)properties.get(propertyName);
            boolean handled = false;
            if (iBoundNamedInstance != null) {
                if (iBoundNamedInstance.equals(jsonValueKey)) {
                    throw new IOException(String.format("JSON value key configured, but found standard flag for the value key '%s'", iBoundNamedInstance.toCoordinates()));
                }
                Supplier<?> supplier2 = ((IBoundFlagInstance)iBoundNamedInstance).readValueAndSupply(context);
                parsedProperties.put(iBoundNamedInstance, supplier2);
                handled = true;
            } else {
                IBoundFieldValueInstance iBoundFieldValueInstance = this.getFieldValueInstance();
                if (jsonValueKey != null) {
                    String key = jsonParser.nextFieldName();
                    assert (key != null);
                    supplier = jsonValueKey.readValueAndSupply(key);
                    parsedProperties.put(jsonValueKey, supplier);
                    values = this.handleCollapsedValues(context);
                    handled = true;
                } else {
                    String valueKeyName = iBoundFieldValueInstance.getJsonValueKeyName();
                    if (propertyName.equals(valueKeyName)) {
                        jsonParser.nextToken();
                        values = this.handleCollapsedValues(context);
                        handled = true;
                    }
                }
            }
            if (handled) {
                handledProperties.add(propertyName);
                continue;
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Unrecognized property named '{}' at '{}'", (Object)propertyName, (Object)JsonUtil.toString((JsonLocation)ObjectUtils.notNull((Object)jsonParser.getCurrentLocation())));
            }
            JsonUtil.skipNextValue(jsonParser);
        }
        for (Map.Entry entry : properties.entrySet()) {
            if (handledProperties.contains(entry.getKey())) continue;
            IBoundNamedInstance property = (IBoundNamedInstance)ObjectUtils.notNull((Object)((IBoundNamedInstance)entry.getValue()));
            parsedProperties.put(property, () -> property.newPropertyCollector().getValue());
        }
        if (jsonKey != null) {
            JsonUtil.assertAndAdvance(jsonParser, JsonToken.END_OBJECT);
        }
        JsonUtil.assertCurrent(jsonParser, JsonToken.END_OBJECT);
        if (values == null) {
            try {
                Object CLASS = this.newInstance();
                this.callBeforeDeserialize(CLASS, parentInstance);
                for (Map.Entry entry : parsedProperties.entrySet()) {
                    IBoundNamedInstance property = (IBoundNamedInstance)entry.getKey();
                    supplier = (Supplier)entry.getValue();
                    property.setValue(CLASS, supplier.get());
                }
                this.callAfterDeserialize(CLASS, parentInstance);
                retval = CollectionUtil.singletonList(CLASS);
            }
            catch (BindingException bindingException) {
                throw new IOException(bindingException);
            }
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>(values.size());
            for (Object e : values) {
                try {
                    Object item = this.newInstance();
                    this.callBeforeDeserialize(item, parentInstance);
                    this.initalizeFieldValueInstance().setValue(item, e);
                    for (Map.Entry entry : parsedProperties.entrySet()) {
                        IBoundNamedInstance property = (IBoundNamedInstance)entry.getKey();
                        Supplier supplier3 = (Supplier)entry.getValue();
                        property.setValue(item, supplier3.get());
                    }
                    this.callAfterDeserialize(item, parentInstance);
                    arrayList.add(item);
                }
                catch (BindingException ex) {
                    throw new IOException(ex);
                }
            }
            retval = arrayList;
        }
        return retval;
    }

    @NonNull
    private List<? extends Object> handleCollapsedValues(@NonNull IJsonParsingContext context) throws IOException {
        IBoundFieldValueInstance fieldValue = this.getFieldValueInstance();
        JsonParser jsonParser = (JsonParser)context.getReader();
        ListPropertyCollector collector = new ListPropertyCollector();
        if (jsonParser.hasToken(JsonToken.START_ARRAY)) {
            JsonUtil.assertAndAdvance(jsonParser, JsonToken.START_ARRAY);
            while (!jsonParser.hasToken(JsonToken.END_ARRAY)) {
                Object value = fieldValue.readValue(context);
                if (value == null) continue;
                collector.add(value);
            }
            JsonUtil.assertAndAdvance(jsonParser, JsonToken.END_ARRAY);
        } else {
            Object value = fieldValue.readValue(context);
            if (value != null) {
                collector.add(value);
            }
        }
        return collector.getValue();
    }

    @Override
    protected void writeBody(Object instance, QName parentName, IXmlWritingContext context) throws XMLStreamException, IOException {
        this.getFieldValueInstance().write(instance, parentName, context);
    }

    @Override
    public void writeItems(Collection<? extends Object> items, boolean writeObjectWrapper, IJsonWritingContext context) throws IOException {
        if (this.isCollapsible()) {
            this.writeCollapsed(items, writeObjectWrapper, context);
        } else {
            this.writeNormal(items, writeObjectWrapper, context);
        }
    }

    private void writeCollapsed(@NonNull Collection<? extends Object> items, boolean writeObjectWrapper, @NonNull IJsonWritingContext context) throws IOException {
        CollapseKeyBuilder builder = new CollapseKeyBuilder(this);
        builder.addAll(items);
        builder.write(writeObjectWrapper, context);
    }

    private void writeNormal(Collection<? extends Object> items, boolean writeObjectWrapper, IJsonWritingContext context) throws IOException {
        IBoundFlagInstance jsonValueKey;
        if (items.isEmpty()) {
            return;
        }
        Predicate<IBoundFlagInstance> flagFilter = null;
        IBoundFlagInstance jsonKey = this.getJsonKeyFlagInstance();
        if (jsonKey != null) {
            flagFilter = flag -> !jsonKey.equals(flag);
        }
        if ((jsonValueKey = this.getJsonValueKeyFlagInstance()) != null) {
            flagFilter = flagFilter == null ? flag -> !jsonValueKey.equals(flag) : flagFilter.and(flag -> !jsonValueKey.equals(flag));
        }
        Map properties = this.getNamedInstances((Predicate)flagFilter);
        JsonGenerator writer = (JsonGenerator)context.getWriter();
        for (Object object : items) {
            assert (object != null);
            if (writeObjectWrapper) {
                writer.writeStartObject();
            }
            if (jsonKey != null) {
                Iterator flagValue = jsonKey.getValue(object);
                String key = jsonKey.getValueAsString(flagValue);
                if (key == null) {
                    throw new IOException(new NullPointerException("Null key value"));
                }
                writer.writeFieldName(key);
                writer.writeStartObject();
            }
            for (IBoundNamedInstance property : properties.values()) {
                ((IBoundNamedInstance)ObjectUtils.notNull((Object)property)).write(object, context);
            }
            Object fieldValue = this.getFieldValueInstance().getValue(object);
            if (fieldValue != null) {
                String valueKeyName = jsonValueKey != null ? jsonValueKey.getValueAsString(jsonValueKey.getValue(object)) : this.getFieldValueInstance().getJsonValueKeyName();
                writer.writeFieldName(valueKeyName);
                this.getFieldValueInstance().writeValue(fieldValue, context);
            }
            if (jsonKey != null) {
                writer.writeEndObject();
            }
            if (!writeObjectWrapper) continue;
            writer.writeEndObject();
        }
    }

    public IDataTypeAdapter<?> getJavaTypeAdapter() {
        return this.getFieldValueInstance().getJavaTypeAdapter();
    }

    @Override
    protected void copyBoundObjectInternal(@NonNull Object fromInstance, @NonNull Object toInstance) throws BindingException {
        super.copyBoundObjectInternal(fromInstance, toInstance);
        this.getFieldValueInstance().copyBoundObject(fromInstance, toInstance);
    }

    @Override
    protected Class<? extends IMetaschema> getMetaschemaClass() {
        return this.getMetaschemaFieldAnnotation().metaschema();
    }
}

