/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.json.IJsonWritingContext;
import gov.nist.secauto.metaschema.binding.io.json.JsonUtil;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.AbstractProperty;
import gov.nist.secauto.metaschema.binding.model.IBoundFieldValueInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundFlagInstance;
import gov.nist.secauto.metaschema.binding.model.IFieldClassBinding;
import gov.nist.secauto.metaschema.binding.model.IPropertyCollector;
import gov.nist.secauto.metaschema.binding.model.ModelUtil;
import gov.nist.secauto.metaschema.binding.model.SingletonPropertyCollector;
import gov.nist.secauto.metaschema.binding.model.annotations.MetaschemaFieldValue;
import gov.nist.secauto.metaschema.model.common.ModelType;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLStreamWriter2;

class DefaultFieldValueProperty
extends AbstractProperty<IFieldClassBinding>
implements IBoundFieldValueInstance {
    private static final Logger LOGGER = LogManager.getLogger(DefaultFieldValueProperty.class);
    @NonNull
    private final Field field;
    @NonNull
    private final MetaschemaFieldValue fieldValue;
    @NonNull
    private final IDataTypeAdapter<?> javaTypeAdapter;
    @Nullable
    private final Object defaultValue;

    public DefaultFieldValueProperty(@NonNull IFieldClassBinding fieldClassBinding, @NonNull Field field) {
        super(fieldClassBinding);
        this.field = (Field)ObjectUtils.requireNonNull((Object)field, (String)"field");
        MetaschemaFieldValue valueAnnotation = field.getAnnotation(MetaschemaFieldValue.class);
        if (valueAnnotation == null) {
            throw new IllegalArgumentException(String.format("Class '%s' is missing the '%s' annotation.", fieldClassBinding.getBoundClass().getName(), MetaschemaFieldValue.class.getName()));
        }
        this.fieldValue = valueAnnotation;
        Class adapterClass = (Class)ObjectUtils.notNull(this.fieldValue.typeAdapter());
        this.javaTypeAdapter = ModelUtil.getDataTypeAdapter(adapterClass, fieldClassBinding.getBindingContext());
        this.defaultValue = ModelUtil.resolveDefaultValue(this.getFieldValueAnnotation().defaultValue(), this.javaTypeAdapter);
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    protected final MetaschemaFieldValue getFieldValueAnnotation() {
        return this.fieldValue;
    }

    public IFieldClassBinding getDefinition() {
        return (IFieldClassBinding)this.getParentClassBinding();
    }

    @Override
    public String getJsonValueKeyName() {
        String name = ModelUtil.resolveToString(this.getFieldValueAnnotation().valueKeyName());
        if (name == null) {
            name = this.getJavaTypeAdapter().getDefaultJsonValueKey();
        }
        return name;
    }

    @Override
    public IDataTypeAdapter<?> getJavaTypeAdapter() {
        return this.javaTypeAdapter;
    }

    public String getFormalName() {
        return null;
    }

    public MarkupLine getDescription() {
        return null;
    }

    public MarkupMultiline getRemarks() {
        return null;
    }

    public String getUseName() {
        return null;
    }

    @Override
    public IPropertyCollector newPropertyCollector() {
        return new SingletonPropertyCollector();
    }

    @Override
    public Object read(IJsonParsingContext context) throws IOException {
        if (((IFieldClassBinding)this.getParentClassBinding()).hasJsonValueKeyFlagInstance()) {
            throw new UnsupportedOperationException("for a JSON value key, use the read(Object, IJsonParsingContext) method");
        }
        Object retval = null;
        if (this.isNextProperty(context)) {
            JsonParser parser = (JsonParser)context.getReader();
            parser.nextFieldName();
            retval = this.readInternal(context);
        }
        return retval;
    }

    @Override
    public boolean read(Object objectInstance, IJsonParsingContext context) throws IOException {
        boolean handled = this.isNextProperty(context);
        if (handled) {
            JsonParser parser = (JsonParser)context.getReader();
            IBoundFlagInstance jsonValueKey = ((IFieldClassBinding)this.getParentClassBinding()).getJsonValueKeyFlagInstance();
            if (jsonValueKey != null) {
                String fieldName = (String)ObjectUtils.notNull((Object)parser.currentName());
                jsonValueKey.setValue(objectInstance, jsonValueKey.readValueFromString(fieldName));
            } else {
                String valueKeyName = this.getJsonValueKeyName();
                String fieldName = parser.getCurrentName();
                if (!fieldName.equals(valueKeyName)) {
                    throw new IOException(String.format("Expecteded to parse the value property named '%s', but found a property named '%s'.", valueKeyName, fieldName));
                }
            }
            parser.nextToken();
            Object retval = this.readInternal(context);
            this.setValue(objectInstance, retval);
        }
        return handled;
    }

    @Override
    public boolean read(Object parentInstance, StartElement start, IXmlParsingContext context) throws IOException, XMLStreamException {
        Object value = this.readInternal(context);
        this.setValue(parentInstance, value);
        return true;
    }

    @Override
    public Object readValue(IJsonParsingContext context) throws IOException {
        return this.readInternal(context);
    }

    public boolean isNextProperty(IJsonParsingContext context) throws IOException {
        JsonParser parser = (JsonParser)context.getReader();
        JsonUtil.assertCurrent(parser, JsonToken.FIELD_NAME);
        IBoundFlagInstance jsonValueKey = ((IFieldClassBinding)this.getParentClassBinding()).getJsonValueKeyFlagInstance();
        boolean handled = jsonValueKey != null ? true : this.getJsonValueKeyName().equals(parser.currentName());
        return handled;
    }

    protected Object readInternal(IJsonParsingContext context) throws IOException {
        return this.getJavaTypeAdapter().parse((JsonParser)context.getReader());
    }

    protected Object readInternal(IXmlParsingContext context) throws IOException {
        return this.getJavaTypeAdapter().parse((XMLEventReader2)context.getReader());
    }

    @Override
    public boolean write(Object instance, QName parentName, IXmlWritingContext context) throws XMLStreamException, IOException {
        Object value = this.getValue(instance);
        if (value != null) {
            this.getJavaTypeAdapter().writeXmlValue(value, parentName, (XMLStreamWriter2)context.getWriter());
        }
        return true;
    }

    @Override
    public void write(Object instance, IJsonWritingContext context) throws IOException {
        Object value = this.getValue(instance);
        if (value != null) {
            IBoundFlagInstance jsonValueKey = ((IFieldClassBinding)this.getParentClassBinding()).getJsonValueKeyFlagInstance();
            String valueKeyName = jsonValueKey != null ? jsonValueKey.getValue(instance).toString() : this.getJsonValueKeyName();
            ((JsonGenerator)context.getWriter()).writeFieldName(valueKeyName);
            LOGGER.info("FIELD: {}", (Object)valueKeyName);
            this.writeValue(value, context);
        }
    }

    @Override
    public void writeValue(Object value, IJsonWritingContext context) throws IOException {
        if (value != null) {
            this.getJavaTypeAdapter().writeJsonValue(value, (JsonGenerator)context.getWriter());
        }
    }

    @NonNull
    public ModelType getModelType() {
        return ModelType.FIELD;
    }

    @Override
    public void copyBoundObject(Object fromInstance, Object toInstance) {
        Object value = this.getValue(fromInstance);
        IDataTypeAdapter<?> adapter = this.getJavaTypeAdapter();
        this.setValue(toInstance, value == null ? null : adapter.copy(value));
    }
}

