/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.model.AbstractFlagProperty;
import gov.nist.secauto.metaschema.binding.model.IBoundFlagInstance;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import gov.nist.secauto.metaschema.binding.model.IValueConstraintFeature;
import gov.nist.secauto.metaschema.binding.model.ModelUtil;
import gov.nist.secauto.metaschema.binding.model.ValueConstraintSupport;
import gov.nist.secauto.metaschema.binding.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.binding.model.annotations.JsonFieldValueKeyFlag;
import gov.nist.secauto.metaschema.binding.model.annotations.JsonKey;
import gov.nist.secauto.metaschema.binding.model.annotations.NullJavaTypeAdapter;
import gov.nist.secauto.metaschema.binding.model.annotations.ValueConstraints;
import gov.nist.secauto.metaschema.model.common.IFlagDefinition;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.ModuleScopeEnum;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IValueConstraintSupport;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.adapter.MetaschemaDataTypeProvider;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import nl.talsmasoftware.lazy4j.Lazy;

class DefaultFlagProperty
extends AbstractFlagProperty {
    @NonNull
    private final Field field;
    @NonNull
    private final BoundFlag flag;
    @NonNull
    private final IDataTypeAdapter<?> javaTypeAdapter;
    @Nullable
    private final Object defaultValue;
    private InternalFlagDefinition definition;

    public DefaultFlagProperty(@NonNull Field field, @NonNull IClassBinding parentClassBinding) {
        super(parentClassBinding);
        this.field = (Field)ObjectUtils.requireNonNull((Object)field, (String)"field");
        this.flag = (BoundFlag)ObjectUtils.requireNonNull((Object)field.getAnnotation(BoundFlag.class));
        Class adapterClass = (Class)ObjectUtils.notNull(this.flag.typeAdapter());
        this.javaTypeAdapter = NullJavaTypeAdapter.class.equals((Object)adapterClass) ? MetaschemaDataTypeProvider.DEFAULT_DATA_TYPE : (IDataTypeAdapter)ObjectUtils.requireNonNull(parentClassBinding.getBindingContext().getJavaTypeAdapterInstance(adapterClass));
        String defaultString = this.flag.defaultValue();
        this.defaultValue = "\u0000".equals(defaultString) ? null : this.getJavaTypeAdapter().parse(defaultString);
    }

    @Override
    @NonNull
    public Field getField() {
        return this.field;
    }

    @NonNull
    protected BoundFlag getFlagAnnotation() {
        return this.flag;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isJsonKey() {
        return this.getField().isAnnotationPresent(JsonKey.class);
    }

    public boolean isJsonValueKey() {
        return this.getField().isAnnotationPresent(JsonFieldValueKeyFlag.class);
    }

    public boolean isRequired() {
        return this.getFlagAnnotation().required();
    }

    @NonNull
    protected final IDataTypeAdapter<?> getJavaTypeAdapter() {
        return this.javaTypeAdapter;
    }

    public String getFormalName() {
        return ModelUtil.resolveToString(this.getFlagAnnotation().formalName());
    }

    public MarkupLine getDescription() {
        return ModelUtil.resolveToMarkupLine(this.getFlagAnnotation().description());
    }

    public String getUseName() {
        return ModelUtil.resolveToString(this.getFlagAnnotation().useName());
    }

    public String getXmlNamespace() {
        return ModelUtil.resolveOptionalNamespace(this.getFlagAnnotation().namespace(), this.getParentClassBinding());
    }

    public MarkupMultiline getRemarks() {
        return ModelUtil.resolveToMarkupMultiline(this.getFlagAnnotation().remarks());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFlagDefinition getDefinition() {
        DefaultFlagProperty defaultFlagProperty = this;
        synchronized (defaultFlagProperty) {
            if (this.definition == null) {
                this.definition = new InternalFlagDefinition();
            }
            return this.definition;
        }
    }

    @Override
    public String toCoordinates() {
        return String.format("%s Instance(%s): %s:%s", this.getModelType().name().toLowerCase(Locale.ROOT), this.getName(), this.getParentClassBinding().getBoundClass().getName(), this.getField().getName());
    }

    private final class InternalFlagDefinition
    implements IFlagDefinition,
    IValueConstraintFeature {
        private final Lazy<IValueConstraintSupport> constraints = Lazy.lazy(() -> new ValueConstraintSupport(DefaultFlagProperty.this.getField().getAnnotation(ValueConstraints.class), IConstraint.InternalModelSource.instance()));

        private InternalFlagDefinition() {
        }

        @Override
        public IValueConstraintSupport getConstraintSupport() {
            return (IValueConstraintSupport)this.constraints.get();
        }

        public String getFormalName() {
            return DefaultFlagProperty.this.getFormalName();
        }

        public MarkupLine getDescription() {
            return DefaultFlagProperty.this.getDescription();
        }

        @NonNull
        public Map<QName, Set<String>> getProperties() {
            throw new UnsupportedOperationException();
        }

        public IDataTypeAdapter<?> getJavaTypeAdapter() {
            return DefaultFlagProperty.this.getJavaTypeAdapter();
        }

        public Object getDefaultValue() {
            return DefaultFlagProperty.this.getDefaultValue();
        }

        public boolean isInline() {
            return true;
        }

        public IBoundFlagInstance getInlineInstance() {
            return DefaultFlagProperty.this;
        }

        public String getName() {
            return DefaultFlagProperty.this.getJavaFieldName();
        }

        public String getUseName() {
            return null;
        }

        public MarkupMultiline getRemarks() {
            return DefaultFlagProperty.this.getRemarks();
        }

        public String toCoordinates() {
            return DefaultFlagProperty.this.toCoordinates();
        }

        @NonNull
        public ModuleScopeEnum getModuleScope() {
            return ModuleScopeEnum.INHERITED;
        }

        public IMetaschema getContainingMetaschema() {
            return DefaultFlagProperty.this.getContainingMetaschema();
        }
    }
}

