/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.io.BindingException;
import gov.nist.secauto.metaschema.binding.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.json.IJsonWritingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import gov.nist.secauto.metaschema.binding.model.IPropertyCollector;
import gov.nist.secauto.metaschema.model.common.INamedInstance;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public interface IBoundNamedInstance
extends INamedInstance {
    default public String getName() {
        return this.getDefinition().getName();
    }

    @NonNull
    default public Map<QName, Set<String>> getProperties() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public IClassBinding getParentClassBinding();

    @NonNull
    public Field getField();

    @NonNull
    default public String getJavaFieldName() {
        return (String)ObjectUtils.notNull((Object)this.getField().getName());
    }

    @NonNull
    default public Type getType() {
        return this.getField().getGenericType();
    }

    @NonNull
    default public Class<?> getItemType() {
        return (Class)this.getType();
    }

    default public Object getValue(@NonNull Object parentInstance) {
        Object retval;
        Field field = this.getField();
        boolean accessable = field.canAccess(parentInstance);
        field.setAccessible(true);
        try {
            Object result;
            retval = result = field.get(parentInstance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("Unable to get the value of field '%s' in class '%s'.", field.getName(), field.getDeclaringClass().getName()), ex);
        }
        finally {
            field.setAccessible(accessable);
        }
        return retval;
    }

    default public void setValue(@NonNull Object parentInstance, Object value) {
        Field field = this.getField();
        boolean accessable = field.canAccess(parentInstance);
        field.setAccessible(true);
        try {
            field.set(parentInstance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("Unable to set the value of field '%s' in class '%s'.", field.getName(), field.getDeclaringClass().getName()), ex);
        }
        finally {
            field.setAccessible(accessable);
        }
    }

    @NonNull
    public IPropertyCollector newPropertyCollector();

    public boolean read(@NonNull Object var1, @NonNull IJsonParsingContext var2) throws IOException;

    public Object read(@NonNull IJsonParsingContext var1) throws IOException;

    public boolean read(@NonNull Object var1, @NonNull StartElement var2, @NonNull IXmlParsingContext var3) throws IOException, XMLStreamException;

    public boolean write(@NonNull Object var1, @NonNull QName var2, @NonNull IXmlWritingContext var3) throws XMLStreamException, IOException;

    public void write(@NonNull Object var1, @NonNull IJsonWritingContext var2) throws IOException;

    public void copyBoundObject(@NonNull Object var1, @NonNull Object var2) throws BindingException;
}

