/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.io.BindingException;
import gov.nist.secauto.metaschema.binding.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.AbstractModelPropertyInfo;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.IBoundModelDefinition;
import gov.nist.secauto.metaschema.binding.model.IBoundNamedInstance;
import gov.nist.secauto.metaschema.binding.model.IDataTypeHandler;
import gov.nist.secauto.metaschema.binding.model.IModelPropertyInfo;
import gov.nist.secauto.metaschema.binding.model.ListPropertyInfo;
import gov.nist.secauto.metaschema.binding.model.MapPropertyInfo;
import gov.nist.secauto.metaschema.binding.model.SingletonPropertyInfo;
import gov.nist.secauto.metaschema.model.common.INamedModelInstance;
import gov.nist.secauto.metaschema.model.common.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public interface IBoundNamedModelInstance
extends IBoundNamedInstance,
INamedModelInstance {
    @NonNull
    public static Class<?> getItemType(@NonNull Field field) {
        Type fieldType = field.getGenericType();
        Class rawType = (Class)ObjectUtils.notNull((Object)((Class)(fieldType instanceof ParameterizedType ? ((ParameterizedType)fieldType).getRawType() : fieldType)));
        Class itemType = Map.class.isAssignableFrom(rawType) ? (Class)ObjectUtils.notNull((Object)((Class)((ParameterizedType)fieldType).getActualTypeArguments()[1])) : (List.class.isAssignableFrom(rawType) ? (Class)ObjectUtils.notNull((Object)((Class)((ParameterizedType)fieldType).getActualTypeArguments()[0])) : rawType);
        return itemType;
    }

    @Override
    default public Class<?> getItemType() {
        return this.getPropertyInfo().getItemType();
    }

    @Override
    public IAssemblyClassBinding getParentClassBinding();

    public IBoundModelDefinition getDefinition();

    @NonNull
    default public IModelPropertyInfo newPropertyInfo() {
        AbstractModelPropertyInfo retval;
        Type type = this.getType();
        if (this.getMaxOccurs() == -1 || this.getMaxOccurs() > 1) {
            if (!(type instanceof ParameterizedType)) {
                switch (this.getJsonGroupAsBehavior()) {
                    case KEYED: {
                        throw new IllegalStateException(String.format("The field '%s' on class '%s' has data type of '%s', but should have a type of '%s'.", this.getField().getName(), this.getParentClassBinding().getBoundClass().getName(), this.getField().getType().getName(), Map.class.getName()));
                    }
                    case LIST: 
                    case SINGLETON_OR_LIST: {
                        throw new IllegalStateException(String.format("The field '%s' on class '%s' has data type of '%s', but should have a type of '%s'.", this.getField().getName(), this.getParentClassBinding().getBoundClass().getName(), this.getField().getType().getName(), List.class.getName()));
                    }
                }
                throw new IllegalStateException(this.getJsonGroupAsBehavior().name());
            }
            Class rawType = (Class)((ParameterizedType)type).getRawType();
            if (JsonGroupAsBehavior.KEYED.equals((Object)this.getJsonGroupAsBehavior())) {
                if (!Map.class.isAssignableFrom(rawType)) {
                    throw new IllegalArgumentException(String.format("The field '%s' on class '%s' has data type '%s', which is not the expected '%s' derived data type.", this.getField().getName(), this.getParentClassBinding().getBoundClass().getName(), this.getField().getType().getName(), Map.class.getName()));
                }
                retval = new MapPropertyInfo(this);
            } else {
                if (!List.class.isAssignableFrom(rawType)) {
                    throw new IllegalArgumentException(String.format("The field '%s' on class '%s' has data type '%s', which is not the expected '%s' derived data type.", this.getField().getName(), this.getParentClassBinding().getBoundClass().getName(), this.getField().getType().getName(), List.class.getName()));
                }
                retval = new ListPropertyInfo(this);
            }
        } else {
            if (type instanceof ParameterizedType) {
                throw new IllegalStateException(String.format("The field '%s' on class '%s' has a data parmeterized type of '%s', but the occurance is not multi-valued.", this.getField().getName(), this.getParentClassBinding().getBoundClass().getName(), this.getField().getType().getName()));
            }
            retval = new SingletonPropertyInfo(this);
        }
        return retval;
    }

    @NonNull
    public IModelPropertyInfo getPropertyInfo();

    @NonNull
    public IDataTypeHandler getDataTypeHandler();

    @NonNull
    public Collection<? extends Object> getItemValues(Object var1);

    public Object readItem(@Nullable Object var1, @NonNull StartElement var2, @NonNull IXmlParsingContext var3) throws XMLStreamException, IOException;

    @NonNull
    public List<Object> readItem(@Nullable Object var1, boolean var2, @NonNull IJsonParsingContext var3) throws IOException;

    public void writeItem(@NonNull Object var1, @NonNull QName var2, @NonNull IXmlWritingContext var3) throws XMLStreamException, IOException;

    @NonNull
    public Object copyItem(@NonNull Object var1, @NonNull Object var2) throws BindingException;
}

