/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.io.BindingException;
import gov.nist.secauto.metaschema.binding.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.json.IJsonWritingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.AbstractFieldProperty;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import gov.nist.secauto.metaschema.binding.model.IDataTypeHandler;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLStreamWriter2;

class JavaTypeAdapterDataTypeHandler
implements IDataTypeHandler {
    @NonNull
    private final AbstractFieldProperty property;

    public JavaTypeAdapterDataTypeHandler(AbstractFieldProperty property) {
        this.property = (AbstractFieldProperty)ObjectUtils.requireNonNull((Object)property, (String)"property");
    }

    @Override
    public AbstractFieldProperty getProperty() {
        return this.property;
    }

    @Override
    public IDataTypeAdapter<?> getJavaTypeAdapter() {
        return this.getProperty().getDefinition().getJavaTypeAdapter();
    }

    @Override
    public IClassBinding getClassBinding() {
        return null;
    }

    @Override
    public boolean isUnwrappedValueAllowedInXml() {
        return this.getJavaTypeAdapter().isUnrappedValueAllowedInXml();
    }

    @Override
    public List<Object> get(Object parentInstance, boolean requiresJsonKey, IJsonParsingContext context) throws IOException {
        if (requiresJsonKey) {
            throw new IOException("A scalar datatype cannot have a JSON key.");
        }
        Object value = this.getJavaTypeAdapter().parse((JsonParser)context.getReader());
        return CollectionUtil.singletonList((Object)value);
    }

    @Override
    public Object get(Object parentInstance, StartElement start, IXmlParsingContext context) throws IOException, XMLStreamException {
        return this.getJavaTypeAdapter().parse((XMLEventReader2)context.getReader());
    }

    @Override
    public void accept(Object item, QName currentParentName, IXmlWritingContext context) throws IOException, XMLStreamException {
        this.getJavaTypeAdapter().writeXmlValue(item, currentParentName, (XMLStreamWriter2)context.getWriter());
    }

    @Override
    public void writeItems(Collection<? extends Object> items, boolean writeObjectWrapper, IJsonWritingContext context) throws IOException {
        for (Object object : items) {
            this.getJavaTypeAdapter().writeJsonValue(ObjectUtils.requireNonNull((Object)object), (JsonGenerator)context.getWriter());
        }
    }

    @Override
    public Object copyItem(@NonNull Object fromItem, Object parentInstance) throws BindingException {
        return this.getJavaTypeAdapter().copy(fromItem);
    }
}

