/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.io.BindingException;
import gov.nist.secauto.metaschema.binding.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.json.IJsonWritingContext;
import gov.nist.secauto.metaschema.binding.io.json.JsonUtil;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.AbstractModelPropertyInfo;
import gov.nist.secauto.metaschema.binding.model.IBoundNamedModelInstance;
import gov.nist.secauto.metaschema.binding.model.IPropertyCollector;
import gov.nist.secauto.metaschema.binding.model.ListPropertyCollector;
import gov.nist.secauto.metaschema.model.common.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.common.util.XmlEventUtil;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax2.XMLEventReader2;

class ListPropertyInfo
extends AbstractModelPropertyInfo {
    public ListPropertyInfo(@NonNull IBoundNamedModelInstance property) {
        super(property);
    }

    @Override
    public Class<?> getItemType() {
        ParameterizedType actualType = (ParameterizedType)this.getProperty().getType();
        return (Class)ObjectUtils.notNull((Object)((Class)actualType.getActualTypeArguments()[0]));
    }

    @Override
    public ListPropertyCollector newPropertyCollector() {
        return new ListPropertyCollector();
    }

    public List<? extends Object> getItemsFromParentInstance(Object parentInstance) {
        Object value = this.getProperty().getValue(parentInstance);
        return this.getItemsFromValue(value);
    }

    public List<? extends Object> getItemsFromValue(Object value) {
        return value == null ? CollectionUtil.emptyList() : (List)value;
    }

    @Override
    public int getItemCount(Object value) {
        return value == null ? 0 : ((List)value).size();
    }

    @Override
    public boolean readValue(IPropertyCollector collector, Object parentInstance, StartElement start, IXmlParsingContext context) throws IOException, XMLStreamException {
        XMLEvent event;
        XMLEventReader2 eventReader = (XMLEventReader2)context.getReader();
        XmlEventUtil.skipWhitespace((XMLEventReader2)eventReader);
        QName expectedFieldItemQName = this.getProperty().getXmlQName();
        boolean handled = false;
        while ((event = eventReader.peek()).isStartElement() && expectedFieldItemQName.equals(event.asStartElement().getName())) {
            Object value = this.getProperty().readItem(parentInstance, start, context);
            if (value != null) {
                collector.add(value);
                handled = true;
            }
            XmlEventUtil.skipWhitespace((XMLEventReader2)eventReader);
        }
        return handled;
    }

    @Override
    public void readValue(IPropertyCollector collector, Object parentInstance, IJsonParsingContext context) throws IOException {
        JsonParser parser = (JsonParser)context.getReader();
        if (JsonGroupAsBehavior.SINGLETON_OR_LIST.equals((Object)this.getProperty().getJsonGroupAsBehavior()) && !JsonToken.START_ARRAY.equals((Object)parser.currentToken())) {
            IBoundNamedModelInstance property = this.getProperty();
            List<Object> values = property.readItem(parentInstance, false, context);
            collector.addAll(values);
        } else if (JsonToken.VALUE_NULL.equals((Object)parser.currentToken())) {
            JsonUtil.assertAndAdvance(parser, JsonToken.VALUE_NULL);
        } else {
            JsonUtil.assertAndAdvance(parser, JsonToken.START_ARRAY);
            while (!JsonToken.END_ARRAY.equals((Object)parser.currentToken())) {
                List<Object> values = this.getProperty().readItem(parentInstance, false, context);
                collector.addAll(values);
            }
            JsonUtil.assertAndAdvance(parser, JsonToken.END_ARRAY);
        }
    }

    @Override
    public void writeValue(Object value, QName parentName, IXmlWritingContext context) throws XMLStreamException, IOException {
        IBoundNamedModelInstance property = this.getProperty();
        Collection items = this.getItemsFromValue(value);
        for (Object item : items) {
            property.writeItem(ObjectUtils.requireNonNull(item), parentName, context);
        }
    }

    @Override
    public void writeValue(Object parentInstance, IJsonWritingContext context) throws IOException {
        Collection items = this.getItemsFromParentInstance(parentInstance);
        JsonGenerator writer = (JsonGenerator)context.getWriter();
        boolean writeArray = false;
        if (JsonGroupAsBehavior.LIST.equals((Object)this.getProperty().getJsonGroupAsBehavior()) || JsonGroupAsBehavior.SINGLETON_OR_LIST.equals((Object)this.getProperty().getJsonGroupAsBehavior()) && items.size() > 1) {
            writeArray = true;
            writer.writeStartArray();
        }
        this.getProperty().getDataTypeHandler().writeItems(items, true, context);
        if (writeArray) {
            writer.writeEndArray();
        }
    }

    @Override
    public boolean isValueSet(Object parentInstance) throws IOException {
        Collection items = this.getItemsFromParentInstance(parentInstance);
        return !items.isEmpty();
    }

    @Override
    public void copy(@NonNull Object fromInstance, @NonNull Object toInstance, @NonNull IPropertyCollector collector) throws BindingException {
        IBoundNamedModelInstance property = this.getProperty();
        for (Object item : this.getItemsFromParentInstance(fromInstance)) {
            collector.add(property.copyItem(ObjectUtils.requireNonNull(item), toInstance));
        }
    }
}

