/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.binding.io.BindingException;
import gov.nist.secauto.metaschema.binding.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.json.IJsonWritingContext;
import gov.nist.secauto.metaschema.binding.io.json.JsonUtil;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.AbstractModelPropertyInfo;
import gov.nist.secauto.metaschema.binding.model.IBoundFlagInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundNamedModelInstance;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import gov.nist.secauto.metaschema.binding.model.IPropertyCollector;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.common.util.XmlEventUtil;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax2.XMLEventReader2;

class MapPropertyInfo
extends AbstractModelPropertyInfo {
    public Collection<?> getItemsFromValue(Object value) {
        return value == null ? List.of() : ((Map)value).values();
    }

    @Override
    public int getItemCount(Object value) {
        return value == null ? 0 : ((Map)value).size();
    }

    public MapPropertyInfo(@NonNull IBoundNamedModelInstance property) {
        super(property);
    }

    @NonNull
    public Class<?> getKeyType() {
        ParameterizedType actualType = (ParameterizedType)this.getProperty().getType();
        return (Class)actualType.getActualTypeArguments()[0];
    }

    @Override
    public Class<?> getItemType() {
        return this.getValueType();
    }

    @NonNull
    public Class<?> getValueType() {
        ParameterizedType actualType = (ParameterizedType)this.getProperty().getType();
        return (Class)actualType.getActualTypeArguments()[1];
    }

    @Override
    public IPropertyCollector newPropertyCollector() {
        return new MapPropertyCollector(this.getProperty());
    }

    @Override
    public void readValue(IPropertyCollector collector, Object parentInstance, IJsonParsingContext context) throws IOException {
        JsonParser jsonParser = (JsonParser)context.getReader();
        JsonUtil.assertAndAdvance(jsonParser, JsonToken.START_OBJECT);
        IBoundNamedModelInstance property = this.getProperty();
        while (!JsonToken.END_OBJECT.equals((Object)jsonParser.currentToken())) {
            JsonUtil.assertCurrent(jsonParser, JsonToken.FIELD_NAME);
            List<Object> values = property.readItem(parentInstance, true, context);
            collector.addAll(values);
            JsonUtil.assertCurrent(jsonParser, JsonToken.FIELD_NAME, JsonToken.END_OBJECT);
        }
        JsonUtil.assertAndAdvance(jsonParser, JsonToken.END_OBJECT);
    }

    @Override
    public boolean readValue(IPropertyCollector collector, Object parentInstance, StartElement start, IXmlParsingContext context) throws IOException, XMLStreamException {
        XMLEvent event;
        QName qname = this.getProperty().getXmlQName();
        XMLEventReader2 eventReader = (XMLEventReader2)context.getReader();
        XmlEventUtil.skipWhitespace((XMLEventReader2)eventReader);
        boolean handled = false;
        while ((event = eventReader.peek()).isStartElement() && qname.equals(event.asStartElement().getName())) {
            Object value = this.getProperty().readItem(parentInstance, start, context);
            if (value != null) {
                collector.add(value);
                handled = true;
            }
            XmlEventUtil.skipWhitespace((XMLEventReader2)eventReader);
        }
        return handled;
    }

    @Override
    public void writeValue(Object value, QName parentName, IXmlWritingContext context) throws XMLStreamException, IOException {
        IBoundNamedModelInstance property = this.getProperty();
        Map items = (Map)value;
        for (Object item : items.values()) {
            property.writeItem(ObjectUtils.notNull(item), parentName, context);
        }
    }

    @Override
    public void writeValue(Object parentInstance, IJsonWritingContext context) throws IOException {
        Collection<? extends Object> items = this.getItemsFromParentInstance(parentInstance);
        if (!items.isEmpty()) {
            JsonGenerator writer = (JsonGenerator)context.getWriter();
            writer.writeStartObject();
            this.getProperty().getDataTypeHandler().writeItems(items, false, context);
            writer.writeEndObject();
        }
    }

    @Override
    public boolean isValueSet(Object parentInstance) throws IOException {
        Collection<? extends Object> items = this.getItemsFromParentInstance(parentInstance);
        return !items.isEmpty();
    }

    @Override
    public void copy(@NonNull Object fromInstance, @NonNull Object toInstance, @NonNull IPropertyCollector collector) throws BindingException {
        IBoundNamedModelInstance property = this.getProperty();
        for (Object object : this.getItemsFromParentInstance(fromInstance)) {
            collector.add(property.copyItem(ObjectUtils.requireNonNull((Object)object), toInstance));
        }
    }

    public static class MapPropertyCollector
    implements IPropertyCollector {
        @NonNull
        private final Map<String, Object> map = new LinkedHashMap<String, Object>();
        @Nullable
        private final IBoundFlagInstance jsonKey;

        protected MapPropertyCollector(IBoundNamedModelInstance property) {
            IClassBinding classBinding = property.getDataTypeHandler().getClassBinding();
            IBoundFlagInstance iBoundFlagInstance = this.jsonKey = classBinding == null ? null : classBinding.getJsonKeyFlagInstance();
            if (this.jsonKey == null) {
                throw new IllegalStateException("No JSON key found");
            }
        }

        protected IBoundFlagInstance getJsonKey() {
            return this.jsonKey;
        }

        @Override
        public void add(Object item) {
            assert (item != null);
            String key = this.getJsonKey().getValue(item).toString();
            this.map.put(key, item);
        }

        @Override
        public void addAll(Collection<?> items) {
            for (Object item : items) {
                this.add(ObjectUtils.requireNonNull(item));
            }
        }

        @Override
        @NonNull
        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="this is a data holder")
        public Map<String, Object> getValue() {
            return this.map;
        }
    }
}

