/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.model.IClassBinding;
import gov.nist.secauto.metaschema.binding.model.annotations.NullJavaTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.adapter.MetaschemaDataTypeProvider;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;

public final class ModelUtil {
    private ModelUtil() {
    }

    public static String resolveLocalName(String value, String defaultValue) {
        Object retval = value == null || "##default".equals(value) ? defaultValue : ("##none".equals(value) ? null : value);
        return retval;
    }

    @Nullable
    public static String resolveOptionalNamespace(String annotationValue, IClassBinding classBinding) {
        return ModelUtil.resolveNamespace(annotationValue, classBinding, true);
    }

    @NonNull
    public static String resolveNamespace(String annotationValue, IClassBinding classBinding) {
        return (String)ObjectUtils.notNull((Object)ModelUtil.resolveNamespace(annotationValue, classBinding, false));
    }

    private static String resolveNamespace(String value, IClassBinding classBinding, boolean allowNone) {
        Object retval = value == null || "##default".equals(value) ? classBinding.getContainingMetaschema().getXmlNamespace().toASCIIString() : (allowNone && "##none".equals(value) ? null : value);
        return retval;
    }

    @Nullable
    public static MarkupLine resolveToMarkupLine(@NonNull String annotationValue) {
        return "##none".equals(annotationValue) ? null : MarkupLine.fromMarkdown((String)annotationValue);
    }

    @Nullable
    public static MarkupMultiline resolveToMarkupMultiline(@NonNull String annotationValue) {
        return "##none".equals(annotationValue) ? null : MarkupMultiline.fromMarkdown((String)annotationValue);
    }

    @Nullable
    public static String resolveToString(@NonNull String annotationValue) {
        return "##none".equals(annotationValue) ? null : annotationValue;
    }

    @NonNull
    public static IDataTypeAdapter<?> getDataTypeAdapter(@NonNull Class<? extends IDataTypeAdapter<?>> adapterClass, IBindingContext bindingContext) {
        Object retval = NullJavaTypeAdapter.class.equals(adapterClass) ? MetaschemaDataTypeProvider.DEFAULT_DATA_TYPE : (IDataTypeAdapter)ObjectUtils.requireNonNull(bindingContext.getJavaTypeAdapterInstance(adapterClass));
        return retval;
    }

    @Nullable
    public static Object resolveDefaultValue(@NonNull String defaultValue, IDataTypeAdapter<?> adapter) {
        Object retval = null;
        if (!"\u0000".equals(defaultValue)) {
            retval = adapter.parse(defaultValue);
        }
        return retval;
    }
}

