/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.io.BindingException;
import gov.nist.secauto.metaschema.binding.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.json.IJsonProblemHandler;
import gov.nist.secauto.metaschema.binding.io.json.IJsonWritingContext;
import gov.nist.secauto.metaschema.binding.io.json.JsonUtil;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.IBoundAssemblyInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundFieldInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundFlagInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundNamedInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundNamedModelInstance;
import gov.nist.secauto.metaschema.binding.model.IRootAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.RootAssemblyDefinitionWrapper;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.common.util.XmlEventUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLStreamWriter2;

public class RootAssemblyDefinition
extends RootAssemblyDefinitionWrapper<IAssemblyClassBinding>
implements IRootAssemblyClassBinding {
    private static final Logger LOGGER = LogManager.getLogger(RootAssemblyDefinition.class);

    public RootAssemblyDefinition(@NonNull IAssemblyClassBinding rootDefinition) {
        super((IAssemblyDefinition)rootDefinition);
    }

    @Override
    public Object readObject(@NonNull IJsonParsingContext context) throws IOException {
        return ((IAssemblyClassBinding)this.getRootDefinition()).readObject(context);
    }

    @Override
    public IBindingContext getBindingContext() {
        return ((IAssemblyClassBinding)this.getRootDefinition()).getBindingContext();
    }

    @Override
    public Class<?> getBoundClass() {
        return ((IAssemblyClassBinding)this.getRootDefinition()).getBoundClass();
    }

    @Override
    public IBoundFlagInstance getJsonKeyFlagInstance() {
        return null;
    }

    @Override
    public Map<String, ? extends IBoundNamedInstance> getNamedInstances(Predicate<IBoundFlagInstance> flagFilter) {
        return ((IAssemblyClassBinding)this.getRootDefinition()).getNamedInstances(flagFilter);
    }

    @Override
    public List<Object> readItem(Object parentInstance, boolean requiresJsonKey, IJsonParsingContext context) throws IOException {
        return ((IAssemblyClassBinding)this.getRootDefinition()).readItem(parentInstance, requiresJsonKey, context);
    }

    @Override
    public Object readItem(Object parentInstance, StartElement start, IXmlParsingContext context) throws IOException, XMLStreamException {
        return ((IAssemblyClassBinding)this.getRootDefinition()).readItem(parentInstance, start, context);
    }

    @Override
    public void writeItem(Object item, QName parentName, IXmlWritingContext context) throws IOException, XMLStreamException {
        ((IAssemblyClassBinding)this.getRootDefinition()).writeItem(item, parentName, context);
    }

    @Override
    public void writeItems(Collection<? extends Object> items, boolean writeObjectWrapper, IJsonWritingContext context) throws IOException {
        ((IAssemblyClassBinding)this.getRootDefinition()).writeItems(items, writeObjectWrapper, context);
    }

    @Override
    public Object copyBoundObject(Object item, Object parentInstance) throws BindingException {
        return ((IAssemblyClassBinding)this.getRootDefinition()).copyBoundObject(item, parentInstance);
    }

    @Override
    public IBoundFlagInstance getFlagInstanceByName(String name) {
        return ((IAssemblyClassBinding)this.getRootDefinition()).getFlagInstanceByName(name);
    }

    @Override
    public Collection<? extends IBoundFlagInstance> getFlagInstances() {
        return ((IAssemblyClassBinding)this.getRootDefinition()).getFlagInstances();
    }

    @Override
    public Collection<? extends IBoundNamedModelInstance> getModelInstances() {
        return ((IAssemblyClassBinding)this.getRootDefinition()).getModelInstances();
    }

    @Override
    public Collection<? extends IBoundNamedModelInstance> getNamedModelInstances() {
        return ((IAssemblyClassBinding)this.getRootDefinition()).getNamedModelInstances();
    }

    @Override
    public IBoundNamedModelInstance getModelInstanceByName(String name) {
        return ((IAssemblyClassBinding)this.getRootDefinition()).getModelInstanceByName(name);
    }

    @Override
    public Collection<? extends IBoundFieldInstance> getFieldInstances() {
        return ((IAssemblyClassBinding)this.getRootDefinition()).getFieldInstances();
    }

    @Override
    public IBoundFieldInstance getFieldInstanceByName(String name) {
        return ((IAssemblyClassBinding)this.getRootDefinition()).getFieldInstanceByName(name);
    }

    @Override
    public Collection<? extends IBoundAssemblyInstance> getAssemblyInstances() {
        return ((IAssemblyClassBinding)this.getRootDefinition()).getAssemblyInstances();
    }

    @Override
    public IBoundAssemblyInstance getAssemblyInstanceByName(String name) {
        return ((IAssemblyClassBinding)this.getRootDefinition()).getAssemblyInstanceByName(name);
    }

    @Override
    public Object readRoot(IXmlParsingContext context) throws IOException, XMLStreamException {
        XMLEventReader2 reader = (XMLEventReader2)context.getReader();
        if (reader.peek().isStartDocument()) {
            XmlEventUtil.consumeAndAssert((XMLEventReader2)reader, (int)7);
        }
        XmlEventUtil.skipEvents((XMLEventReader2)reader, (int[])new int[]{4, 3});
        QName rootQName = this.getRootXmlQName();
        if (!reader.peek().isStartElement()) {
            throw new IOException(String.format("Expected an element named '%s', but found a '%s' instead.", rootQName, XmlEventUtil.toString((XMLEvent)reader.peek())));
        }
        XmlEventUtil.assertNext((XMLEventReader2)reader, (int)1, (QName)rootQName);
        StartElement start = (StartElement)ObjectUtils.notNull((Object)reader.nextEvent().asStartElement());
        Object result = ObjectUtils.requireNonNull((Object)this.readItem(null, start, context));
        XmlEventUtil.consumeAndAssert((XMLEventReader2)reader, (int)2, (QName)rootQName);
        return result;
    }

    @Override
    public Object readRoot(IJsonParsingContext context) throws IOException {
        JsonToken token;
        if (!this.isRoot()) {
            throw new IOException(String.format("The bound assembly '%s' does not have a root defined in the '%s' annotation.", this.getBoundClass().getName(), MetaschemaAssembly.class.getName()));
        }
        JsonParser parser = (JsonParser)context.getReader();
        boolean objectWrapper = false;
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (JsonToken.START_OBJECT.equals((Object)parser.currentToken())) {
            JsonUtil.assertAndAdvance(parser, JsonToken.START_OBJECT);
            objectWrapper = true;
        }
        String rootFieldName = this.getRootJsonName();
        Object instance = null;
        while (!JsonToken.END_OBJECT.equals((Object)(token = parser.currentToken())) && token != null) {
            if (!JsonToken.FIELD_NAME.equals((Object)token)) {
                throw new IOException(String.format("Expected FIELD_NAME token, found '%s'", token.toString()));
            }
            String fieldName = parser.currentName();
            if (fieldName.equals(rootFieldName)) {
                JsonUtil.assertAndAdvance(parser, JsonToken.FIELD_NAME);
                instance = this.readObject(context);
                break;
            }
            if (((IJsonProblemHandler)context.getProblemHandler()).handleUnknownRootProperty(this, fieldName, context)) continue;
            LOGGER.warn("Skipping unhandled top-level JSON field '{}'.", (Object)fieldName);
            JsonUtil.skipNextValue(parser);
        }
        if (instance == null) {
            throw new IOException(String.format("Failed to find root field '%s'.", rootFieldName));
        }
        if (objectWrapper) {
            JsonUtil.assertAndAdvance(parser, JsonToken.END_OBJECT);
        }
        return instance;
    }

    @Override
    public void writeRoot(Object instance, IXmlWritingContext context) throws XMLStreamException, IOException {
        XMLStreamWriter2 writer = (XMLStreamWriter2)context.getWriter();
        writer.writeStartDocument("UTF-8", "1.0");
        QName rootQName = this.getRootXmlQName();
        NamespaceContext nsContext = writer.getNamespaceContext();
        String prefix = nsContext.getPrefix(rootQName.getNamespaceURI());
        if (prefix == null) {
            prefix = "";
        }
        writer.writeStartElement(prefix, rootQName.getLocalPart(), rootQName.getNamespaceURI());
        this.writeItem(instance, rootQName, context);
        writer.writeEndElement();
    }

    @Override
    public void writeRoot(Object instance, IJsonWritingContext context) throws IOException {
        JsonGenerator writer = (JsonGenerator)context.getWriter();
        writer.writeStartObject();
        writer.writeFieldName(this.getRootJsonName());
        this.writeItems(CollectionUtil.singleton((Object)instance), true, context);
        writer.writeEndObject();
    }
}

