/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.model.AbstractFieldProperty;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.binding.model.IBoundFieldDefinition;
import gov.nist.secauto.metaschema.binding.model.IBoundFieldInstance;
import gov.nist.secauto.metaschema.binding.model.IBoundFlagInstance;
import gov.nist.secauto.metaschema.binding.model.IDataTypeHandler;
import gov.nist.secauto.metaschema.binding.model.IValueConstraintFeature;
import gov.nist.secauto.metaschema.binding.model.JavaTypeAdapterDataTypeHandler;
import gov.nist.secauto.metaschema.binding.model.ModelUtil;
import gov.nist.secauto.metaschema.binding.model.ValueConstraintSupport;
import gov.nist.secauto.metaschema.binding.model.annotations.BoundFieldValue;
import gov.nist.secauto.metaschema.binding.model.annotations.ValueConstraints;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.ModuleScopeEnum;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IValueConstraintSupport;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.adapter.MetaschemaDataTypeProvider;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import nl.talsmasoftware.lazy4j.Lazy;

class SimpleFieldProperty
extends AbstractFieldProperty {
    @NonNull
    private final IDataTypeAdapter<?> javaTypeAdapter;
    @Nullable
    private final Object defaultValue;
    @NonNull
    private final Lazy<ScalarFieldDefinition> definition;

    public SimpleFieldProperty(@NonNull Field field, @NonNull IAssemblyClassBinding parentClassBinding) {
        super(field, parentClassBinding);
        BoundFieldValue boundFieldValue = field.getAnnotation(BoundFieldValue.class);
        if (boundFieldValue == null) {
            this.javaTypeAdapter = MetaschemaDataTypeProvider.DEFAULT_DATA_TYPE;
            this.defaultValue = null;
        } else {
            this.javaTypeAdapter = ModelUtil.getDataTypeAdapter(boundFieldValue.typeAdapter(), parentClassBinding.getBindingContext());
            this.defaultValue = ModelUtil.resolveDefaultValue(boundFieldValue.defaultValue(), this.javaTypeAdapter);
        }
        Class<?> itemType = this.getItemType();
        if (!itemType.equals(this.javaTypeAdapter.getJavaClass())) {
            throw new IllegalStateException(String.format("Field '%s' on class '%s' has the '%s' type adapter configured, but the field's item type '%s' does not match the adapter's type '%s'.", this.getName(), this.getContainingDefinition().getBoundClass().getName(), this.javaTypeAdapter.getClass().getName(), itemType.getName(), this.javaTypeAdapter.getJavaClass().getName()));
        }
        this.definition = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> new ScalarFieldDefinition()));
    }

    @Override
    public IBoundFieldDefinition getDefinition() {
        return (IBoundFieldDefinition)ObjectUtils.notNull((Object)((ScalarFieldDefinition)this.definition.get()));
    }

    public IDataTypeAdapter<?> getJavaTypeAdapter() {
        return this.javaTypeAdapter;
    }

    @Override
    protected IDataTypeHandler newDataTypeHandler() {
        return new JavaTypeAdapterDataTypeHandler(this);
    }

    @Override
    public boolean isInXmlWrapped() {
        return this.getFieldAnnotation().inXmlWrapped();
    }

    public boolean isSimple() {
        return true;
    }

    protected Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getUseName() {
        return ModelUtil.resolveToString(this.getFieldAnnotation().useName());
    }

    private final class ScalarFieldDefinition
    implements IBoundFieldDefinition,
    IValueConstraintFeature {
        private final Lazy<IValueConstraintSupport> constraints = Lazy.lazy(() -> new ValueConstraintSupport(SimpleFieldProperty.this.getField().getAnnotation(ValueConstraints.class), IConstraint.InternalModelSource.instance()));

        private ScalarFieldDefinition() {
        }

        @Override
        public IValueConstraintSupport getConstraintSupport() {
            return (IValueConstraintSupport)this.constraints.get();
        }

        @Override
        @NonNull
        public Object getFieldValue(@NonNull Object item) {
            return item;
        }

        public IDataTypeAdapter<?> getJavaTypeAdapter() {
            return (IDataTypeAdapter)ObjectUtils.notNull(SimpleFieldProperty.this.getJavaTypeAdapter());
        }

        public boolean isInline() {
            return true;
        }

        public IBoundFieldInstance getInlineInstance() {
            return SimpleFieldProperty.this;
        }

        public String getFormalName() {
            return SimpleFieldProperty.this.getFormalName();
        }

        public MarkupLine getDescription() {
            return SimpleFieldProperty.this.getDescription();
        }

        public String getName() {
            return SimpleFieldProperty.this.getJavaFieldName();
        }

        public String getUseName() {
            return ModelUtil.resolveToString(SimpleFieldProperty.this.getFieldAnnotation().useName());
        }

        public MarkupMultiline getRemarks() {
            return SimpleFieldProperty.this.getRemarks();
        }

        public String toCoordinates() {
            return SimpleFieldProperty.this.toCoordinates();
        }

        @Override
        public IBoundFlagInstance getFlagInstanceByName(String name) {
            return null;
        }

        @Override
        public Collection<? extends IBoundFlagInstance> getFlagInstances() {
            return CollectionUtil.emptyList();
        }

        public boolean hasJsonKey() {
            return false;
        }

        public IFlagInstance getJsonKeyFlagInstance() {
            return null;
        }

        public IFlagInstance getJsonValueKeyFlagInstance() {
            return null;
        }

        public String getJsonValueKeyName() {
            return this.getJavaTypeAdapter().getDefaultJsonValueKey();
        }

        public boolean isCollapsible() {
            return false;
        }

        @NonNull
        public ModuleScopeEnum getModuleScope() {
            return ModuleScopeEnum.INHERITED;
        }

        public IMetaschema getContainingMetaschema() {
            return SimpleFieldProperty.this.getContainingMetaschema();
        }

        public Object getDefaultValue() {
            return SimpleFieldProperty.this.getDefaultValue();
        }
    }
}

