/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.model.IPropertyCollector;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.util.Collection;

class SingletonPropertyCollector
implements IPropertyCollector {
    private Object object;

    SingletonPropertyCollector() {
    }

    @Override
    public void add(Object item) {
        if (this.object != null) {
            throw new IllegalStateException("A value has already been set for this singleton");
        }
        this.object = item;
    }

    @Override
    public void addAll(Collection<?> items) {
        int size = items.size();
        if (size > 1) {
            throw new IllegalStateException("Multiple values cannot be set for this singleton");
        }
        if (size == 1) {
            this.add(ObjectUtils.notNull(items.iterator().next()));
        }
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.object;
    }
}

