/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.io.BindingException;
import gov.nist.secauto.metaschema.binding.io.json.IJsonParsingContext;
import gov.nist.secauto.metaschema.binding.io.json.IJsonWritingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.binding.io.xml.IXmlWritingContext;
import gov.nist.secauto.metaschema.binding.model.AbstractModelPropertyInfo;
import gov.nist.secauto.metaschema.binding.model.IBoundNamedModelInstance;
import gov.nist.secauto.metaschema.binding.model.IPropertyCollector;
import gov.nist.secauto.metaschema.binding.model.SingletonPropertyCollector;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

class SingletonPropertyInfo
extends AbstractModelPropertyInfo {
    public SingletonPropertyInfo(@NonNull IBoundNamedModelInstance property) {
        super(property);
    }

    public List<?> getItemsFromValue(Object value) {
        return value == null ? List.of() : List.of(value);
    }

    @Override
    public int getItemCount(Object value) {
        return value == null ? 0 : 1;
    }

    @Override
    public void readValue(IPropertyCollector collector, Object parentInstance, IJsonParsingContext context) throws IOException {
        IBoundNamedModelInstance property = this.getProperty();
        List<Object> values = property.readItem(parentInstance, false, context);
        collector.addAll(values);
    }

    @Override
    public boolean readValue(IPropertyCollector collector, Object parentInstance, StartElement start, IXmlParsingContext context) throws IOException, XMLStreamException {
        boolean handled = true;
        Object value = this.getProperty().readItem(parentInstance, start, context);
        if (value != null) {
            collector.add(value);
            handled = true;
        }
        return handled;
    }

    @Override
    public Class<?> getItemType() {
        return (Class)this.getProperty().getType();
    }

    @Override
    public IPropertyCollector newPropertyCollector() {
        return new SingletonPropertyCollector();
    }

    @Override
    public void writeValue(@NonNull Object value, QName parentName, IXmlWritingContext context) throws XMLStreamException, IOException {
        this.getProperty().writeItem(value, parentName, context);
    }

    @Override
    public void writeValue(Object parentInstance, IJsonWritingContext context) throws IOException {
        IBoundNamedModelInstance property = this.getProperty();
        this.getProperty().getDataTypeHandler().writeItems(CollectionUtil.singleton((Object)ObjectUtils.requireNonNull((Object)property.getValue(parentInstance))), true, context);
    }

    @Override
    public boolean isValueSet(Object parentInstance) throws IOException {
        return this.getProperty().getValue(parentInstance) != null;
    }

    @Override
    public void copy(@NonNull Object fromInstance, @NonNull Object toInstance, @NonNull IPropertyCollector collector) throws BindingException {
        IBoundNamedModelInstance property = this.getProperty();
        Object value = property.getValue(fromInstance);
        Object copiedValue = property.copyItem(ObjectUtils.requireNonNull((Object)value), toInstance);
        collector.add(copiedValue);
    }
}

