/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.binding.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.model.ConstraintFactory;
import gov.nist.secauto.metaschema.binding.model.annotations.ValueConstraints;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IExpectConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IMatchesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IValueConstraintSupport;
import gov.nist.secauto.metaschema.model.common.metapath.MetapathException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

class ValueConstraintSupport
implements IValueConstraintSupport {
    @NonNull
    private final List<IConstraint> constraints;
    @NonNull
    private final List<IAllowedValuesConstraint> allowedValuesConstraints;
    @NonNull
    private final List<IMatchesConstraint> matchesConstraints;
    @NonNull
    private final List<IIndexHasKeyConstraint> indexHasKeyConstraints;
    @NonNull
    private final List<IExpectConstraint> expectConstraints;

    public ValueConstraintSupport() {
        this.constraints = new LinkedList<IConstraint>();
        this.allowedValuesConstraints = new LinkedList<IAllowedValuesConstraint>();
        this.matchesConstraints = new LinkedList<IMatchesConstraint>();
        this.indexHasKeyConstraints = new LinkedList<IIndexHasKeyConstraint>();
        this.expectConstraints = new LinkedList<IExpectConstraint>();
    }

    public ValueConstraintSupport(@Nullable ValueConstraints valueAnnotation, @NonNull IConstraint.ISource source) {
        if (valueAnnotation == null) {
            this.allowedValuesConstraints = new LinkedList<IAllowedValuesConstraint>();
            this.matchesConstraints = new LinkedList<IMatchesConstraint>();
            this.indexHasKeyConstraints = new LinkedList<IIndexHasKeyConstraint>();
            this.expectConstraints = new LinkedList<IExpectConstraint>();
        } else {
            try {
                this.allowedValuesConstraints = Arrays.stream(valueAnnotation.allowedValues()).map(annotation -> ConstraintFactory.newAllowedValuesConstraint(annotation, source)).collect(Collectors.toCollection(LinkedList::new));
                this.matchesConstraints = Arrays.stream(valueAnnotation.matches()).map(annotation -> ConstraintFactory.newMatchesConstraint(annotation, source)).collect(Collectors.toCollection(LinkedList::new));
                this.indexHasKeyConstraints = Arrays.stream(valueAnnotation.indexHasKey()).map(annotation -> ConstraintFactory.newIndexHasKeyConstraint(annotation, source)).collect(Collectors.toCollection(LinkedList::new));
                this.expectConstraints = Arrays.stream(valueAnnotation.expect()).map(annotation -> ConstraintFactory.newExpectConstraint(annotation, source)).collect(Collectors.toCollection(LinkedList::new));
            }
            catch (MetapathException ex) {
                throw new MetapathException(String.format("Unable to compile a Metapath in '%s'. %s", source.getSource(), ex.getLocalizedMessage()), (Throwable)ex);
            }
        }
        this.constraints = new LinkedList<IConstraint>();
        this.constraints.addAll(this.allowedValuesConstraints);
        this.constraints.addAll(this.matchesConstraints);
        this.constraints.addAll(this.indexHasKeyConstraints);
        this.constraints.addAll(this.expectConstraints);
    }

    public List<IConstraint> getConstraints() {
        return this.constraints;
    }

    public List<IAllowedValuesConstraint> getAllowedValuesConstraints() {
        return this.allowedValuesConstraints;
    }

    public List<IMatchesConstraint> getMatchesConstraints() {
        return this.matchesConstraints;
    }

    public List<IIndexHasKeyConstraint> getIndexHasKeyConstraints() {
        return this.indexHasKeyConstraints;
    }

    public List<IExpectConstraint> getExpectConstraints() {
        return this.expectConstraints;
    }

    public void addConstraint(@NonNull IAllowedValuesConstraint constraint) {
        this.constraints.add((IConstraint)constraint);
        this.allowedValuesConstraints.add(constraint);
    }

    public void addConstraint(@NonNull IMatchesConstraint constraint) {
        this.constraints.add((IConstraint)constraint);
        this.matchesConstraints.add(constraint);
    }

    public void addConstraint(@NonNull IIndexHasKeyConstraint constraint) {
        this.constraints.add((IConstraint)constraint);
        this.indexHasKeyConstraints.add(constraint);
    }

    public void addConstraint(@NonNull IExpectConstraint constraint) {
        this.constraints.add((IConstraint)constraint);
        this.expectConstraints.add(constraint);
    }
}

