/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.codegen.IDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.IInstanceTypeInfo;
import gov.nist.secauto.metaschema.codegen.ITypeInfo;
import gov.nist.secauto.metaschema.codegen.ITypeResolver;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.INamedInstance;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class AbstractDefinitionTypeInfo<DEF extends IDefinition>
implements IDefinitionTypeInfo {
    private static final Logger LOGGER = LogManager.getLogger(AbstractDefinitionTypeInfo.class);
    @NonNull
    private final DEF definition;
    @NonNull
    private final ITypeResolver typeResolver;
    @NonNull
    private final Map<String, ITypeInfo> propertyNameToInstanceTypeInfoMap = new LinkedHashMap<String, ITypeInfo>();
    @NonNull
    private final Map<INamedInstance, IInstanceTypeInfo> instanceToInstanceTypeInfoMap = new LinkedHashMap<INamedInstance, IInstanceTypeInfo>();

    public AbstractDefinitionTypeInfo(@NonNull DEF definition, @NonNull ITypeResolver typeResolver) {
        this.definition = definition;
        this.typeResolver = typeResolver;
    }

    public DEF getDefinition() {
        return this.definition;
    }

    @Override
    public ITypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    protected abstract boolean initInstanceTypeInfos();

    protected final void addPropertyTypeInfo(@NonNull ITypeInfo typeInfo) {
        String name = typeInfo.getPropertyName();
        ITypeInfo oldContext = this.propertyNameToInstanceTypeInfoMap.put(name, typeInfo);
        if (oldContext != null) {
            String msg = String.format("Unexpected duplicate property name '%s'", name);
            LOGGER.error(msg);
            throw new IllegalArgumentException(msg);
        }
        if (typeInfo instanceof IInstanceTypeInfo) {
            IInstanceTypeInfo instanceTypeInfo = (IInstanceTypeInfo)typeInfo;
            this.instanceToInstanceTypeInfoMap.put(instanceTypeInfo.getInstance(), instanceTypeInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPropertyWithName(@NonNull String propertyName) {
        AbstractDefinitionTypeInfo abstractDefinitionTypeInfo = this;
        synchronized (abstractDefinitionTypeInfo) {
            return this.propertyNameToInstanceTypeInfoMap.containsKey(propertyName);
        }
    }

    @Override
    public Collection<ITypeInfo> getPropertyTypeInfos() {
        this.initInstanceTypeInfos();
        return this.propertyNameToInstanceTypeInfoMap.values();
    }

    @Override
    @Nullable
    public IInstanceTypeInfo getInstanceTypeInfo(@NonNull INamedInstance instance) {
        this.initInstanceTypeInfos();
        return this.instanceToInstanceTypeInfoMap.get(instance);
    }

    @Override
    public Collection<IInstanceTypeInfo> getInstanceTypeInfos() {
        this.initInstanceTypeInfos();
        return this.instanceToInstanceTypeInfoMap.values();
    }
}

