/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.codegen.AbstractDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.AnnotationUtils;
import gov.nist.secauto.metaschema.codegen.DefaultGeneratedDefinitionClass;
import gov.nist.secauto.metaschema.codegen.FlagInstanceTypeInfoImpl;
import gov.nist.secauto.metaschema.codegen.IFlagInstanceTypeInfo;
import gov.nist.secauto.metaschema.codegen.IModelDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.ITypeInfo;
import gov.nist.secauto.metaschema.codegen.ITypeResolver;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.INamedInstance;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

class AbstractModelDefinitionTypeInfo<DEF extends IFlagContainer>
extends AbstractDefinitionTypeInfo<DEF>
implements IModelDefinitionTypeInfo {
    @NonNull
    private final ClassName className;
    @Nullable
    private final ClassName baseClassName;
    private Map<String, IFlagInstanceTypeInfo> flagTypeInfos;

    public AbstractModelDefinitionTypeInfo(@NonNull DEF definition, @NonNull ITypeResolver typeResolver) {
        super(definition, typeResolver);
        this.className = typeResolver.getClassName((IFlagContainer)definition);
        this.baseClassName = typeResolver.getBaseClassName((IFlagContainer)definition);
    }

    @Override
    public ClassName getClassName() {
        return this.className;
    }

    @Override
    public ClassName getBaseClassName() {
        return this.baseClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean initInstanceTypeInfos() {
        AbstractModelDefinitionTypeInfo abstractModelDefinitionTypeInfo = this;
        synchronized (abstractModelDefinitionTypeInfo) {
            boolean retval;
            if (this.flagTypeInfos == null) {
                this.flagTypeInfos = ((IFlagContainer)this.getDefinition()).getFlagInstances().stream().map(instance -> {
                    assert (instance != null);
                    return this.newFlagTypeInfo((IFlagInstance)instance);
                }).collect(Collectors.toUnmodifiableMap(ITypeInfo::getPropertyName, Function.identity()));
                retval = true;
            } else {
                retval = false;
            }
            return retval;
        }
    }

    @Override
    public IFlagInstanceTypeInfo getFlagInstanceTypeInfo(@NonNull IFlagInstance instance) {
        this.initInstanceTypeInfos();
        return (IFlagInstanceTypeInfo)this.getInstanceTypeInfo((INamedInstance)instance);
    }

    @Override
    public Collection<IFlagInstanceTypeInfo> getFlagInstanceTypeInfos() {
        this.initInstanceTypeInfos();
        return this.flagTypeInfos.values();
    }

    protected IFlagInstanceTypeInfo newFlagTypeInfo(@NonNull IFlagInstance instance) {
        FlagInstanceTypeInfoImpl retval = new FlagInstanceTypeInfoImpl(instance, this);
        this.addPropertyTypeInfo(retval);
        return retval;
    }

    @Override
    public TypeSpec generateChildClass() throws IOException {
        return this.generateClass(this.getClassName(), true);
    }

    protected void buildCommonProperties(@NonNull AnnotationSpec.Builder annotation) {
        MarkupLine description;
        Object definition = this.getDefinition();
        String formalName = definition.getEffectiveFormalName();
        if (formalName != null) {
            annotation.addMember("formalName", "$S", new Object[]{formalName});
        }
        if ((description = definition.getEffectiveDescription()) != null) {
            annotation.addMember("description", "$S", new Object[]{description.toMarkdown()});
        }
        annotation.addMember("name", "$S", new Object[]{definition.getName()});
        IMetaschema metaschema = definition.getContainingMetaschema();
        annotation.addMember("metaschema", "$T.class", new Object[]{this.getTypeResolver().getClassName(metaschema)});
    }

    protected void buildConstraints(@NonNull TypeSpec.Builder builder) {
        IFlagContainer definition = (IFlagContainer)this.getDefinition();
        AnnotationUtils.buildValueConstraints(builder, definition);
    }

    @Override
    public DefaultGeneratedDefinitionClass generateClass(Path outputDir) throws IOException {
        ClassName className = this.getClassName();
        TypeSpec classSpec = this.generateClass(className, false);
        JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)classSpec).build();
        Path classFile = (Path)ObjectUtils.notNull((Object)javaFile.writeToPath(outputDir));
        return new DefaultGeneratedDefinitionClass(classFile, className, (IFlagContainer)this.getDefinition());
    }

    @NonNull
    protected TypeSpec generateClass(@NonNull ClassName className, boolean isChild) throws IOException {
        ClassName baseClassName;
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC});
        assert (builder != null);
        if (isChild) {
            builder.addModifiers(new Modifier[]{Modifier.STATIC});
        }
        if ((baseClassName = this.getBaseClassName()) != null) {
            builder.superclass((TypeName)baseClassName);
        }
        Set<IFlagContainer> additionalChildClasses = this.buildClass(builder, className);
        ITypeResolver typeResolver = this.getTypeResolver();
        for (IFlagContainer definition : additionalChildClasses) {
            assert (definition != null);
            IModelDefinitionTypeInfo typeInfo = typeResolver.getTypeInfo(definition);
            TypeSpec childClass = typeInfo.generateChildClass();
            builder.addType(childClass);
        }
        return (TypeSpec)ObjectUtils.notNull((Object)builder.build());
    }

    @NonNull
    protected Set<IFlagContainer> buildClass(@NonNull TypeSpec.Builder builder, @NonNull ClassName className) throws IOException {
        MarkupLine description = ((IFlagContainer)this.getDefinition()).getDescription();
        if (description != null) {
            builder.addJavadoc(description.toHtml(), new Object[0]);
        }
        HashSet<IFlagContainer> additionalChildClasses = new HashSet<IFlagContainer>();
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        for (ITypeInfo property : this.getPropertyTypeInfos()) {
            additionalChildClasses.addAll(property.build(builder, this.getTypeResolver()));
        }
        MethodSpec.Builder toString = MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addAnnotation(Override.class);
        toString.addStatement("return new $T(this, $T.MULTI_LINE_STYLE).toString()", new Object[]{ReflectionToStringBuilder.class, MultilineRecursiveToStringStyle.class});
        builder.addMethod(toString.build());
        return CollectionUtil.unmodifiableSet(additionalChildClasses);
    }
}

