/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.codegen.ClassUtils;
import gov.nist.secauto.metaschema.codegen.IDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.ITypeInfo;
import gov.nist.secauto.metaschema.codegen.ITypeResolver;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.util.Set;
import javax.lang.model.element.Modifier;

abstract class AbstractTypeInfo<PARENT extends IDefinitionTypeInfo>
implements ITypeInfo {
    @NonNull
    private final PARENT parentDefinition;
    private String propertyName;
    private String fieldName;

    public AbstractTypeInfo(@NonNull PARENT parentDefinition) {
        this.parentDefinition = parentDefinition;
    }

    @NonNull
    protected PARENT getParentDefinitionTypeInfo() {
        return this.parentDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public String getPropertyName() {
        AbstractTypeInfo abstractTypeInfo = this;
        synchronized (abstractTypeInfo) {
            if (this.propertyName == null) {
                String name = ClassUtils.toPropertyName(this.getBaseName());
                PARENT parent = this.getParentDefinitionTypeInfo();
                if (parent.hasPropertyWithName(name)) {
                    String newName;
                    int index = 1;
                    do {
                        newName = ClassUtils.toPropertyName(name + Integer.toString(index));
                        ++index;
                    } while (parent.hasPropertyWithName(newName));
                    name = newName;
                }
                this.propertyName = name;
            }
            return (String)ObjectUtils.notNull((Object)this.propertyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final String getJavaFieldName() {
        AbstractTypeInfo abstractTypeInfo = this;
        synchronized (abstractTypeInfo) {
            if (this.fieldName == null) {
                this.fieldName = "_" + ClassUtils.toVariableName(this.getPropertyName());
            }
            return (String)ObjectUtils.notNull((Object)this.fieldName);
        }
    }

    @Override
    public Set<IFlagContainer> build(@NonNull TypeSpec.Builder builder, ITypeResolver typeResolver) {
        FieldSpec.Builder field = FieldSpec.builder((TypeName)this.getJavaFieldType(), (String)this.getJavaFieldName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        assert (field != null);
        Set<IFlagContainer> retval = this.buildField(field);
        FieldSpec valueField = (FieldSpec)ObjectUtils.notNull((Object)field.build());
        builder.addField(valueField);
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)("get" + this.getPropertyName())).returns(this.getJavaFieldType()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        assert (method != null);
        this.buildGetter(method, valueField);
        builder.addMethod(method.build());
        ParameterSpec valueParam = ParameterSpec.builder((TypeName)this.getJavaFieldType(), (String)"value", (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder method2 = MethodSpec.methodBuilder((String)("set" + this.getPropertyName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(valueParam);
        assert (method2 != null);
        this.buildSetter(method2, valueParam, valueField);
        builder.addMethod(method2.build());
        this.buildExtraMethods(builder, valueField, typeResolver);
        return retval;
    }

    protected void buildExtraMethods(@NonNull TypeSpec.Builder builder, @NonNull FieldSpec valueField, @NonNull ITypeResolver typeResolver) {
    }

    @NonNull
    protected abstract Set<IFlagContainer> buildField(@NonNull FieldSpec.Builder var1);

    protected void buildGetter(@NonNull MethodSpec.Builder builder, @NonNull FieldSpec valueField) {
        builder.addStatement("return $N", new Object[]{valueField});
    }

    protected void buildSetter(MethodSpec.Builder builder, ParameterSpec valueParam, FieldSpec valueField) {
        builder.addStatement("$N = $N", new Object[]{valueField, valueParam});
    }
}

