/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.binding.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.binding.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.binding.model.annotations.Expect;
import gov.nist.secauto.metaschema.binding.model.annotations.HasCardinality;
import gov.nist.secauto.metaschema.binding.model.annotations.Index;
import gov.nist.secauto.metaschema.binding.model.annotations.IndexHasKey;
import gov.nist.secauto.metaschema.binding.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.binding.model.annotations.KeyField;
import gov.nist.secauto.metaschema.binding.model.annotations.Matches;
import gov.nist.secauto.metaschema.binding.model.annotations.ValueConstraints;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.INamedInstance;
import gov.nist.secauto.metaschema.model.common.INamedModelInstance;
import gov.nist.secauto.metaschema.model.common.IValuedDefinition;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValue;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.ICardinalityConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IExpectConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IIndexConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IKeyField;
import gov.nist.secauto.metaschema.model.common.constraint.IMatchesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IUniqueConstraint;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.metapath.DynamicContext;
import gov.nist.secauto.metaschema.model.common.metapath.ISequence;
import gov.nist.secauto.metaschema.model.common.metapath.MetapathExpression;
import gov.nist.secauto.metaschema.model.common.metapath.StaticContext;
import gov.nist.secauto.metaschema.model.common.metapath.item.DefaultNodeItemFactory;
import gov.nist.secauto.metaschema.model.common.metapath.item.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.model.common.metapath.item.IDefinitionNodeItem;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class AnnotationUtils {
    private static final Logger LOGGER = LogManager.getLogger(AnnotationUtils.class);

    private AnnotationUtils() {
    }

    public static Object getDefaultValue(Class<?> annotation, String member) {
        Object retval;
        Method method;
        try {
            method = annotation.getDeclaredMethod(member, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(ex);
        }
        try {
            retval = method.getDefaultValue();
        }
        catch (TypeNotPresentException ex) {
            retval = null;
        }
        return retval;
    }

    private static void buildConstraint(Class<?> annotationType, AnnotationSpec.Builder annotation, IConstraint constraint) {
        MarkupLine description;
        String formalName;
        String id = constraint.getId();
        if (id != null) {
            annotation.addMember("id", "$S", new Object[]{id});
        }
        if ((formalName = constraint.getFormalName()) != null) {
            annotation.addMember("formalName", "$S", new Object[]{formalName});
        }
        if ((description = constraint.getDescription()) != null) {
            annotation.addMember("description", "$S", new Object[]{description.toMarkdown()});
        }
        annotation.addMember("level", "$T.$L", new Object[]{IConstraint.Level.class, constraint.getLevel()});
        MetapathExpression target = constraint.getTarget();
        String path = target.getPath();
        if (!path.equals(AnnotationUtils.getDefaultValue(annotationType, "target"))) {
            annotation.addMember("target", "$S", new Object[]{path});
        }
    }

    public static void buildValueConstraints(@NonNull FieldSpec.Builder builder, @NonNull IValuedDefinition definition) {
        if (!definition.getConstraints().isEmpty()) {
            AnnotationSpec.Builder valueConstraintsAnnotation = AnnotationSpec.builder(ValueConstraints.class);
            AnnotationUtils.applyAllowedValuesConstraints(valueConstraintsAnnotation, definition.getAllowedValuesConstraints());
            AnnotationUtils.applyIndexHasKeyConstraints(valueConstraintsAnnotation, definition.getIndexHasKeyConstraints());
            AnnotationUtils.applyMatchesConstraints(valueConstraintsAnnotation, definition.getMatchesConstraints());
            AnnotationUtils.applyExpectConstraints(valueConstraintsAnnotation, definition.getExpectConstraints());
            builder.addAnnotation(valueConstraintsAnnotation.build());
        }
    }

    public static void buildValueConstraints(@NonNull TypeSpec.Builder builder, @NonNull IFlagContainer definition) {
        List allowedValues = definition.getAllowedValuesConstraints();
        List indexHasKey = definition.getIndexHasKeyConstraints();
        List matches = definition.getMatchesConstraints();
        List expects = definition.getExpectConstraints();
        if (!(allowedValues.isEmpty() && indexHasKey.isEmpty() && matches.isEmpty() && expects.isEmpty())) {
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(ValueConstraints.class);
            AnnotationUtils.applyAllowedValuesConstraints(annotation, allowedValues);
            AnnotationUtils.applyIndexHasKeyConstraints(annotation, indexHasKey);
            AnnotationUtils.applyMatchesConstraints(annotation, matches);
            AnnotationUtils.applyExpectConstraints(annotation, expects);
            builder.addAnnotation(annotation.build());
        }
    }

    public static void buildAssemblyConstraints(@NonNull TypeSpec.Builder builder, @NonNull IAssemblyDefinition definition) {
        List index = definition.getIndexConstraints();
        List unique = definition.getUniqueConstraints();
        List cardinality = definition.getHasCardinalityConstraints();
        if (!(index.isEmpty() && unique.isEmpty() && cardinality.isEmpty())) {
            AnnotationSpec.Builder annotation = (AnnotationSpec.Builder)ObjectUtils.notNull((Object)AnnotationSpec.builder(AssemblyConstraints.class));
            AnnotationUtils.applyIndexConstraints(annotation, index);
            AnnotationUtils.applyUniqueConstraints(annotation, unique);
            AnnotationUtils.applyHasCardinalityConstraints(definition, annotation, cardinality);
            builder.addAnnotation(annotation.build());
        }
    }

    private static void applyAllowedValuesConstraints(AnnotationSpec.Builder annotation, List<? extends IAllowedValuesConstraint> constraints) {
        for (IAllowedValuesConstraint iAllowedValuesConstraint : constraints) {
            AnnotationSpec.Builder constraintAnnotation = AnnotationSpec.builder(AllowedValues.class);
            AnnotationUtils.buildConstraint(AllowedValues.class, constraintAnnotation, (IConstraint)iAllowedValuesConstraint);
            boolean isAllowedOther = iAllowedValuesConstraint.isAllowedOther();
            if (!Boolean.valueOf(isAllowedOther).equals(AnnotationUtils.getDefaultValue(AllowedValues.class, "allowOthers"))) {
                constraintAnnotation.addMember("allowOthers", "$L", new Object[]{isAllowedOther});
            }
            for (IAllowedValue value : iAllowedValuesConstraint.getAllowedValues().values()) {
                AnnotationSpec.Builder valueAnnotation = AnnotationSpec.builder(AllowedValue.class);
                valueAnnotation.addMember("value", "$S", new Object[]{value.getValue()});
                valueAnnotation.addMember("description", "$S", new Object[]{value.getDescription().toMarkdown()});
                constraintAnnotation.addMember("values", "$L", new Object[]{valueAnnotation.build()});
            }
            MarkupMultiline remarks = iAllowedValuesConstraint.getRemarks();
            if (remarks != null) {
                constraintAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
            }
            annotation.addMember("allowedValues", "$L", new Object[]{constraintAnnotation.build()});
        }
    }

    private static void applyIndexHasKeyConstraints(AnnotationSpec.Builder annotation, List<? extends IIndexHasKeyConstraint> constraints) {
        for (IIndexHasKeyConstraint iIndexHasKeyConstraint : constraints) {
            AnnotationSpec.Builder constraintAnnotation = AnnotationSpec.builder(IndexHasKey.class);
            AnnotationUtils.buildConstraint(IndexHasKey.class, constraintAnnotation, (IConstraint)iIndexHasKeyConstraint);
            constraintAnnotation.addMember("indexName", "$S", new Object[]{iIndexHasKeyConstraint.getIndexName()});
            AnnotationUtils.buildKeyFields(constraintAnnotation, iIndexHasKeyConstraint.getKeyFields());
            MarkupMultiline remarks = iIndexHasKeyConstraint.getRemarks();
            if (remarks != null) {
                constraintAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
            }
            annotation.addMember("indexHasKey", "$L", new Object[]{constraintAnnotation.build()});
        }
    }

    private static void buildKeyFields(@NonNull AnnotationSpec.Builder constraintAnnotation, @NonNull List<? extends IKeyField> keyFields) {
        for (IKeyField iKeyField : keyFields) {
            MarkupMultiline remarks;
            Pattern pattern;
            AnnotationSpec.Builder keyAnnotation = AnnotationSpec.builder(KeyField.class);
            MetapathExpression target = iKeyField.getTarget();
            String path = target.getPath();
            if (!path.equals(AnnotationUtils.getDefaultValue(KeyField.class, "target"))) {
                keyAnnotation.addMember("target", "$S", new Object[]{path});
            }
            if ((pattern = iKeyField.getPattern()) != null) {
                keyAnnotation.addMember("pattern", "$S", new Object[]{pattern.pattern()});
            }
            if ((remarks = iKeyField.getRemarks()) != null) {
                keyAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
            }
            constraintAnnotation.addMember("keyFields", "$L", new Object[]{keyAnnotation.build()});
        }
    }

    private static void applyMatchesConstraints(AnnotationSpec.Builder annotation, List<? extends IMatchesConstraint> constraints) {
        for (IMatchesConstraint iMatchesConstraint : constraints) {
            MarkupMultiline remarks;
            IDataTypeAdapter dataType;
            AnnotationSpec.Builder constraintAnnotation = AnnotationSpec.builder(Matches.class);
            AnnotationUtils.buildConstraint(Matches.class, constraintAnnotation, (IConstraint)iMatchesConstraint);
            Pattern pattern = iMatchesConstraint.getPattern();
            if (pattern != null) {
                constraintAnnotation.addMember("pattern", "$S", new Object[]{pattern.pattern()});
            }
            if ((dataType = iMatchesConstraint.getDataType()) != null) {
                constraintAnnotation.addMember("typeAdapter", "$T.class", new Object[]{dataType.getClass()});
            }
            if ((remarks = iMatchesConstraint.getRemarks()) != null) {
                constraintAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
            }
            annotation.addMember("matches", "$L", new Object[]{constraintAnnotation.build()});
        }
    }

    private static void applyExpectConstraints(AnnotationSpec.Builder annotation, List<? extends IExpectConstraint> constraints) {
        for (IExpectConstraint iExpectConstraint : constraints) {
            MarkupMultiline remarks;
            AnnotationSpec.Builder constraintAnnotation = AnnotationSpec.builder(Expect.class);
            AnnotationUtils.buildConstraint(Expect.class, constraintAnnotation, (IConstraint)iExpectConstraint);
            MetapathExpression test = iExpectConstraint.getTest();
            constraintAnnotation.addMember("test", "$S", new Object[]{test.getPath()});
            if (iExpectConstraint.getMessage() != null) {
                constraintAnnotation.addMember("message", "$S", new Object[]{iExpectConstraint.getMessage()});
            }
            if ((remarks = iExpectConstraint.getRemarks()) != null) {
                constraintAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
            }
            annotation.addMember("expect", "$L", new Object[]{constraintAnnotation.build()});
        }
    }

    private static void applyIndexConstraints(AnnotationSpec.Builder annotation, List<? extends IIndexConstraint> constraints) {
        for (IIndexConstraint iIndexConstraint : constraints) {
            AnnotationSpec.Builder constraintAnnotation = AnnotationSpec.builder(Index.class);
            AnnotationUtils.buildConstraint(Index.class, constraintAnnotation, (IConstraint)iIndexConstraint);
            constraintAnnotation.addMember("name", "$S", new Object[]{iIndexConstraint.getName()});
            AnnotationUtils.buildKeyFields(constraintAnnotation, iIndexConstraint.getKeyFields());
            MarkupMultiline remarks = iIndexConstraint.getRemarks();
            if (remarks != null) {
                constraintAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
            }
            annotation.addMember("index", "$L", new Object[]{constraintAnnotation.build()});
        }
    }

    private static void applyUniqueConstraints(AnnotationSpec.Builder annotation, List<? extends IUniqueConstraint> constraints) {
        for (IUniqueConstraint iUniqueConstraint : constraints) {
            AnnotationSpec.Builder constraintAnnotation = (AnnotationSpec.Builder)ObjectUtils.notNull((Object)AnnotationSpec.builder(IsUnique.class));
            AnnotationUtils.buildConstraint(IsUnique.class, constraintAnnotation, (IConstraint)iUniqueConstraint);
            AnnotationUtils.buildKeyFields(constraintAnnotation, iUniqueConstraint.getKeyFields());
            MarkupMultiline remarks = iUniqueConstraint.getRemarks();
            if (remarks != null) {
                constraintAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
            }
            annotation.addMember("isUnique", "$L", new Object[]{constraintAnnotation.build()});
        }
    }

    private static void applyHasCardinalityConstraints(@NonNull IAssemblyDefinition definition, @NonNull AnnotationSpec.Builder annotation, @NonNull List<? extends ICardinalityConstraint> constraints) {
        DynamicContext dynamicContext = new StaticContext().newDynamicContext();
        dynamicContext.disablePredicateEvaluation();
        for (ICardinalityConstraint iCardinalityConstraint : constraints) {
            Integer minOccurs = iCardinalityConstraint.getMinOccurs();
            Integer maxOccurs = iCardinalityConstraint.getMaxOccurs();
            IAssemblyNodeItem definitionNodeItem = DefaultNodeItemFactory.instance().newAssemblyNodeItem(definition, null);
            ISequence instanceSet = iCardinalityConstraint.matchTargets((IDefinitionNodeItem)definitionNodeItem, dynamicContext);
            for (IDefinitionNodeItem item : instanceSet.asList()) {
                INamedInstance instance = item.getInstance();
                if (instance instanceof INamedModelInstance) {
                    INamedModelInstance modelInstance = (INamedModelInstance)instance;
                    if (minOccurs != null) {
                        if (minOccurs.intValue() == modelInstance.getMinOccurs()) {
                            if (LOGGER.isWarnEnabled()) {
                                LOGGER.warn(String.format("Definition '%s' has min-occurs=%d cardinality constraint targeting '%s' that is redundant with a targeted instance named '%s' that requires min-occurs=%d", definition.getName(), minOccurs, iCardinalityConstraint.getTarget().getPath(), modelInstance.getName(), modelInstance.getMinOccurs()));
                            }
                        } else if (minOccurs < modelInstance.getMinOccurs() && LOGGER.isWarnEnabled()) {
                            LOGGER.warn(String.format("Definition '%s' has min-occurs=%d cardinality constraint targeting '%s' that conflicts with a targeted instance named '%s' that requires min-occurs=%d", definition.getName(), minOccurs, iCardinalityConstraint.getTarget().getPath(), modelInstance.getName(), modelInstance.getMinOccurs()));
                        }
                    }
                    if (maxOccurs == null) continue;
                    if (maxOccurs.intValue() == modelInstance.getMaxOccurs()) {
                        if (!LOGGER.isWarnEnabled()) continue;
                        LOGGER.warn(String.format("Definition '%s' has max-occurs=%d cardinality constraint targeting '%s' that is redundant with a targeted instance named '%s' that requires max-occurs=%d", definition.getName(), maxOccurs, iCardinalityConstraint.getTarget().getPath(), modelInstance.getName(), modelInstance.getMaxOccurs()));
                        continue;
                    }
                    if (maxOccurs >= modelInstance.getMaxOccurs() || !LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn(String.format("Definition '%s' has max-occurs=%d cardinality constraint targeting '%s' that conflicts with a targeted instance named '%s' that requires max-occurs=%d", definition.getName(), maxOccurs, iCardinalityConstraint.getTarget().getPath(), modelInstance.getName(), modelInstance.getMaxOccurs()));
                    continue;
                }
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Definition '%s' has min-occurs=%d cardinality constraint targeting '%s' that is not a model instance", definition.getName(), minOccurs, iCardinalityConstraint.getTarget().getPath()));
            }
            AnnotationSpec.Builder constraintAnnotation = AnnotationSpec.builder(HasCardinality.class);
            AnnotationUtils.buildConstraint(HasCardinality.class, constraintAnnotation, (IConstraint)iCardinalityConstraint);
            if (minOccurs != null && !minOccurs.equals(AnnotationUtils.getDefaultValue(HasCardinality.class, "minOccurs"))) {
                constraintAnnotation.addMember("minOccurs", "$L", new Object[]{minOccurs});
            }
            if (maxOccurs != null && !maxOccurs.equals(AnnotationUtils.getDefaultValue(HasCardinality.class, "maxOccurs"))) {
                constraintAnnotation.addMember("maxOccurs", "$L", new Object[]{maxOccurs});
            }
            annotation.addMember("hasCardinality", "$L", new Object[]{constraintAnnotation.build()});
            MarkupMultiline remarks = iCardinalityConstraint.getRemarks();
            if (remarks == null) continue;
            constraintAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
        }
    }
}

