/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import com.squareup.javapoet.ClassName;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.codegen.ClassUtils;
import gov.nist.secauto.metaschema.codegen.IAssemblyDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.IFieldDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.IModelDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.ITypeResolver;
import gov.nist.secauto.metaschema.codegen.binding.config.IBindingConfiguration;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IFieldDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.INamedModelInstance;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class DefaultTypeResolver
implements ITypeResolver {
    private static final Logger LOGGER = LogManager.getLogger(DefaultTypeResolver.class);
    private final Map<String, Set<String>> packageToClassNamesMap = new ConcurrentHashMap<String, Set<String>>();
    private final Map<IFlagContainer, ClassName> definitionToTypeMap = new ConcurrentHashMap<IFlagContainer, ClassName>();
    private final Map<IMetaschema, ClassName> metaschemaToTypeMap = new ConcurrentHashMap<IMetaschema, ClassName>();
    private final Map<IAssemblyDefinition, IAssemblyDefinitionTypeInfo> assemblyDefinitionToTypeInfoMap = new ConcurrentHashMap<IAssemblyDefinition, IAssemblyDefinitionTypeInfo>();
    private final Map<IFieldDefinition, IFieldDefinitionTypeInfo> fieldDefinitionToTypeInfoMap = new ConcurrentHashMap<IFieldDefinition, IFieldDefinitionTypeInfo>();
    @NonNull
    private final IBindingConfiguration bindingConfiguration;

    public DefaultTypeResolver(@NonNull IBindingConfiguration bindingConfiguration) {
        this.bindingConfiguration = bindingConfiguration;
    }

    protected IBindingConfiguration getBindingConfiguration() {
        return this.bindingConfiguration;
    }

    @Override
    public IAssemblyDefinitionTypeInfo getTypeInfo(@NonNull IAssemblyDefinition definition) {
        return (IAssemblyDefinitionTypeInfo)ObjectUtils.notNull((Object)this.assemblyDefinitionToTypeInfoMap.computeIfAbsent(definition, def -> IAssemblyDefinitionTypeInfo.newTypeInfo((IAssemblyDefinition)ObjectUtils.notNull((Object)def), (ITypeResolver)this)));
    }

    @Override
    public IFieldDefinitionTypeInfo getTypeInfo(@NonNull IFieldDefinition definition) {
        return (IFieldDefinitionTypeInfo)ObjectUtils.notNull((Object)this.fieldDefinitionToTypeInfoMap.computeIfAbsent(definition, def -> IFieldDefinitionTypeInfo.newTypeInfo((IFieldDefinition)ObjectUtils.notNull((Object)def), (ITypeResolver)this)));
    }

    @Override
    public IModelDefinitionTypeInfo getTypeInfo(@NonNull IFlagContainer definition) {
        IModelDefinitionTypeInfo retval;
        if (definition instanceof IAssemblyDefinition) {
            retval = this.getTypeInfo((IAssemblyDefinition)definition);
        } else if (definition instanceof IFieldDefinition) {
            retval = this.getTypeInfo((IFieldDefinition)definition);
        } else {
            throw new IllegalStateException(String.format("Unknown type '%s'", definition.getClass().getName()));
        }
        return retval;
    }

    @Override
    public ClassName getClassName(@NonNull IFlagContainer definition) {
        return (ClassName)ObjectUtils.notNull((Object)this.definitionToTypeMap.computeIfAbsent(definition, def -> {
            ClassName retval;
            String packageName = this.getBindingConfiguration().getPackageNameForMetaschema(def.getContainingMetaschema());
            if (def.isInline()) {
                INamedModelInstance inlineInstance = def.getInlineInstance();
                IAssemblyDefinition parentDefinition = inlineInstance.getContainingDefinition();
                ClassName parentClassName = this.getClassName((IFlagContainer)parentDefinition);
                String name = this.generateClassName((String)ObjectUtils.notNull((Object)parentClassName.canonicalName()), (IFlagContainer)def);
                retval = parentClassName.nestedClass(name);
            } else {
                String className = this.generateClassName(packageName, (IFlagContainer)def);
                retval = ClassName.get((String)packageName, (String)className, (String[])new String[0]);
            }
            return retval;
        }));
    }

    @Override
    public ClassName getClassName(IMetaschema metaschema) {
        return (ClassName)ObjectUtils.notNull((Object)this.metaschemaToTypeMap.computeIfAbsent(metaschema, meta -> {
            assert (meta != null);
            String packageName = this.getBindingConfiguration().getPackageNameForMetaschema((IMetaschema)meta);
            Object className = this.getBindingConfiguration().getClassName((IMetaschema)meta);
            String classNameBase = className;
            int index = 1;
            while (this.isClassNameClash(packageName, (String)className)) {
                className = classNameBase + Integer.toString(index);
            }
            this.addClassName(packageName, (String)className);
            return ClassName.get((String)packageName, (String)className, (String[])new String[0]);
        }));
    }

    @NonNull
    protected Set<String> getClassNamesFor(@NonNull String packageOrTypeName) {
        return (Set)ObjectUtils.notNull((Object)this.packageToClassNamesMap.computeIfAbsent(packageOrTypeName, pkg -> Collections.synchronizedSet(new HashSet())));
    }

    protected boolean isClassNameClash(@NonNull String packageOrTypeName, @NonNull String className) {
        return this.getClassNamesFor(packageOrTypeName).contains(className);
    }

    protected boolean addClassName(@NonNull String packageOrTypeName, @NonNull String className) {
        return this.getClassNamesFor(packageOrTypeName).add(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateClassName(@NonNull String packageOrTypeName, @NonNull IFlagContainer definition) {
        Set<String> classNames;
        String className = this.getBindingConfiguration().getClassName(definition);
        Object retval = className;
        Set<String> set = classNames = this.getClassNamesFor(packageOrTypeName);
        synchronized (set) {
            boolean clash = false;
            if (classNames.contains(className)) {
                clash = true;
                String metaschemaShortName = definition.getContainingMetaschema().getShortName();
                retval = ClassUtils.toClassName(className + metaschemaShortName);
            }
            String classNameBase = retval;
            int index = 1;
            while (classNames.contains(retval)) {
                retval = classNameBase + Integer.toString(index++);
            }
            classNames.add((String)retval);
            if (clash && LOGGER.isWarnEnabled()) {
                LOGGER.warn(String.format("Class name '%s' in metaschema '%s' conflicts with a previously used class name. Using '%s' instead.", className, definition.getContainingMetaschema().getLocation(), retval));
            }
        }
        return retval;
    }

    @Override
    public ClassName getBaseClassName(IFlagContainer definition) {
        String className = this.bindingConfiguration.getQualifiedBaseClassName(definition);
        ClassName retval = null;
        if (className != null) {
            retval = ClassName.bestGuess((String)className);
        }
        return retval;
    }

    @Override
    public String getPackageName(@NonNull IMetaschema metaschema) {
        return this.bindingConfiguration.getPackageNameForMetaschema(metaschema);
    }
}

