/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.binding.model.annotations.JsonFieldValueKeyFlag;
import gov.nist.secauto.metaschema.binding.model.annotations.JsonKey;
import gov.nist.secauto.metaschema.codegen.AbstractInstanceTypeInfo;
import gov.nist.secauto.metaschema.codegen.AnnotationUtils;
import gov.nist.secauto.metaschema.codegen.IDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.IFlagInstanceTypeInfo;
import gov.nist.secauto.metaschema.model.common.IFieldDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.IFlagDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import gov.nist.secauto.metaschema.model.common.IValuedDefinition;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.util.Set;

class FlagInstanceTypeInfoImpl
extends AbstractInstanceTypeInfo<IFlagInstance, IDefinitionTypeInfo>
implements IFlagInstanceTypeInfo {
    public FlagInstanceTypeInfoImpl(@NonNull IFlagInstance instance, @NonNull IDefinitionTypeInfo parentDefinition) {
        super(instance, parentDefinition);
    }

    @Override
    public String getBaseName() {
        return ((IFlagInstance)this.getInstance()).getEffectiveName();
    }

    @Override
    public TypeName getJavaFieldType() {
        return (TypeName)ObjectUtils.notNull((Object)ClassName.get((Class)((IFlagInstance)this.getInstance()).getDefinition().getJavaTypeAdapter().getJavaClass()));
    }

    @Override
    protected Set<IFlagContainer> buildField(@NonNull FieldSpec.Builder builder) {
        IFieldDefinition parentField;
        MarkupLine description;
        IFlagInstance instance = (IFlagInstance)this.getInstance();
        AnnotationSpec.Builder annotation = AnnotationSpec.builder(BoundFlag.class);
        String formalName = instance.getEffectiveFormalName();
        if (formalName != null) {
            annotation.addMember("formalName", "$S", new Object[]{formalName});
        }
        if ((description = instance.getEffectiveDescription()) != null) {
            annotation.addMember("description", "$S", new Object[]{description.toMarkdown()});
        }
        annotation.addMember("useName", "$S", new Object[]{instance.getEffectiveName()});
        if (instance.isRequired()) {
            annotation.addMember("required", "$L", new Object[]{true});
        }
        IFlagDefinition definition = instance.getDefinition();
        IDataTypeAdapter valueDataType = definition.getJavaTypeAdapter();
        annotation.addMember("typeAdapter", "$T.class", new Object[]{valueDataType.getClass()});
        MarkupMultiline remarks = instance.getRemarks();
        if (remarks != null) {
            annotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
        }
        builder.addAnnotation(annotation.build());
        AnnotationUtils.buildValueConstraints(builder, (IValuedDefinition)definition);
        IFlagContainer parent = instance.getContainingDefinition();
        if (parent.hasJsonKey() && instance.equals(parent.getJsonKeyFlagInstance())) {
            builder.addAnnotation(JsonKey.class);
        }
        if (parent instanceof IFieldDefinition && (parentField = (IFieldDefinition)parent).hasJsonValueKeyFlagInstance() && instance.equals(parentField.getJsonValueKeyFlagInstance())) {
            builder.addAnnotation(JsonFieldValueKeyFlag.class);
        }
        return CollectionUtil.emptySet();
    }
}

