/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.codegen.IAssemblyDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.IDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.IFieldDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.IFlagInstanceTypeInfo;
import gov.nist.secauto.metaschema.codegen.IGeneratedDefinitionClass;
import gov.nist.secauto.metaschema.codegen.ITypeResolver;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IFieldDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;

public interface IModelDefinitionTypeInfo
extends IDefinitionTypeInfo {
    @NonNull
    public static IModelDefinitionTypeInfo newTypeInfo(@NonNull IFlagContainer definition, @NonNull ITypeResolver typeResolver) {
        IModelDefinitionTypeInfo retval;
        switch (definition.getModelType()) {
            case ASSEMBLY: {
                retval = IAssemblyDefinitionTypeInfo.newTypeInfo((IAssemblyDefinition)definition, typeResolver);
                break;
            }
            case FIELD: {
                retval = IFieldDefinitionTypeInfo.newTypeInfo((IFieldDefinition)definition, typeResolver);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Generation of child classes for %s definitions is unsupported", definition.getModelType().name()));
            }
        }
        return retval;
    }

    public IFlagContainer getDefinition();

    @Nullable
    public ClassName getBaseClassName();

    @NonNull
    public ClassName getClassName();

    @Nullable
    public IFlagInstanceTypeInfo getFlagInstanceTypeInfo(@NonNull IFlagInstance var1);

    @NonNull
    public Collection<IFlagInstanceTypeInfo> getFlagInstanceTypeInfos();

    @NonNull
    public IGeneratedDefinitionClass generateClass(@NonNull Path var1) throws IOException;

    @NonNull
    public TypeSpec generateChildClass() throws IOException;
}

