/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.codegen.IDefinitionProduction;
import gov.nist.secauto.metaschema.codegen.IGeneratedClass;
import gov.nist.secauto.metaschema.codegen.IMetaschemaProduction;
import gov.nist.secauto.metaschema.codegen.ITypeResolver;
import gov.nist.secauto.metaschema.codegen.PackageMetadata;
import gov.nist.secauto.metaschema.codegen.ProductionImpl;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Stream;

public interface IProduction {
    @NonNull
    public Collection<IMetaschemaProduction> getMetaschemaProductions();

    @Nullable
    public IMetaschemaProduction getMetaschemaProduction(@NonNull IMetaschema var1);

    @NonNull
    public Stream<IDefinitionProduction> getDefinitionProductionsAsStream();

    @NonNull
    public Stream<IGeneratedClass> getGeneratedClasses();

    @NonNull
    public static IProduction of(@NonNull IMetaschema metaschema, @NonNull ITypeResolver typeResolver, @NonNull Path targetDirectory) throws IOException {
        return IProduction.of(CollectionUtil.singleton((Object)metaschema), typeResolver, targetDirectory);
    }

    @NonNull
    public static IProduction of(@NonNull Collection<? extends IMetaschema> metaschemas, @NonNull ITypeResolver typeResolver, @NonNull Path targetDirectory) throws IOException {
        ProductionImpl retval = new ProductionImpl();
        for (IMetaschema iMetaschema : metaschemas) {
            if (!1.$assertionsDisabled && iMetaschema == null) {
                throw new AssertionError();
            }
            retval.processMetaschema(iMetaschema, typeResolver, targetDirectory);
        }
        HashMap<String, PackageMetadata> packageNameToPackageMetadataMap = new HashMap<String, PackageMetadata>();
        for (IMetaschemaProduction metaschemaProduction : retval.getMetaschemaProductions()) {
            String packageName = metaschemaProduction.getPackageName();
            PackageMetadata metadata = (PackageMetadata)packageNameToPackageMetadataMap.get(packageName);
            if (metadata == null) {
                metadata = new PackageMetadata(metaschemaProduction);
                packageNameToPackageMetadataMap.put(metadata.getPackageName(), metadata);
                continue;
            }
            metadata.addMetaschema(metaschemaProduction);
        }
        for (PackageMetadata metadata : packageNameToPackageMetadataMap.values()) {
            retval.addPackage(metadata.getPackageName(), metadata.getXmlNamespace(), metadata.getMetaschemaProductions(), targetDirectory);
        }
        return retval;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

