/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.codegen.DefaultTypeResolver;
import gov.nist.secauto.metaschema.codegen.IProduction;
import gov.nist.secauto.metaschema.codegen.ITypeResolver;
import gov.nist.secauto.metaschema.codegen.binding.config.IBindingConfiguration;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JavaGenerator {
    private static final Logger LOGGER = LogManager.getLogger(JavaGenerator.class);

    private JavaGenerator() {
    }

    public static IProduction generate(@NonNull IMetaschema metaschema, @NonNull Path targetDir, @NonNull IBindingConfiguration bindingConfiguration) throws IOException {
        return JavaGenerator.generate(CollectionUtil.singletonList((Object)metaschema), targetDir, bindingConfiguration);
    }

    @NonNull
    public static IProduction generate(@NonNull Collection<? extends IMetaschema> metaschemas, @NonNull Path targetDirectory, @NonNull IBindingConfiguration bindingConfiguration) throws IOException {
        Objects.requireNonNull(metaschemas, "metaschemas");
        Objects.requireNonNull(targetDirectory, "generationTargetDirectory");
        Objects.requireNonNull(bindingConfiguration, "bindingConfiguration");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Generating Java classes in: {}", (Object)targetDirectory);
        }
        DefaultTypeResolver typeResolver = new DefaultTypeResolver(bindingConfiguration);
        return IProduction.of(metaschemas, (ITypeResolver)typeResolver, targetDirectory);
    }
}

