/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.IBindingContext;
import gov.nist.secauto.metaschema.binding.model.AbstractBoundMetaschema;
import gov.nist.secauto.metaschema.binding.model.annotations.Metaschema;
import gov.nist.secauto.metaschema.codegen.DefaultGeneratedClass;
import gov.nist.secauto.metaschema.codegen.IGeneratedClass;
import gov.nist.secauto.metaschema.codegen.ITypeResolver;
import gov.nist.secauto.metaschema.model.common.IFieldDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import javax.lang.model.element.Modifier;

class MetaschemaClassGenerator {
    @NonNull
    private final IMetaschema metaschema;
    @NonNull
    private final ITypeResolver typeResolver;

    public MetaschemaClassGenerator(@NonNull IMetaschema metaschema, @NonNull ITypeResolver typeResolver) {
        this.metaschema = (IMetaschema)ObjectUtils.requireNonNull((Object)metaschema, (String)"metaschema");
        this.typeResolver = (ITypeResolver)ObjectUtils.requireNonNull((Object)typeResolver, (String)"typeResolver");
    }

    @NonNull
    protected IMetaschema getMetaschema() {
        return this.metaschema;
    }

    @NonNull
    protected ITypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @NonNull
    public ClassName getClassName() {
        return this.getTypeResolver().getClassName(this.getMetaschema());
    }

    @NonNull
    public IGeneratedClass generateClass(Path outputDir) throws IOException {
        ClassName className = this.getClassName();
        TypeSpec.Builder builder = this.generateClass(className);
        JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)builder.build()).build();
        Path classFile = (Path)ObjectUtils.notNull((Object)javaFile.writeToPath(outputDir));
        return new DefaultGeneratedClass(classFile, className);
    }

    @NonNull
    protected TypeSpec.Builder generateClass(@NonNull ClassName className) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        builder.superclass(AbstractBoundMetaschema.class);
        AnnotationSpec.Builder metaschemaAnnotation = AnnotationSpec.builder(Metaschema.class);
        IMetaschema metaschema = this.getMetaschema();
        ITypeResolver typeResolver = this.getTypeResolver();
        for (IFieldDefinition definition : metaschema.getFieldDefinitions()) {
            if (definition.isSimple()) continue;
            metaschemaAnnotation.addMember("fields", "$T.class", new Object[]{typeResolver.getClassName((IFlagContainer)definition)});
        }
        for (IFieldDefinition definition : metaschema.getAssemblyDefinitions()) {
            metaschemaAnnotation.addMember("assemblies", "$T.class", new Object[]{typeResolver.getClassName((IFlagContainer)ObjectUtils.notNull((Object)definition))});
        }
        for (IMetaschema metaschemaImport : metaschema.getImportedMetaschemas()) {
            metaschemaAnnotation.addMember("imports", "$T.class", new Object[]{typeResolver.getClassName((IMetaschema)ObjectUtils.notNull((Object)metaschemaImport))});
        }
        MarkupMultiline remarks = metaschema.getRemarks();
        if (remarks != null) {
            metaschemaAnnotation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
        }
        builder.addAnnotation(metaschemaAnnotation.build());
        builder.addField(FieldSpec.builder(MarkupLine.class, (String)"NAME", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.fromMarkdown($S)", new Object[]{MarkupLine.class, metaschema.getName().toMarkdown()}).build());
        builder.addField(FieldSpec.builder(String.class, (String)"SHORT_NAME", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{metaschema.getShortName()}).build());
        builder.addField(FieldSpec.builder(String.class, (String)"VERSION", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{metaschema.getVersion()}).build());
        builder.addField(FieldSpec.builder(URI.class, (String)"XML_NAMESPACE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.create($S)", new Object[]{URI.class, metaschema.getXmlNamespace()}).build());
        builder.addField(FieldSpec.builder(URI.class, (String)"JSON_BASE_URI", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.create($S)", new Object[]{URI.class, metaschema.getJsonBaseUri()}).build());
        remarks = metaschema.getRemarks();
        if (remarks != null) {
            builder.addField(FieldSpec.builder(MarkupMultiline.class, (String)"REMARKS", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.fromMarkdown($S)", new Object[]{MarkupMultiline.class, remarks.toMarkdown()}).build());
        }
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(IMetaschema.class).box()}), "importedMetaschema", new Modifier[0]).addParameter(IBindingContext.class, "bindingContext", new Modifier[0]).addStatement("super($N, $N)", new Object[]{"importedMetaschema", "bindingContext"}).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(MarkupLine.class).addStatement("return NAME", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getShortName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return SHORT_NAME", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getVersion").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return VERSION", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getXmlNamespace").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(URI.class).addStatement("return XML_NAMESPACE", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getJsonBaseUri").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(URI.class).addStatement("return JSON_BASE_URI", new Object[0]).build());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getRemarks").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(MarkupMultiline.class);
        if (remarks == null) {
            methodBuilder.addStatement("return null", new Object[0]);
        } else {
            methodBuilder.addStatement("return REMARKS", new Object[0]);
        }
        builder.addMethod(methodBuilder.build());
        return builder;
    }
}

