/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.codegen.IGeneratedClass;
import gov.nist.secauto.metaschema.codegen.IProduction;
import gov.nist.secauto.metaschema.codegen.JavaGenerator;
import gov.nist.secauto.metaschema.codegen.binding.config.DefaultBindingConfiguration;
import gov.nist.secauto.metaschema.codegen.binding.config.IBindingConfiguration;
import gov.nist.secauto.metaschema.model.MetaschemaLoader;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.MetaschemaException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MetaschemaCompilerHelper {
    private static final Logger LOGGER = LogManager.getLogger(MetaschemaCompilerHelper.class);
    private static final MetaschemaLoader LOADER = new MetaschemaLoader();

    private MetaschemaCompilerHelper() {
    }

    @NonNull
    public static IProduction compileMetaschema(@NonNull Path metaschemaPath, @NonNull Path classDir) throws IOException, MetaschemaException {
        return MetaschemaCompilerHelper.compileMetaschema(metaschemaPath, classDir, (IBindingConfiguration)new DefaultBindingConfiguration());
    }

    @NonNull
    public static IProduction compileMetaschema(@NonNull Path metaschemaPath, @NonNull Path classDir, @NonNull IBindingConfiguration bindingConfiguration) throws IOException, MetaschemaException {
        IMetaschema metaschema = (IMetaschema)LOADER.load(metaschemaPath);
        return MetaschemaCompilerHelper.compileMetaschema(metaschema, classDir, bindingConfiguration);
    }

    @NonNull
    public static IProduction compileMetaschema(@NonNull IMetaschema metaschema, @NonNull Path classDir) throws IOException {
        return MetaschemaCompilerHelper.compileMetaschema(metaschema, classDir, (IBindingConfiguration)new DefaultBindingConfiguration());
    }

    @NonNull
    public static IProduction compileMetaschema(@NonNull IMetaschema metaschema, @NonNull Path classDir, @NonNull IBindingConfiguration bindingConfiguration) throws IOException {
        DiagnosticCollector<JavaFileObject> diagnostics;
        IProduction production = JavaGenerator.generate(metaschema, classDir, bindingConfiguration);
        List<IGeneratedClass> classesToCompile = production.getGeneratedClasses().collect(Collectors.toList());
        if (!MetaschemaCompilerHelper.compileGeneratedClasses(classesToCompile, diagnostics = new DiagnosticCollector<JavaFileObject>(), classDir)) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(diagnostics.getDiagnostics().toString());
            }
            throw new IllegalStateException(String.format("failed to compile classes: %s", classesToCompile.stream().map(clazz -> clazz.getClassName().canonicalName()).collect(Collectors.joining(","))));
        }
        return production;
    }

    @NonNull
    public static ClassLoader getClassLoader(final @NonNull Path classDir, final @NonNull ClassLoader parent) {
        return AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                try {
                    return new URLClassLoader(new URL[]{classDir.toUri().toURL()}, parent);
                }
                catch (MalformedURLException ex) {
                    throw new IllegalStateException("unable to configure class loader", ex);
                }
            }
        });
    }

    private static boolean compile(JavaCompiler compiler, JavaFileManager fileManager, DiagnosticCollector<JavaFileObject> diagnostics, List<JavaFileObject> compilationUnits, Path classDir) {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-d");
        options.add(classDir.toString());
        options.add("-classpath");
        options.add(System.getProperty("java.class.path"));
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits);
        return task.call();
    }

    private static boolean compileGeneratedClasses(List<IGeneratedClass> classesToCompile, DiagnosticCollector<JavaFileObject> diagnostics, Path classDir) throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);){
            ArrayList<JavaFileObject> compilationUnits = new ArrayList<JavaFileObject>(classesToCompile.size());
            for (IGeneratedClass generatedClass : classesToCompile) {
                compilationUnits.add(fileManager.getJavaFileObjects(generatedClass.getClassFile()).iterator().next());
            }
            boolean bl = MetaschemaCompilerHelper.compile(compiler, fileManager, diagnostics, compilationUnits, classDir);
            return bl;
        }
    }

    static {
        LOADER.allowEntityResolution();
    }
}

