/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.codegen.DefinitionProductionImpl;
import gov.nist.secauto.metaschema.codegen.IAssemblyDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.IDefinitionProduction;
import gov.nist.secauto.metaschema.codegen.IFieldDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.IGeneratedClass;
import gov.nist.secauto.metaschema.codegen.IGeneratedDefinitionClass;
import gov.nist.secauto.metaschema.codegen.IMetaschemaProduction;
import gov.nist.secauto.metaschema.codegen.IModelDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.ITypeResolver;
import gov.nist.secauto.metaschema.codegen.MetaschemaClassGenerator;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IFieldDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MetaschemaProductionImpl
implements IMetaschemaProduction {
    @NonNull
    private final IMetaschema metaschema;
    @NonNull
    private final IGeneratedClass generatedMetaschema;
    @NonNull
    private final Map<IFlagContainer, IDefinitionProduction> definitionProductions;
    @NonNull
    private final String packageName;

    public MetaschemaProductionImpl(@NonNull IMetaschema metaschema, @NonNull ITypeResolver typeResolver, @NonNull Path targetDirectory) throws IOException {
        this.metaschema = metaschema;
        MetaschemaClassGenerator generator = new MetaschemaClassGenerator(metaschema, typeResolver);
        this.generatedMetaschema = generator.generateClass(targetDirectory);
        HashSet classNames = new HashSet();
        Stream<DefinitionProductionImpl> productions = Stream.concat(metaschema.getAssemblyDefinitions().stream(), metaschema.getFieldDefinitions().stream()).map(definition -> {
            IFieldDefinition fieldDefinition;
            IModelDefinitionTypeInfo typeInfo = null;
            if (definition instanceof IAssemblyDefinition) {
                typeInfo = IAssemblyDefinitionTypeInfo.newTypeInfo((IAssemblyDefinition)definition, typeResolver);
            } else if (definition instanceof IFieldDefinition && !(fieldDefinition = (IFieldDefinition)definition).getFlagInstances().isEmpty()) {
                typeInfo = IFieldDefinitionTypeInfo.newTypeInfo((IFieldDefinition)definition, typeResolver);
            }
            return typeInfo;
        }).flatMap(ObjectUtils::filterNull).map(typeInfo -> {
            IGeneratedDefinitionClass generatedClass;
            IFlagContainer definition = typeInfo.getDefinition();
            try {
                generatedClass = typeInfo.generateClass(targetDirectory);
            }
            catch (RuntimeException ex) {
                throw new IllegalStateException(String.format("Unable to generate class for definition '%s' in Metaschema '%s'", definition.getName(), metaschema.getLocation()), ex);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            String className = generatedClass.getClassName().canonicalName();
            if (classNames.contains(className)) {
                throw new IllegalStateException(String.format("Found duplicate class '%s' in metaschema '%s'. All class names must be unique within the same namespace.", className, metaschema.getLocation()));
            }
            classNames.add(className);
            return new DefinitionProductionImpl(definition, generatedClass);
        });
        Map retval = productions.collect(Collectors.toUnmodifiableMap(DefinitionProductionImpl::getDefinition, Function.identity()));
        this.definitionProductions = retval;
        this.packageName = typeResolver.getPackageName(metaschema);
    }

    @Override
    public IMetaschema getMetaschema() {
        return this.metaschema;
    }

    @Override
    public IGeneratedClass getGeneratedMetaschema() {
        return this.generatedMetaschema;
    }

    @Override
    public Collection<? extends IFlagContainer> getGlobalDefinitions() {
        return this.definitionProductions.keySet();
    }

    @Override
    public Collection<IDefinitionProduction> getDefinitionProductions() {
        return this.definitionProductions.values();
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public Stream<IGeneratedClass> getGeneratedClasses() {
        return (Stream)ObjectUtils.notNull(Stream.concat(Stream.of(this.getGeneratedMetaschema()), this.getDefinitionProductions().stream().map(definition -> definition.getGeneratedClass())));
    }
}

