/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.binding.model.annotations.BoundField;
import gov.nist.secauto.metaschema.binding.model.annotations.BoundFieldValue;
import gov.nist.secauto.metaschema.binding.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.codegen.AbstractInstanceTypeInfo;
import gov.nist.secauto.metaschema.codegen.AnnotationUtils;
import gov.nist.secauto.metaschema.codegen.ClassUtils;
import gov.nist.secauto.metaschema.codegen.IAssemblyDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.IFlagInstanceTypeInfo;
import gov.nist.secauto.metaschema.codegen.IModelDefinitionTypeInfo;
import gov.nist.secauto.metaschema.codegen.IModelInstanceTypeInfo;
import gov.nist.secauto.metaschema.codegen.ITypeResolver;
import gov.nist.secauto.metaschema.model.common.IAssemblyInstance;
import gov.nist.secauto.metaschema.model.common.IFieldDefinition;
import gov.nist.secauto.metaschema.model.common.IFieldInstance;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import gov.nist.secauto.metaschema.model.common.INamedModelInstance;
import gov.nist.secauto.metaschema.model.common.IValuedDefinition;
import gov.nist.secauto.metaschema.model.common.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.MetaschemaModelConstants;
import gov.nist.secauto.metaschema.model.common.XmlGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.adapter.MetaschemaDataTypeProvider;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ModelInstanceTypeInfoImpl
extends AbstractInstanceTypeInfo<INamedModelInstance, IAssemblyDefinitionTypeInfo>
implements IModelInstanceTypeInfo {
    private static final Logger LOGGER = LogManager.getLogger(ModelInstanceTypeInfoImpl.class);

    public ModelInstanceTypeInfoImpl(@NonNull INamedModelInstance instance, @NonNull IAssemblyDefinitionTypeInfo parentDefinition) {
        super(instance, parentDefinition);
    }

    @Override
    @NonNull
    public String getBaseName() {
        INamedModelInstance modelInstance = (INamedModelInstance)this.getInstance();
        String retval = modelInstance.getMaxOccurs() == -1 || modelInstance.getMaxOccurs() > 1 ? (String)ObjectUtils.notNull((Object)modelInstance.getGroupAsName()) : modelInstance.getEffectiveName();
        return retval;
    }

    @Override
    public String getItemBaseName() {
        return ((INamedModelInstance)this.getInstance()).getEffectiveName();
    }

    @Override
    @NonNull
    public TypeName getJavaItemType() {
        ClassName retval;
        INamedModelInstance instance = (INamedModelInstance)this.getInstance();
        if (instance instanceof IFieldInstance) {
            IFieldInstance fieldInstance = (IFieldInstance)instance;
            if (fieldInstance.isSimple()) {
                IDataTypeAdapter dataType = fieldInstance.getDefinition().getJavaTypeAdapter();
                retval = (TypeName)ObjectUtils.notNull((Object)ClassName.get((Class)dataType.getJavaClass()));
            } else {
                retval = ((IAssemblyDefinitionTypeInfo)this.getParentDefinitionTypeInfo()).getTypeResolver().getClassName((IFlagContainer)fieldInstance.getDefinition());
            }
        } else if (instance instanceof IAssemblyInstance) {
            IAssemblyInstance assemblyInstance = (IAssemblyInstance)instance;
            retval = ((IAssemblyDefinitionTypeInfo)this.getParentDefinitionTypeInfo()).getTypeResolver().getClassName((IFlagContainer)assemblyInstance.getDefinition());
        } else {
            String msg = String.format("Unknown model instance type: %s", instance.getClass().getCanonicalName());
            LOGGER.error(msg);
            throw new IllegalStateException(msg);
        }
        return retval;
    }

    @Override
    @NonNull
    public TypeName getJavaFieldType() {
        TypeName item = this.getJavaItemType();
        INamedModelInstance instance = (INamedModelInstance)this.getInstance();
        int maxOccurance = instance.getMaxOccurs();
        TypeName retval = maxOccurance == -1 || maxOccurance > 1 ? (JsonGroupAsBehavior.KEYED.equals((Object)instance.getJsonGroupAsBehavior()) ? (TypeName)ObjectUtils.notNull((Object)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), item})) : (TypeName)ObjectUtils.notNull((Object)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{item}))) : item;
        return retval;
    }

    @Override
    public Set<IFlagContainer> buildField(FieldSpec.Builder builder) {
        IFieldInstance fieldInstance;
        MarkupMultiline remarks;
        int maxOccurs;
        String namespace;
        MarkupLine description;
        AnnotationSpec.Builder javaFieldAnnoation;
        HashSet<IFlagContainer> retval = new HashSet<IFlagContainer>();
        retval.addAll(super.buildField(builder));
        INamedModelInstance modelInstance = (INamedModelInstance)this.getInstance();
        if (modelInstance instanceof IFieldInstance) {
            javaFieldAnnoation = AnnotationSpec.builder(BoundField.class);
        } else if (modelInstance instanceof IAssemblyInstance) {
            javaFieldAnnoation = AnnotationSpec.builder(BoundAssembly.class);
        } else {
            throw new UnsupportedOperationException(String.format("Model instance '%s' of type '%s' is not supported.", modelInstance.getName(), modelInstance.getClass().getName()));
        }
        String formalName = modelInstance.getEffectiveFormalName();
        if (formalName != null) {
            javaFieldAnnoation.addMember("formalName", "$S", new Object[]{formalName});
        }
        if ((description = modelInstance.getEffectiveDescription()) != null) {
            javaFieldAnnoation.addMember("description", "$S", new Object[]{description.toMarkdown()});
        }
        javaFieldAnnoation.addMember("useName", "$S", new Object[]{modelInstance.getEffectiveName()});
        IFlagContainer definition = modelInstance.getDefinition();
        if (!(!definition.isInline() || definition instanceof IFieldDefinition && definition.isSimple())) {
            retval.add(definition);
        }
        if ((namespace = modelInstance.getXmlNamespace()) == null) {
            javaFieldAnnoation.addMember("namespace", "$S", new Object[]{"##none"});
        } else if (!modelInstance.getContainingMetaschema().getXmlNamespace().toASCIIString().equals(namespace)) {
            javaFieldAnnoation.addMember("namespace", "$S", new Object[]{namespace});
        }
        int minOccurs = modelInstance.getMinOccurs();
        if (minOccurs != 0) {
            javaFieldAnnoation.addMember("minOccurs", "$L", new Object[]{minOccurs});
        }
        if ((maxOccurs = modelInstance.getMaxOccurs()) != 1) {
            javaFieldAnnoation.addMember("maxOccurs", "$L", new Object[]{maxOccurs});
        }
        if ((remarks = modelInstance.getRemarks()) != null) {
            javaFieldAnnoation.addMember("remarks", "$S", new Object[]{remarks.toMarkdown()});
        }
        if (modelInstance instanceof IFieldInstance && !(fieldInstance = (IFieldInstance)modelInstance).isInXmlWrapped()) {
            javaFieldAnnoation.addMember("inXmlWrapped", "$L", new Object[]{fieldInstance.isInXmlWrapped()});
        }
        builder.addAnnotation(javaFieldAnnoation.build());
        if (modelInstance instanceof IFieldInstance && (fieldInstance = (IFieldInstance)modelInstance).isSimple()) {
            IFieldDefinition fieldDefinition = (IFieldDefinition)definition;
            IDataTypeAdapter valueDataType = fieldDefinition.getJavaTypeAdapter();
            Object defaultValue = fieldDefinition.getDefaultValue();
            if (!MetaschemaDataTypeProvider.DEFAULT_DATA_TYPE.equals(valueDataType) || defaultValue != null) {
                AnnotationSpec.Builder boundFieldValueAnnotation = AnnotationSpec.builder(BoundFieldValue.class);
                if (!MetaschemaDataTypeProvider.DEFAULT_DATA_TYPE.equals(valueDataType)) {
                    boundFieldValueAnnotation.addMember("typeAdapter", "$T.class", new Object[]{valueDataType.getClass()});
                }
                if (defaultValue != null) {
                    boundFieldValueAnnotation.addMember("defaultValue", "$S", new Object[]{valueDataType.asString(defaultValue)});
                }
                builder.addAnnotation(boundFieldValueAnnotation.build());
            }
            AnnotationUtils.buildValueConstraints(builder, (IValuedDefinition)fieldDefinition);
        }
        if (maxOccurs == -1 || maxOccurs > 1) {
            AnnotationSpec.Builder groupAsAnnoation = AnnotationSpec.builder(GroupAs.class);
            groupAsAnnoation.addMember("name", "$S", new Object[]{ObjectUtils.requireNonNull((Object)modelInstance.getGroupAsName(), (String)"The grouping name must be non-null")});
            String groupAsNamespace = modelInstance.getGroupAsXmlNamespace();
            if (groupAsNamespace == null) {
                groupAsAnnoation.addMember("namespace", "$S", new Object[]{"##none"});
            } else if (!modelInstance.getContainingMetaschema().getXmlNamespace().toASCIIString().equals(groupAsNamespace)) {
                groupAsAnnoation.addMember("namespace", "$S", new Object[]{groupAsNamespace});
            }
            JsonGroupAsBehavior jsonGroupAsBehavior = modelInstance.getJsonGroupAsBehavior();
            assert (jsonGroupAsBehavior != null);
            if (!MetaschemaModelConstants.DEFAULT_JSON_GROUP_AS_BEHAVIOR.equals((Object)jsonGroupAsBehavior)) {
                groupAsAnnoation.addMember("inJson", "$T.$L", new Object[]{JsonGroupAsBehavior.class, jsonGroupAsBehavior.toString()});
            }
            XmlGroupAsBehavior xmlGroupAsBehavior = modelInstance.getXmlGroupAsBehavior();
            assert (xmlGroupAsBehavior != null);
            if (!MetaschemaModelConstants.DEFAULT_XML_GROUP_AS_BEHAVIOR.equals((Object)xmlGroupAsBehavior)) {
                groupAsAnnoation.addMember("inXml", "$T.$L", new Object[]{XmlGroupAsBehavior.class, xmlGroupAsBehavior.toString()});
            }
            builder.addAnnotation(groupAsAnnoation.build());
        }
        return retval.isEmpty() ? CollectionUtil.emptySet() : CollectionUtil.unmodifiableSet(retval);
    }

    @Override
    public void buildExtraMethods(@NonNull TypeSpec.Builder builder, @NonNull FieldSpec valueField, @NonNull ITypeResolver typeResolver) {
        INamedModelInstance instance = (INamedModelInstance)this.getInstance();
        int maxOccurance = instance.getMaxOccurs();
        if (maxOccurance == -1 || maxOccurance > 1) {
            TypeName itemType = this.getJavaItemType();
            ParameterSpec valueParam = ParameterSpec.builder((TypeName)itemType, (String)"item", (Modifier[])new Modifier[0]).build();
            String itemPropertyName = ClassUtils.toPropertyName(this.getItemBaseName());
            if (JsonGroupAsBehavior.KEYED.equals((Object)instance.getJsonGroupAsBehavior())) {
                IFlagInstance jsonKey = instance.getJsonKeyFlagInstance();
                if (jsonKey == null) {
                    throw new IllegalStateException(String.format("JSON key not defined for property: %s", instance.toCoordinates()));
                }
                IModelDefinitionTypeInfo instanceTypeInfo = typeResolver.getTypeInfo(instance.getDefinition());
                IFlagInstanceTypeInfo jsonKeyTypeInfo = instanceTypeInfo.getFlagInstanceTypeInfo(jsonKey);
                if (jsonKeyTypeInfo == null) {
                    throw new IllegalStateException(String.format("Unable to identify JSON key for property: %s", instance.toCoordinates()));
                }
                MethodSpec.Builder method = MethodSpec.methodBuilder((String)("add" + itemPropertyName)).addParameter(valueParam).returns(itemType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Add a new {@link $T} item to the underlying collection.\n", new Object[]{itemType}).addJavadoc("@param item the item to add\n", new Object[0]).addJavadoc("@return the existing {@link $T} item in the collection or {@code null} if not item exists\n", new Object[]{itemType}).addStatement("$1T value = $2T.requireNonNull($3N,\"$3N value cannot be null\")", new Object[]{itemType, ObjectUtils.class, valueParam}).addStatement("$1T key = $2T.requireNonNull($3N.$4N(),\"$3N key cannot be null\")", new Object[]{String.class, ObjectUtils.class, valueParam, "get" + jsonKeyTypeInfo.getPropertyName()}).beginControlFlow("if ($N == null)", new Object[]{valueField}).addStatement("$N = new $T<>()", new Object[]{valueField, LinkedHashMap.class}).endControlFlow().addStatement("return $N.put(key, value)", new Object[]{valueField});
                builder.addMethod(method.build());
                method = MethodSpec.methodBuilder((String)("remove" + itemPropertyName)).addParameter(valueParam).returns(TypeName.BOOLEAN).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Remove the {@link $T} item from the underlying collection.\n", new Object[]{itemType}).addJavadoc("@param item the item to remove\n", new Object[0]).addJavadoc("@return {@code true} if the item was removed or {@code false} otherwise\n", new Object[0]).addStatement("$1T value = $2T.requireNonNull($3N,\"$3N value cannot be null\")", new Object[]{itemType, ObjectUtils.class, valueParam}).addStatement("$1T key = $2T.requireNonNull($3N.$4N(),\"$3N key cannot be null\")", new Object[]{String.class, ObjectUtils.class, valueParam, "get" + jsonKeyTypeInfo.getPropertyName()}).addStatement("return $1N == null ? false : $1N.remove(key, value)", new Object[]{valueField});
                builder.addMethod(method.build());
            } else {
                MethodSpec.Builder method = MethodSpec.methodBuilder((String)("add" + itemPropertyName)).addParameter(valueParam).returns(TypeName.BOOLEAN).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Add a new {@link $T} item to the underlying collection.\n", new Object[]{itemType}).addJavadoc("@param item the item to add\n", new Object[0]).addJavadoc("@return {@code true}\n", new Object[0]).addStatement("$T value = $T.requireNonNull($N,\"$N cannot be null\")", new Object[]{itemType, ObjectUtils.class, valueParam, valueParam}).beginControlFlow("if ($N == null)", new Object[]{valueField}).addStatement("$N = new $T<>()", new Object[]{valueField, LinkedList.class}).endControlFlow().addStatement("return $N.add(value)", new Object[]{valueField});
                builder.addMethod(method.build());
                method = MethodSpec.methodBuilder((String)("remove" + itemPropertyName)).addParameter(valueParam).returns(TypeName.BOOLEAN).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Remove the first matching {@link $T} item from the underlying collection.\n", new Object[]{itemType}).addJavadoc("@param item the item to remove\n", new Object[0]).addJavadoc("@return {@code true} if the item was removed or {@code false} otherwise\n", new Object[0]).addStatement("$T value = $T.requireNonNull($N,\"$N cannot be null\")", new Object[]{itemType, ObjectUtils.class, valueParam, valueParam}).addStatement("return $1N == null ? false : $1N.remove(value)", new Object[]{valueField});
                builder.addMethod(method.build());
            }
        }
    }
}

