/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.codegen.IMetaschemaProduction;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;

class PackageMetadata {
    @NonNull
    private final String packageName;
    @NonNull
    private final URI xmlNamespace;
    @NonNull
    private final List<IMetaschemaProduction> metaschemaProductions = new LinkedList<IMetaschemaProduction>();

    public PackageMetadata(@NonNull IMetaschemaProduction metaschemaProduction) {
        this.packageName = metaschemaProduction.getPackageName();
        this.xmlNamespace = metaschemaProduction.getMetaschema().getXmlNamespace();
        this.metaschemaProductions.add(metaschemaProduction);
    }

    @NonNull
    protected String getPackageName() {
        return this.packageName;
    }

    @NonNull
    protected URI getXmlNamespace() {
        return this.xmlNamespace;
    }

    @NonNull
    protected List<IMetaschemaProduction> getMetaschemaProductions() {
        return this.metaschemaProductions;
    }

    public void addMetaschema(@NonNull IMetaschemaProduction metaschemaProduction) {
        URI nextXmlNamespace = metaschemaProduction.getMetaschema().getXmlNamespace();
        if (!this.xmlNamespace.equals(nextXmlNamespace)) {
            throw new IllegalStateException(String.format("The package %s is associated with the XML namespaces '%s' and '%s'. A package must be associated with a single XML namespace.", this.getPackageName(), this.getXmlNamespace().toASCIIString(), nextXmlNamespace.toASCIIString()));
        }
        this.metaschemaProductions.add(metaschemaProduction);
    }
}

