/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import com.squareup.javapoet.ClassName;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.binding.model.annotations.MetaschemaPackage;
import gov.nist.secauto.metaschema.binding.model.annotations.XmlNs;
import gov.nist.secauto.metaschema.binding.model.annotations.XmlNsForm;
import gov.nist.secauto.metaschema.binding.model.annotations.XmlSchema;
import gov.nist.secauto.metaschema.codegen.DefaultGeneratedClass;
import gov.nist.secauto.metaschema.codegen.IGeneratedClass;
import gov.nist.secauto.metaschema.codegen.IMetaschemaProduction;
import gov.nist.secauto.metaschema.codegen.IPackageProduction;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;

class PackageProductionImpl
implements IPackageProduction {
    @NonNull
    private final String javaPackage;
    @NonNull
    private final URI xmlNamespace;
    @NonNull
    private final DefaultGeneratedClass packageInfoClass;

    public PackageProductionImpl(@NonNull String javaPackage, @NonNull URI xmlNamespace, @NonNull List<IMetaschemaProduction> metaschemaProductions, @NonNull Path targetDirectory) throws IOException {
        this.javaPackage = javaPackage;
        this.xmlNamespace = xmlNamespace;
        String packagePath = javaPackage.replace(".", "/");
        Path packageInfo = (Path)ObjectUtils.notNull((Object)targetDirectory.resolve(packagePath + "/package-info.java"));
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(packageInfo, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));){
            writer.format("@%1$s(metaschemas = {%n", MetaschemaPackage.class.getName());
            boolean first = true;
            for (IMetaschemaProduction metaschemaProduction : metaschemaProductions) {
                if (first) {
                    first = false;
                } else {
                    writer.format(",%n", new Object[0]);
                }
                IGeneratedClass generatedMetaschema = metaschemaProduction.getGeneratedMetaschema();
                writer.format("  %1$s.class", generatedMetaschema.getClassName().canonicalName());
            }
            writer.format("})%n", new Object[0]);
            writer.format("@%1$s(namespace = \"%2$s\", xmlns = {@%3$s(prefix = \"\", namespace = \"%2$s\")}, xmlElementFormDefault = %4$s.QUALIFIED)%n", XmlSchema.class.getName(), xmlNamespace.toString(), XmlNs.class.getName(), XmlNsForm.class.getName());
            writer.format("package %s;%n", javaPackage);
        }
        this.packageInfoClass = new DefaultGeneratedClass(packageInfo, (ClassName)ObjectUtils.notNull((Object)ClassName.get((String)javaPackage, (String)"package-info", (String[])new String[0])));
    }

    @Override
    public String getJavaPackage() {
        return this.javaPackage;
    }

    @Override
    public URI getXmlNamespace() {
        return this.xmlNamespace;
    }

    @Override
    public DefaultGeneratedClass getGeneratedClass() {
        return this.packageInfoClass;
    }
}

