/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.codegen.IDefinitionProduction;
import gov.nist.secauto.metaschema.codegen.IGeneratedClass;
import gov.nist.secauto.metaschema.codegen.IMetaschemaProduction;
import gov.nist.secauto.metaschema.codegen.IPackageProduction;
import gov.nist.secauto.metaschema.codegen.IProduction;
import gov.nist.secauto.metaschema.codegen.ITypeResolver;
import gov.nist.secauto.metaschema.codegen.MetaschemaProductionImpl;
import gov.nist.secauto.metaschema.codegen.PackageProductionImpl;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

class ProductionImpl
implements IProduction {
    @NonNull
    private final Map<IMetaschema, MetaschemaProductionImpl> metaschemaToProductionMap = new HashMap<IMetaschema, MetaschemaProductionImpl>();
    @NonNull
    private final Map<String, IPackageProduction> packageNameToProductionMap = new HashMap<String, IPackageProduction>();

    ProductionImpl() {
    }

    public void processMetaschema(@NonNull IMetaschema metaschema, @NonNull ITypeResolver typeResolver, @NonNull Path targetDirectory) throws IOException {
        for (IMetaschema importedMetaschema : metaschema.getImportedMetaschemas()) {
            assert (importedMetaschema != null);
            this.processMetaschema(importedMetaschema, typeResolver, targetDirectory);
        }
        if (this.getMetaschemaProduction(metaschema) == null) {
            this.addMetaschema(metaschema, typeResolver, targetDirectory);
        }
    }

    public IMetaschemaProduction addMetaschema(@NonNull IMetaschema metaschema, @NonNull ITypeResolver typeResolver, @NonNull Path targetDirectory) throws IOException {
        IMetaschemaProduction retval = this.metaschemaToProductionMap.get(metaschema);
        if (retval == null) {
            this.metaschemaToProductionMap.put(metaschema, new MetaschemaProductionImpl(metaschema, typeResolver, targetDirectory));
        }
        return retval;
    }

    public IPackageProduction addPackage(@NonNull String javaPackage, @NonNull URI xmlNamespace, @NonNull List<IMetaschemaProduction> metaschemaProductions, @NonNull Path targetDirectory) throws IOException {
        PackageProductionImpl retval = new PackageProductionImpl(javaPackage, xmlNamespace, metaschemaProductions, targetDirectory);
        this.packageNameToProductionMap.put(javaPackage, retval);
        return retval;
    }

    @Override
    public Collection<IMetaschemaProduction> getMetaschemaProductions() {
        return Collections.unmodifiableCollection(this.metaschemaToProductionMap.values());
    }

    @NonNull
    protected Collection<IPackageProduction> getPackageProductions() {
        return Collections.unmodifiableCollection(this.packageNameToProductionMap.values());
    }

    @Override
    public IMetaschemaProduction getMetaschemaProduction(IMetaschema metaschema) {
        return this.metaschemaToProductionMap.get(metaschema);
    }

    @Override
    public Stream<IDefinitionProduction> getDefinitionProductionsAsStream() {
        return (Stream)ObjectUtils.notNull(this.getMetaschemaProductions().stream().flatMap(metaschema -> metaschema.getDefinitionProductions().stream()));
    }

    @Override
    public Stream<IGeneratedClass> getGeneratedClasses() {
        return (Stream)ObjectUtils.notNull(Stream.concat(this.getMetaschemaProductions().stream().flatMap(metaschema -> metaschema.getGeneratedClasses()), this.getPackageProductions().stream().flatMap(javaPackage -> Stream.of(javaPackage.getGeneratedClass()))));
    }
}

