/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen.binding;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.DefaultBindingContext;
import gov.nist.secauto.metaschema.binding.IBindingMatcher;
import gov.nist.secauto.metaschema.binding.model.IAssemblyClassBinding;
import gov.nist.secauto.metaschema.codegen.IProduction;
import gov.nist.secauto.metaschema.codegen.MetaschemaCompilerHelper;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.xml.namespace.QName;

public class DynamicBindingContext
extends DefaultBindingContext {
    @NonNull
    public static DynamicBindingContext forMetaschema(@NonNull IMetaschema metaschema, @Nullable Path tempPath) throws IOException {
        Path classDir = tempPath == null ? Files.createTempDirectory("classes-", new FileAttribute[0]) : Files.createTempDirectory(tempPath, "classes-", new FileAttribute[0]);
        classDir.toFile().deleteOnExit();
        IProduction production = MetaschemaCompilerHelper.compileMetaschema(metaschema, classDir);
        return new DynamicBindingContext(production, MetaschemaCompilerHelper.getClassLoader(classDir, (ClassLoader)ObjectUtils.notNull((Object)Thread.currentThread().getContextClassLoader())));
    }

    public DynamicBindingContext(@NonNull IProduction production, ClassLoader classLoader) {
        production.getDefinitionProductionsAsStream().filter(definitionProduction -> {
            IAssemblyDefinition assembly;
            boolean retval = false;
            IFlagContainer definition = definitionProduction.getDefinition();
            if (definition instanceof IAssemblyDefinition && (assembly = (IAssemblyDefinition)definition).isRoot()) {
                retval = true;
            }
            return retval;
        }).map(definitionProduction -> {
            IAssemblyDefinition definition = (IAssemblyDefinition)definitionProduction.getDefinition();
            try {
                Class clazz = (Class)ObjectUtils.notNull(classLoader.loadClass(definitionProduction.getGeneratedClass().getClassName().reflectionName()));
                return new DynamicBindingMatcher(definition, clazz);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }).forEachOrdered(matcher -> this.registerBindingMatcher((IBindingMatcher)ObjectUtils.notNull((Object)matcher)));
    }

    private static class DynamicBindingMatcher
    implements IBindingMatcher {
        private final IAssemblyDefinition definition;
        private final Class<IAssemblyClassBinding> clazz;

        public DynamicBindingMatcher(@NonNull IAssemblyDefinition definition, @NonNull Class<IAssemblyClassBinding> clazz) {
            this.definition = definition;
            this.clazz = clazz;
        }

        protected IAssemblyDefinition getDefinition() {
            return this.definition;
        }

        protected Class<IAssemblyClassBinding> getClazz() {
            return this.clazz;
        }

        @NonNull
        protected QName getRootQName() {
            return this.getDefinition().getRootXmlQName();
        }

        @NonNull
        protected String getRootJsonName() {
            return this.getDefinition().getRootJsonName();
        }

        public Class<?> getBoundClassForXmlQName(QName rootQName) {
            return this.getRootQName().equals(rootQName) ? this.getClazz() : null;
        }

        public Class<?> getBoundClassForJsonName(String rootName) {
            return this.getRootJsonName().equals(rootName) ? this.getClazz() : null;
        }
    }
}

