/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen.binding.config;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.codegen.ClassUtils;
import gov.nist.secauto.metaschema.codegen.binding.config.DefaultDefinitionBindingConfiguration;
import gov.nist.secauto.metaschema.codegen.binding.config.IBindingConfiguration;
import gov.nist.secauto.metaschema.codegen.binding.config.IDefinitionBindingConfiguration;
import gov.nist.secauto.metaschema.codegen.binding.config.IMutableDefinitionBindingConfiguration;
import gov.nist.secauto.metaschema.codegen.xmlbeans.JavaModelBindingType;
import gov.nist.secauto.metaschema.codegen.xmlbeans.JavaObjectDefinitionBindingType;
import gov.nist.secauto.metaschema.codegen.xmlbeans.MetaschemaBindingType;
import gov.nist.secauto.metaschema.codegen.xmlbeans.MetaschemaBindingsDocument;
import gov.nist.secauto.metaschema.codegen.xmlbeans.MetaschemaBindingsType;
import gov.nist.secauto.metaschema.codegen.xmlbeans.ModelBindingType;
import gov.nist.secauto.metaschema.codegen.xmlbeans.ObjectDefinitionBindingType;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.xmlbeans.XmlException;

public class DefaultBindingConfiguration
implements IBindingConfiguration {
    private final Map<String, String> namespaceToPackageNameMap = new ConcurrentHashMap<String, String>();
    private final Map<String, MetaschemaBindingConfiguration> metaschemaUrlToMetaschemaBindingConfigurationMap = new ConcurrentHashMap<String, MetaschemaBindingConfiguration>();

    @Override
    public String getPackageNameForMetaschema(IMetaschema metaschema) {
        URI namespace = metaschema.getXmlNamespace();
        return this.getPackageNameForNamespace((String)ObjectUtils.notNull((Object)namespace.toASCIIString()));
    }

    @Nullable
    public IDefinitionBindingConfiguration getBindingConfigurationForDefinition(@NonNull IFlagContainer definition) {
        String metaschemaUri = (String)ObjectUtils.notNull((Object)definition.getContainingMetaschema().getLocation().toString());
        String definitionName = definition.getName();
        MetaschemaBindingConfiguration metaschemaConfig = this.getMetaschemaBindingConfiguration(metaschemaUri);
        IDefinitionBindingConfiguration retval = null;
        if (metaschemaConfig != null) {
            switch (definition.getModelType()) {
                case ASSEMBLY: {
                    retval = metaschemaConfig.getAssemblyDefinitionBindingConfig(definitionName);
                    break;
                }
                case FIELD: {
                    retval = metaschemaConfig.getFieldDefinitionBindingConfig(definitionName);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported definition type '%s'", definition.getModelType()));
                }
            }
        }
        return retval;
    }

    @Override
    public String getQualifiedBaseClassName(IFlagContainer definition) {
        IDefinitionBindingConfiguration config = this.getBindingConfigurationForDefinition(definition);
        String retval = null;
        if (config != null) {
            retval = config.getQualifiedBaseClassName();
        }
        return retval;
    }

    @Override
    public String getClassName(IFlagContainer definition) {
        IDefinitionBindingConfiguration config = this.getBindingConfigurationForDefinition(definition);
        String retval = null;
        if (config != null) {
            retval = config.getClassName();
        }
        if (retval == null) {
            retval = ClassUtils.toClassName(definition.getName());
        }
        return retval;
    }

    @Override
    @NonNull
    public String getClassName(@NonNull IMetaschema metaschema) {
        return ClassUtils.toClassName(metaschema.getShortName() + "Metaschema");
    }

    public void addModelBindingConfig(String namespace, String packageName) {
        if (this.namespaceToPackageNameMap.containsKey(namespace)) {
            String oldPackageName = this.namespaceToPackageNameMap.get(namespace);
            if (!oldPackageName.equals(packageName)) {
                throw new IllegalStateException(String.format("Attempt to redefine existing package name '%s' to '%s' for namespace '%s'", oldPackageName, packageName, namespace));
            }
        } else {
            this.namespaceToPackageNameMap.put(namespace, packageName);
        }
    }

    @NonNull
    protected String getPackageNameForNamespace(@NonNull String namespace) {
        String packageName = this.namespaceToPackageNameMap.get(namespace);
        if (packageName == null) {
            packageName = ClassUtils.toPackageName(namespace);
        }
        return packageName;
    }

    protected MetaschemaBindingConfiguration getMetaschemaBindingConfiguration(@NonNull IMetaschema metaschema) {
        String metaschemaUri = (String)ObjectUtils.notNull((Object)metaschema.getLocation().toString());
        return this.getMetaschemaBindingConfiguration(metaschemaUri);
    }

    @Nullable
    protected MetaschemaBindingConfiguration getMetaschemaBindingConfiguration(@NonNull String metaschemaUri) {
        return this.metaschemaUrlToMetaschemaBindingConfigurationMap.get(metaschemaUri);
    }

    public MetaschemaBindingConfiguration addMetaschemaBindingConfiguration(@NonNull String metaschemaUri, @NonNull MetaschemaBindingConfiguration config) {
        Objects.requireNonNull(metaschemaUri, "metaschemaUri");
        Objects.requireNonNull(config, "config");
        return this.metaschemaUrlToMetaschemaBindingConfigurationMap.put(metaschemaUri, config);
    }

    public void load(Path file) throws IOException {
        URL resource = file.toUri().toURL();
        this.load(resource);
    }

    public void load(File file) throws IOException {
        URL resource = file.toURI().toURL();
        this.load(resource);
    }

    public void load(URL resource) throws IOException {
        MetaschemaBindingsDocument xml;
        try {
            xml = (MetaschemaBindingsDocument)MetaschemaBindingsDocument.Factory.parse(resource);
        }
        catch (XmlException ex) {
            throw new IOException(ex);
        }
        MetaschemaBindingsType bindings = xml.getMetaschemaBindings();
        for (ModelBindingType model : bindings.getModelBindingList()) {
            this.processModelBindingConfig(model);
        }
        for (MetaschemaBindingType metaschema : bindings.getMetaschemaBindingList()) {
            try {
                this.processMetaschemaBindingConfig(resource, metaschema);
            }
            catch (MalformedURLException | URISyntaxException ex) {
                throw new IOException(ex);
            }
        }
    }

    private void processModelBindingConfig(ModelBindingType model) {
        JavaModelBindingType java;
        String namespace = model.getNamespace();
        if (model.isSetJava() && (java = model.getJava()).isSetUsePackageName()) {
            this.addModelBindingConfig(namespace, java.getUsePackageName());
        }
    }

    private void processMetaschemaBindingConfig(URL configResource, MetaschemaBindingType metaschema) throws MalformedURLException, URISyntaxException {
        IDefinitionBindingConfiguration config;
        String name;
        String href = metaschema.getHref();
        URL metaschemaUrl = new URL(configResource, href);
        String metaschemaUri = (String)ObjectUtils.notNull((Object)metaschemaUrl.toURI().toString());
        MetaschemaBindingConfiguration metaschemaConfig = this.getMetaschemaBindingConfiguration(metaschemaUri);
        if (metaschemaConfig == null) {
            metaschemaConfig = new MetaschemaBindingConfiguration();
            this.addMetaschemaBindingConfiguration(metaschemaUri, metaschemaConfig);
        }
        for (ObjectDefinitionBindingType assemblyBinding : metaschema.getDefineAssemblyBindingList()) {
            name = (String)ObjectUtils.requireNonNull((Object)assemblyBinding.getName());
            config = metaschemaConfig.getAssemblyDefinitionBindingConfig(name);
            config = DefaultBindingConfiguration.processDefinitionBindingConfiguration(config, assemblyBinding);
            metaschemaConfig.addAssemblyDefinitionBindingConfig(name, config);
        }
        for (ObjectDefinitionBindingType fieldBinding : metaschema.getDefineFieldBindingList()) {
            name = (String)ObjectUtils.requireNonNull((Object)fieldBinding.getName());
            config = metaschemaConfig.getFieldDefinitionBindingConfig(name);
            config = DefaultBindingConfiguration.processDefinitionBindingConfiguration(config, fieldBinding);
            metaschemaConfig.addFieldDefinitionBindingConfig(name, config);
        }
    }

    @NonNull
    private static IMutableDefinitionBindingConfiguration processDefinitionBindingConfiguration(@Nullable IDefinitionBindingConfiguration oldConfig, @NonNull ObjectDefinitionBindingType objectDefinitionBinding) {
        DefaultDefinitionBindingConfiguration config = oldConfig != null ? new DefaultDefinitionBindingConfiguration(oldConfig) : new DefaultDefinitionBindingConfiguration();
        if (objectDefinitionBinding.isSetJava()) {
            JavaObjectDefinitionBindingType java = objectDefinitionBinding.getJava();
            if (java.isSetUseClassName()) {
                config.setClassName((String)ObjectUtils.notNull((Object)java.getUseClassName()));
            }
            if (java.isSetExtendBaseClass()) {
                config.setQualifiedBaseClassName((String)ObjectUtils.notNull((Object)java.getExtendBaseClass()));
            }
            for (String interfaceName : java.getImplementInterfaceList()) {
                config.addInterfaceToImplement((String)ObjectUtils.notNull((Object)interfaceName));
            }
        }
        return config;
    }

    public static final class MetaschemaBindingConfiguration {
        private final Map<String, IDefinitionBindingConfiguration> assemblyBindingConfigs = new ConcurrentHashMap<String, IDefinitionBindingConfiguration>();
        private final Map<String, IDefinitionBindingConfiguration> fieldBindingConfigs = new ConcurrentHashMap<String, IDefinitionBindingConfiguration>();

        private MetaschemaBindingConfiguration() {
        }

        @Nullable
        public IDefinitionBindingConfiguration getAssemblyDefinitionBindingConfig(@NonNull String name) {
            return this.assemblyBindingConfigs.get(name);
        }

        @Nullable
        public IDefinitionBindingConfiguration getFieldDefinitionBindingConfig(@NonNull String name) {
            return this.fieldBindingConfigs.get(name);
        }

        @Nullable
        public IDefinitionBindingConfiguration addAssemblyDefinitionBindingConfig(@NonNull String name, @NonNull IDefinitionBindingConfiguration config) {
            return this.assemblyBindingConfigs.put(name, config);
        }

        @Nullable
        public IDefinitionBindingConfiguration addFieldDefinitionBindingConfig(@NonNull String name, @NonNull IDefinitionBindingConfiguration config) {
            return this.fieldBindingConfigs.put(name, config);
        }
    }
}

