/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.codegen.binding.config;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.codegen.binding.config.IDefinitionBindingConfiguration;
import gov.nist.secauto.metaschema.codegen.binding.config.IMutableDefinitionBindingConfiguration;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DefaultDefinitionBindingConfiguration
implements IMutableDefinitionBindingConfiguration {
    @Nullable
    private String className;
    @Nullable
    private String baseClassName;
    @NonNull
    private final Set<String> interfacesToImplement = new HashSet<String>();

    public DefaultDefinitionBindingConfiguration() {
    }

    public DefaultDefinitionBindingConfiguration(@NonNull IDefinitionBindingConfiguration config) {
        this.className = config.getClassName();
        this.baseClassName = config.getQualifiedBaseClassName();
        this.interfacesToImplement.addAll(config.getInterfacesToImplement());
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String name) {
        this.className = name;
    }

    @Override
    public String getQualifiedBaseClassName() {
        return this.baseClassName;
    }

    @Override
    public void setQualifiedBaseClassName(String name) {
        this.baseClassName = name;
    }

    @Override
    public Collection<String> getInterfacesToImplement() {
        return this.interfacesToImplement.isEmpty() ? CollectionUtil.emptySet() : CollectionUtil.unmodifiableCollection(this.interfacesToImplement);
    }

    @Override
    public void addInterfaceToImplement(String interfaceName) {
        this.interfacesToImplement.add(interfaceName);
    }
}

