/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.ConstraintLoader;
import gov.nist.secauto.metaschema.model.common.MetaschemaException;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLoader<T> {
    private static final Logger LOGGER = LogManager.getLogger(ConstraintLoader.class);
    @NonNull
    private final Map<URI, T> cache = new LinkedHashMap<URI, T>();

    @NonNull
    public Collection<T> getLoadedResources() {
        return CollectionUtil.unmodifiableCollection((Collection)((Collection)ObjectUtils.notNull(this.cache.values())));
    }

    @NonNull
    protected Map<URI, T> getCachedEntries() {
        return CollectionUtil.unmodifiableMap(this.cache);
    }

    @NonNull
    public T load(@NonNull URI resource) throws MetaschemaException, IOException {
        if (!resource.isAbsolute()) {
            throw new IllegalArgumentException(String.format("The URI '%s' must be absolute.", resource.toString()));
        }
        return this.loadInternal(resource, new LinkedList<URI>());
    }

    @NonNull
    public T load(@NonNull Path path) throws MetaschemaException, IOException {
        return this.loadInternal((URI)ObjectUtils.notNull((Object)path.toUri()), new LinkedList<URI>());
    }

    @NonNull
    public T load(@NonNull File file) throws MetaschemaException, IOException {
        return this.loadInternal((URI)ObjectUtils.notNull((Object)file.toURI()), new LinkedList<URI>());
    }

    @NonNull
    public T load(@NonNull URL url) throws MetaschemaException, IOException {
        try {
            URI resource = url.toURI();
            return this.loadInternal((URI)ObjectUtils.notNull((Object)resource), new LinkedList<URI>());
        }
        catch (URISyntaxException ex) {
            LOGGER.error("Invalid url", (Throwable)ex);
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected T loadInternal(@NonNull URI resource, @NonNull Deque<URI> visitedResources) throws MetaschemaException, MalformedURLException, IOException {
        if (visitedResources.contains(resource)) {
            throw new MetaschemaException("Cycle detected in metaschema includes for '" + resource + "'. Call stack: '" + visitedResources.stream().map(n -> n.toString()).collect(Collectors.joining(",")));
        }
        T retval = this.cache.get(resource);
        if (retval == null) {
            LOGGER.info("Loading metaschema '{}'", (Object)resource);
            try {
                visitedResources.push(resource);
                retval = this.parseResource(resource, visitedResources);
            }
            finally {
                visitedResources.pop();
            }
            this.cache.put(resource, retval);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found metaschema in cache '{}'", (Object)resource);
        }
        return (T)ObjectUtils.notNull(retval);
    }

    protected abstract T parseResource(@NonNull URI var1, @NonNull Deque<URI> var2) throws IOException;
}

