/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.MarkupStringConverter;
import gov.nist.secauto.metaschema.model.ModelFactory;
import gov.nist.secauto.metaschema.model.XmlbeansMarkupVisitor;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValue;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IAssemblyConstraintSupport;
import gov.nist.secauto.metaschema.model.common.constraint.ICardinalityConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraintVisitor;
import gov.nist.secauto.metaschema.model.common.constraint.IExpectConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IIndexConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IKeyConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IKeyField;
import gov.nist.secauto.metaschema.model.common.constraint.IMatchesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IUniqueConstraint;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.metapath.MetapathException;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.xmlbeans.ConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.DefineAssemblyConstraintsType;
import gov.nist.secauto.metaschema.model.xmlbeans.EnumType;
import gov.nist.secauto.metaschema.model.xmlbeans.GlobalAssemblyDefinitionType;
import gov.nist.secauto.metaschema.model.xmlbeans.HasCardinalityConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.KeyConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.PropertyType;
import gov.nist.secauto.metaschema.model.xmlbeans.RemarksType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedAllowedValuesType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedExpectConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedIndexConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedIndexHasKeyConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedKeyConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedMatchesConstraintType;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.values.XmlValueNotSupportedException;

class AssemblyConstraintSupport
implements IAssemblyConstraintSupport {
    @NonNull
    private static final String PATH = "declare namespace m='http://csrc.nist.gov/ns/oscal/metaschema/1.0';$this/m:allowed-values|$this/m:index|$this/m:index-has-key|$this/m:is-unique|$this/m:has-cardinality|$this/m:matches|$this/m:expect";
    @NonNull
    private final List<IConstraint> constraints = new LinkedList<IConstraint>();
    @NonNull
    private final List<IAllowedValuesConstraint> allowedValuesConstraints = new LinkedList<IAllowedValuesConstraint>();
    @NonNull
    private final List<IMatchesConstraint> matchesConstraints = new LinkedList<IMatchesConstraint>();
    @NonNull
    private final List<IIndexHasKeyConstraint> indexHasKeyConstraints = new LinkedList<IIndexHasKeyConstraint>();
    @NonNull
    private final List<IExpectConstraint> expectConstraints = new LinkedList<IExpectConstraint>();
    @NonNull
    private final List<IIndexConstraint> indexConstraints = new LinkedList<IIndexConstraint>();
    @NonNull
    private final List<IUniqueConstraint> uniqueConstraints = new LinkedList<IUniqueConstraint>();
    @NonNull
    private final List<ICardinalityConstraint> cardinalityConstraints = new LinkedList<ICardinalityConstraint>();

    public static AssemblyConstraintSupport newInstance(@NonNull GlobalAssemblyDefinitionType definition, @NonNull IConstraint.ISource source) {
        AssemblyConstraintSupport retval = definition.isSetConstraint() ? new AssemblyConstraintSupport((DefineAssemblyConstraintsType)ObjectUtils.notNull((Object)definition.getConstraint()), source) : new AssemblyConstraintSupport();
        return retval;
    }

    public AssemblyConstraintSupport() {
    }

    public AssemblyConstraintSupport(@NonNull DefineAssemblyConstraintsType xmlConstraints, @NonNull IConstraint.ISource source) {
        try (XmlCursor cursor = xmlConstraints.newCursor();){
            cursor.selectPath(PATH);
            while (cursor.toNextSelection()) {
                DefaultAllowedValuesConstraint constraint;
                XmlObject obj = cursor.getObject();
                if (obj instanceof ScopedAllowedValuesType) {
                    constraint = ModelFactory.newAllowedValuesConstraint((ScopedAllowedValuesType)obj, source);
                    this.addConstraint((IAllowedValuesConstraint)constraint);
                    continue;
                }
                if (obj instanceof ScopedIndexConstraintType) {
                    constraint = ModelFactory.newIndexConstraint((ScopedIndexConstraintType)obj, source);
                    this.addConstraint((IIndexConstraint)constraint);
                    continue;
                }
                if (obj instanceof ScopedIndexHasKeyConstraintType) {
                    constraint = ModelFactory.newIndexHasKeyConstraint((ScopedIndexHasKeyConstraintType)obj, source);
                    this.addConstraint((IIndexHasKeyConstraint)constraint);
                    continue;
                }
                if (obj instanceof ScopedKeyConstraintType) {
                    constraint = ModelFactory.newUniqueConstraint((ScopedKeyConstraintType)obj, source);
                    this.addConstraint((IUniqueConstraint)constraint);
                    continue;
                }
                if (obj instanceof HasCardinalityConstraintType) {
                    constraint = ModelFactory.newCardinalityConstraint((HasCardinalityConstraintType)obj, source);
                    this.addConstraint((ICardinalityConstraint)constraint);
                    continue;
                }
                if (obj instanceof ScopedMatchesConstraintType) {
                    constraint = ModelFactory.newMatchesConstraint((ScopedMatchesConstraintType)obj, source);
                    this.addConstraint((IMatchesConstraint)constraint);
                    continue;
                }
                if (!(obj instanceof ScopedExpectConstraintType)) continue;
                constraint = ModelFactory.newExpectConstraint((ScopedExpectConstraintType)obj, source);
                this.addConstraint((IExpectConstraint)constraint);
            }
        }
        catch (MetapathException | XmlValueNotSupportedException ex) {
            if (ex.getCause() instanceof MetapathException) {
                throw new MetapathException(String.format("Unable to compile a Metapath in '%s'. %s", source.getSource(), ex.getLocalizedMessage()), ex);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IConstraint> getConstraints() {
        AssemblyConstraintSupport assemblyConstraintSupport = this;
        synchronized (assemblyConstraintSupport) {
            return this.constraints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IAllowedValuesConstraint> getAllowedValuesConstraints() {
        AssemblyConstraintSupport assemblyConstraintSupport = this;
        synchronized (assemblyConstraintSupport) {
            return this.allowedValuesConstraints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMatchesConstraint> getMatchesConstraints() {
        AssemblyConstraintSupport assemblyConstraintSupport = this;
        synchronized (assemblyConstraintSupport) {
            return this.matchesConstraints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IIndexHasKeyConstraint> getIndexHasKeyConstraints() {
        AssemblyConstraintSupport assemblyConstraintSupport = this;
        synchronized (assemblyConstraintSupport) {
            return this.indexHasKeyConstraints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IExpectConstraint> getExpectConstraints() {
        AssemblyConstraintSupport assemblyConstraintSupport = this;
        synchronized (assemblyConstraintSupport) {
            return this.expectConstraints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IIndexConstraint> getIndexConstraints() {
        AssemblyConstraintSupport assemblyConstraintSupport = this;
        synchronized (assemblyConstraintSupport) {
            return this.indexConstraints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IUniqueConstraint> getUniqueConstraints() {
        AssemblyConstraintSupport assemblyConstraintSupport = this;
        synchronized (assemblyConstraintSupport) {
            return this.uniqueConstraints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICardinalityConstraint> getHasCardinalityConstraints() {
        AssemblyConstraintSupport assemblyConstraintSupport = this;
        synchronized (assemblyConstraintSupport) {
            return this.cardinalityConstraints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConstraint(@NonNull IAllowedValuesConstraint constraint) {
        AssemblyConstraintSupport assemblyConstraintSupport = this;
        synchronized (assemblyConstraintSupport) {
            this.constraints.add((IConstraint)constraint);
            this.allowedValuesConstraints.add(constraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConstraint(@NonNull IMatchesConstraint constraint) {
        AssemblyConstraintSupport assemblyConstraintSupport = this;
        synchronized (assemblyConstraintSupport) {
            this.constraints.add((IConstraint)constraint);
            this.matchesConstraints.add(constraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConstraint(@NonNull IIndexHasKeyConstraint constraint) {
        AssemblyConstraintSupport assemblyConstraintSupport = this;
        synchronized (assemblyConstraintSupport) {
            this.constraints.add((IConstraint)constraint);
            this.indexHasKeyConstraints.add(constraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConstraint(@NonNull IExpectConstraint constraint) {
        AssemblyConstraintSupport assemblyConstraintSupport = this;
        synchronized (assemblyConstraintSupport) {
            this.constraints.add((IConstraint)constraint);
            this.expectConstraints.add(constraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConstraint(@NonNull IIndexConstraint constraint) {
        AssemblyConstraintSupport assemblyConstraintSupport = this;
        synchronized (assemblyConstraintSupport) {
            this.constraints.add((IConstraint)constraint);
            this.indexConstraints.add(constraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConstraint(@NonNull IUniqueConstraint constraint) {
        AssemblyConstraintSupport assemblyConstraintSupport = this;
        synchronized (assemblyConstraintSupport) {
            this.constraints.add((IConstraint)constraint);
            this.uniqueConstraints.add(constraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConstraint(@NonNull ICardinalityConstraint constraint) {
        AssemblyConstraintSupport assemblyConstraintSupport = this;
        synchronized (assemblyConstraintSupport) {
            this.constraints.add((IConstraint)constraint);
            this.cardinalityConstraints.add(constraint);
        }
    }

    public final DefineAssemblyConstraintsType generate() {
        DefineAssemblyConstraintsType retval = (DefineAssemblyConstraintsType)DefineAssemblyConstraintsType.Factory.newInstance();
        XmlbeanGeneratingVisitor visitor = new XmlbeanGeneratingVisitor();
        for (IConstraint constraint : this.getConstraints()) {
            constraint.accept((IConstraintVisitor)visitor, (Object)retval);
        }
        return retval;
    }

    private static final class XmlbeanGeneratingVisitor
    implements IConstraintVisitor<DefineAssemblyConstraintsType, Void> {
        private XmlbeanGeneratingVisitor() {
        }

        private static void applyCommonValues(@NonNull IConstraint constraint, @NonNull ConstraintType bean) {
            IConstraint.Level level;
            String id;
            String formalName;
            MarkupLine description = constraint.getDescription();
            if (description != null) {
                bean.setDescription(MarkupStringConverter.toMarkupLineDatatype(description));
            }
            if ((formalName = constraint.getFormalName()) != null) {
                bean.setFormalName(formalName);
            }
            if ((id = constraint.getId()) != null) {
                bean.setId(constraint.getId());
            }
            if (!IConstraint.DEFAULT_LEVEL.equals((Object)(level = constraint.getLevel()))) {
                bean.setLevel(level);
            }
            for (Map.Entry entry : constraint.getProperties().entrySet()) {
                QName qname = (QName)entry.getKey();
                Set values = (Set)entry.getValue();
                for (String value : values) {
                    PropertyType prop = bean.addNewProp();
                    prop.setName(qname.getLocalPart());
                    String namespace = qname.getNamespaceURI();
                    if (namespace != null && !namespace.isEmpty()) {
                        prop.setNamespace(namespace);
                    }
                    prop.setValue(value);
                }
            }
        }

        public Void visitAllowedValues(IAllowedValuesConstraint constraint, DefineAssemblyConstraintsType state) {
            ScopedAllowedValuesType bean = state.addNewAllowedValues();
            assert (bean != null);
            XmlbeanGeneratingVisitor.applyCommonValues((IConstraint)constraint, bean);
            if (Boolean.compare(false, constraint.isAllowedOther()) != 0) {
                bean.setAllowOther(constraint.isAllowedOther());
            }
            bean.setTarget(constraint.getTarget());
            bean.setExtensible(constraint.getExtensible());
            for (Map.Entry entry : constraint.getAllowedValues().entrySet()) {
                String value = (String)entry.getKey();
                IAllowedValue allowedValue = (IAllowedValue)entry.getValue();
                assert (value.equals(allowedValue.getValue()));
                MarkupLine description = allowedValue.getDescription();
                EnumType enumType = bean.addNewEnum();
                enumType.setValue(value);
                XmlbeansMarkupVisitor.visit(description, "http://csrc.nist.gov/ns/oscal/metaschema/1.0", enumType);
            }
            MarkupMultiline remarks = constraint.getRemarks();
            if (remarks != null) {
                RemarksType remarksType = bean.addNewRemarks();
                assert (remarksType != null);
                XmlbeansMarkupVisitor.visit(remarks, "http://csrc.nist.gov/ns/oscal/metaschema/1.0", remarksType);
            }
            return null;
        }

        public Void visitCardinalityConstraint(ICardinalityConstraint constraint, DefineAssemblyConstraintsType state) {
            MarkupMultiline remarks;
            Integer maxOccurs;
            HasCardinalityConstraintType bean = state.addNewHasCardinality();
            assert (bean != null);
            XmlbeanGeneratingVisitor.applyCommonValues((IConstraint)constraint, bean);
            Integer minOccurs = constraint.getMinOccurs();
            if (minOccurs != null) {
                bean.setMinOccurs(BigInteger.valueOf(minOccurs.intValue()));
            }
            if ((maxOccurs = constraint.getMaxOccurs()) != null) {
                bean.setMaxOccurs(BigInteger.valueOf(maxOccurs.intValue()));
            }
            if ((remarks = constraint.getRemarks()) != null) {
                RemarksType remarksType = bean.addNewRemarks();
                assert (remarksType != null);
                XmlbeansMarkupVisitor.visit(remarks, "http://csrc.nist.gov/ns/oscal/metaschema/1.0", remarksType);
            }
            return null;
        }

        public Void visitExpectConstraint(IExpectConstraint constraint, DefineAssemblyConstraintsType state) {
            MarkupMultiline remarks;
            ScopedExpectConstraintType bean = state.addNewExpect();
            assert (bean != null);
            XmlbeanGeneratingVisitor.applyCommonValues((IConstraint)constraint, bean);
            bean.setTest(constraint.getTest());
            String message = constraint.getMessage();
            if (message != null) {
                bean.setMessage(message);
            }
            if ((remarks = constraint.getRemarks()) != null) {
                RemarksType remarksType = bean.addNewRemarks();
                assert (remarksType != null);
                XmlbeansMarkupVisitor.visit(remarks, "http://csrc.nist.gov/ns/oscal/metaschema/1.0", remarksType);
            }
            return null;
        }

        public Void visitMatchesConstraint(IMatchesConstraint constraint, DefineAssemblyConstraintsType state) {
            MarkupMultiline remarks;
            IDataTypeAdapter dataType;
            ScopedMatchesConstraintType bean = state.addNewMatches();
            assert (bean != null);
            XmlbeanGeneratingVisitor.applyCommonValues((IConstraint)constraint, bean);
            Pattern pattern = constraint.getPattern();
            if (pattern != null) {
                bean.setRegex(pattern);
            }
            if ((dataType = constraint.getDataType()) != null) {
                bean.setDatatype(dataType);
            }
            if ((remarks = constraint.getRemarks()) != null) {
                RemarksType remarksType = bean.addNewRemarks();
                assert (remarksType != null);
                XmlbeansMarkupVisitor.visit(remarks, "http://csrc.nist.gov/ns/oscal/metaschema/1.0", remarksType);
            }
            return null;
        }

        private static void applyKeyFields(@NonNull IKeyConstraint constraint, @NonNull KeyConstraintType bean) {
            for (IKeyField keyField : constraint.getKeyFields()) {
                KeyConstraintType.KeyField keyFieldBean = bean.addNewKeyField();
                assert (keyField != null);
                assert (keyFieldBean != null);
                XmlbeanGeneratingVisitor.applyKeyField(keyField, keyFieldBean);
            }
        }

        private static void applyKeyField(@NonNull IKeyField keyField, @NonNull KeyConstraintType.KeyField bean) {
            Pattern pattern = keyField.getPattern();
            if (pattern != null) {
                bean.setPattern(pattern);
            }
            bean.setTarget(keyField.getTarget());
            MarkupMultiline remarks = keyField.getRemarks();
            if (remarks != null) {
                RemarksType remarksType = bean.addNewRemarks();
                assert (remarksType != null);
                XmlbeansMarkupVisitor.visit(remarks, "http://csrc.nist.gov/ns/oscal/metaschema/1.0", remarksType);
            }
        }

        public Void visitIndexConstraint(IIndexConstraint constraint, DefineAssemblyConstraintsType state) {
            ScopedIndexConstraintType bean = state.addNewIndex();
            assert (bean != null);
            XmlbeanGeneratingVisitor.applyCommonValues((IConstraint)constraint, bean);
            XmlbeanGeneratingVisitor.applyKeyFields((IKeyConstraint)constraint, bean);
            bean.setName(constraint.getName());
            MarkupMultiline remarks = constraint.getRemarks();
            if (remarks != null) {
                RemarksType remarksType = bean.addNewRemarks();
                assert (remarksType != null);
                XmlbeansMarkupVisitor.visit(remarks, "http://csrc.nist.gov/ns/oscal/metaschema/1.0", remarksType);
            }
            return null;
        }

        public Void visitIndexHasKeyConstraint(IIndexHasKeyConstraint constraint, DefineAssemblyConstraintsType state) {
            ScopedIndexHasKeyConstraintType bean = state.addNewIndexHasKey();
            assert (bean != null);
            XmlbeanGeneratingVisitor.applyCommonValues((IConstraint)constraint, bean);
            XmlbeanGeneratingVisitor.applyKeyFields((IKeyConstraint)constraint, bean);
            bean.setName(constraint.getIndexName());
            MarkupMultiline remarks = constraint.getRemarks();
            if (remarks != null) {
                RemarksType remarksType = bean.addNewRemarks();
                assert (remarksType != null);
                XmlbeansMarkupVisitor.visit(remarks, "http://csrc.nist.gov/ns/oscal/metaschema/1.0", remarksType);
            }
            return null;
        }

        public Void visitUniqueConstraint(IUniqueConstraint constraint, DefineAssemblyConstraintsType state) {
            ScopedIndexHasKeyConstraintType bean = state.addNewIndexHasKey();
            assert (bean != null);
            XmlbeanGeneratingVisitor.applyCommonValues((IConstraint)constraint, bean);
            XmlbeanGeneratingVisitor.applyKeyFields((IKeyConstraint)constraint, bean);
            MarkupMultiline remarks = constraint.getRemarks();
            if (remarks != null) {
                RemarksType remarksType = bean.addNewRemarks();
                assert (remarksType != null);
                XmlbeansMarkupVisitor.visit(remarks, "http://csrc.nist.gov/ns/oscal/metaschema/1.0", remarksType);
            }
            return null;
        }
    }
}

