/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.AssemblyConstraintSupport;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.constraint.AbstractTargetedConstraints;
import gov.nist.secauto.metaschema.model.common.constraint.IAssemblyConstraintSupport;
import gov.nist.secauto.metaschema.model.common.constraint.ICardinalityConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IIndexConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IUniqueConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IValueConstraintSupport;
import gov.nist.secauto.metaschema.model.common.metapath.MetapathExpression;
import java.util.List;

class AssemblyTargetedConstraints
extends AbstractTargetedConstraints<AssemblyConstraintSupport>
implements IAssemblyConstraintSupport {
    public AssemblyTargetedConstraints(@NonNull MetapathExpression targetExpression, @NonNull AssemblyConstraintSupport constraints) {
        super(targetExpression, (IValueConstraintSupport)constraints);
    }

    public List<? extends IIndexConstraint> getIndexConstraints() {
        return ((AssemblyConstraintSupport)this.getConstraintSupport()).getIndexConstraints();
    }

    public List<? extends IUniqueConstraint> getUniqueConstraints() {
        return ((AssemblyConstraintSupport)this.getConstraintSupport()).getUniqueConstraints();
    }

    public List<? extends ICardinalityConstraint> getHasCardinalityConstraints() {
        return ((AssemblyConstraintSupport)this.getConstraintSupport()).getHasCardinalityConstraints();
    }

    public void addConstraint(@NonNull IIndexConstraint constraint) {
        ((AssemblyConstraintSupport)this.getConstraintSupport()).addConstraint(constraint);
    }

    public void addConstraint(@NonNull IUniqueConstraint constraint) {
        ((AssemblyConstraintSupport)this.getConstraintSupport()).addConstraint(constraint);
    }

    public void addConstraint(@NonNull ICardinalityConstraint constraint) {
        ((AssemblyConstraintSupport)this.getConstraintSupport()).addConstraint(constraint);
    }

    public void target(@NonNull IAssemblyDefinition definition) {
        this.applyTo((IDefinition)definition);
        this.applyTo(definition);
    }

    protected void applyTo(@NonNull IAssemblyDefinition definition) {
        this.getIndexConstraints().forEach(constraint -> definition.addConstraint(constraint));
        this.getUniqueConstraints().forEach(constraint -> definition.addConstraint(constraint));
        this.getHasCardinalityConstraints().forEach(constraint -> definition.addConstraint(constraint));
    }
}

