/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.AbstractLoader;
import gov.nist.secauto.metaschema.model.AssemblyConstraintSupport;
import gov.nist.secauto.metaschema.model.AssemblyTargetedConstraints;
import gov.nist.secauto.metaschema.model.FieldTargetedConstraints;
import gov.nist.secauto.metaschema.model.FlagTargetedConstraints;
import gov.nist.secauto.metaschema.model.ValueConstraintSupport;
import gov.nist.secauto.metaschema.model.common.MetaschemaException;
import gov.nist.secauto.metaschema.model.common.constraint.AbstractTargetedConstraints;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultConstraintSet;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultScopedContraints;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraintSet;
import gov.nist.secauto.metaschema.model.common.constraint.IScopedContraints;
import gov.nist.secauto.metaschema.model.common.constraint.IValueConstraintSupport;
import gov.nist.secauto.metaschema.model.common.metapath.MetapathExpression;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.xmlbeans.METASCHEMACONSTRAINTSDocument;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedIndexHasKeyConstraintType;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class ConstraintLoader
extends AbstractLoader<IConstraintSet> {
    @Override
    protected IConstraintSet parseResource(@NonNull URI resource, @NonNull Deque<URI> visitedResources) throws IOException {
        LinkedHashMap<URI, IConstraintSet> importedMetaschema;
        METASCHEMACONSTRAINTSDocument xmlObject = this.parseConstraintSet(resource);
        int size = xmlObject.getMETASCHEMACONSTRAINTS().sizeOfImportArray();
        if (size == 0) {
            importedMetaschema = (LinkedHashMap<URI, IConstraintSet>)ObjectUtils.notNull(Collections.emptyMap());
        } else {
            try {
                importedMetaschema = new LinkedHashMap<URI, IConstraintSet>();
                for (METASCHEMACONSTRAINTSDocument.METASCHEMACONSTRAINTS.Import imported : xmlObject.getMETASCHEMACONSTRAINTS().getImportList()) {
                    URI importedResource = URI.create(imported.getHref());
                    importedResource = (URI)ObjectUtils.notNull((Object)resource.resolve(importedResource));
                    importedMetaschema.put(importedResource, (IConstraintSet)this.loadInternal(importedResource, visitedResources));
                }
            }
            catch (MetaschemaException ex) {
                throw new IOException(ex);
            }
        }
        Collection values = importedMetaschema.values();
        return new DefaultConstraintSet(resource, this.parseScopedConstraints(xmlObject, resource), new LinkedHashSet(values));
    }

    @NonNull
    protected METASCHEMACONSTRAINTSDocument parseConstraintSet(@NonNull URI resource) throws IOException {
        try {
            XmlOptions options = new XmlOptions();
            options.setBaseURI(resource);
            options.setLoadLineNumbers();
            return (METASCHEMACONSTRAINTSDocument)ObjectUtils.notNull((Object)((METASCHEMACONSTRAINTSDocument)METASCHEMACONSTRAINTSDocument.Factory.parse(resource.toURL(), options)));
        }
        catch (XmlException ex) {
            throw new IOException(ex);
        }
    }

    @NonNull
    protected List<IScopedContraints> parseScopedConstraints(@NonNull METASCHEMACONSTRAINTSDocument xmlObject, @NonNull URI source) {
        LinkedList<DefaultScopedContraints> scopedConstraints = new LinkedList<DefaultScopedContraints>();
        IConstraint.ISource constraintSource = IConstraint.ExternalSource.instance((URI)source);
        for (METASCHEMACONSTRAINTSDocument.METASCHEMACONSTRAINTS.Scope scope : xmlObject.getMETASCHEMACONSTRAINTS().getScopeList()) {
            URI namespace = (URI)ObjectUtils.notNull((Object)URI.create(scope.getMetaschemaNamespace()));
            String shortName = (String)ObjectUtils.requireNonNull((Object)scope.getMetaschemaShortName());
            XmlCursor cursor = scope.newCursor();
            try {
                cursor.selectPath("declare namespace m='http://csrc.nist.gov/ns/oscal/metaschema/1.0';$this/m:assembly|$this/m:field|$this/m:flag");
                LinkedList<AbstractTargetedConstraints> targetedConstraints = new LinkedList<AbstractTargetedConstraints>();
                while (cursor.toNextSelection()) {
                    Object constraints;
                    MetapathExpression expression;
                    XmlObject obj = cursor.getObject();
                    if (obj instanceof METASCHEMACONSTRAINTSDocument.METASCHEMACONSTRAINTS.Scope.Assembly) {
                        METASCHEMACONSTRAINTSDocument.METASCHEMACONSTRAINTS.Scope.Assembly assembly = (METASCHEMACONSTRAINTSDocument.METASCHEMACONSTRAINTS.Scope.Assembly)obj;
                        expression = (MetapathExpression)ObjectUtils.requireNonNull((Object)assembly.getTarget());
                        constraints = new AssemblyConstraintSupport(assembly, constraintSource);
                        targetedConstraints.add(new AssemblyTargetedConstraints(expression, (AssemblyConstraintSupport)constraints));
                        continue;
                    }
                    if (obj instanceof METASCHEMACONSTRAINTSDocument.METASCHEMACONSTRAINTS.Scope.Field) {
                        METASCHEMACONSTRAINTSDocument.METASCHEMACONSTRAINTS.Scope.Field field = (METASCHEMACONSTRAINTSDocument.METASCHEMACONSTRAINTS.Scope.Field)obj;
                        expression = (MetapathExpression)ObjectUtils.requireNonNull((Object)field.getTarget());
                        constraints = new ValueConstraintSupport(field, constraintSource);
                        targetedConstraints.add(new FieldTargetedConstraints(expression, (IValueConstraintSupport)constraints));
                        continue;
                    }
                    if (!(obj instanceof ScopedIndexHasKeyConstraintType)) continue;
                    METASCHEMACONSTRAINTSDocument.METASCHEMACONSTRAINTS.Scope.Flag flag = (METASCHEMACONSTRAINTSDocument.METASCHEMACONSTRAINTS.Scope.Flag)obj;
                    expression = (MetapathExpression)ObjectUtils.requireNonNull((Object)flag.getTarget());
                    constraints = new ValueConstraintSupport(flag, constraintSource);
                    targetedConstraints.add(new FlagTargetedConstraints(expression, (IValueConstraintSupport)constraints));
                }
                scopedConstraints.add(new DefaultScopedContraints(namespace, shortName, CollectionUtil.unmodifiableList(targetedConstraints)));
            }
            finally {
                if (cursor == null) continue;
                cursor.close();
            }
        }
        return CollectionUtil.unmodifiableList(scopedConstraints);
    }
}

