/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.XmlbeansMarkupVisitor;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.xmlbeans.MarkupLineDatatype;
import gov.nist.secauto.metaschema.model.xmlbeans.MarkupMultilineDatatype;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlTokenSource;

final class MarkupStringConverter {
    private MarkupStringConverter() {
    }

    @NonNull
    public static MarkupLine toMarkupString(@NonNull MarkupLineDatatype content) {
        String html = MarkupStringConverter.processHTML((XmlTokenSource)content);
        return MarkupLine.fromHtml((String)html);
    }

    @NonNull
    public static MarkupMultiline toMarkupString(@NonNull MarkupMultilineDatatype content) {
        String html = MarkupStringConverter.processHTML((XmlTokenSource)content);
        return MarkupMultiline.fromHtml((String)html);
    }

    @NonNull
    public static MarkupLineDatatype toMarkupLineDatatype(@NonNull MarkupLine markupLine) {
        MarkupLineDatatype retval = (MarkupLineDatatype)ObjectUtils.notNull((Object)((MarkupLineDatatype)MarkupLineDatatype.Factory.newInstance()));
        XmlbeansMarkupVisitor.visit(markupLine, "http://csrc.nist.gov/ns/oscal/metaschema/1.0", retval);
        return retval;
    }

    @NonNull
    private static String processHTML(XmlTokenSource content) {
        XmlOptions options = new XmlOptions();
        options.setSaveInner();
        options.setSaveUseOpenFrag();
        StringWriter writer = new StringWriter();
        try {
            content.save((Writer)writer, options);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return (String)ObjectUtils.notNull((Object)writer.toString().replaceFirst("^<frag\\:fragment[^>]+>", "").replaceFirst("</frag\\:fragment>$", ""));
    }
}

