/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.AbstractLoader;
import gov.nist.secauto.metaschema.model.XmlMetaschema;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.MetaschemaException;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraintSet;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.xmlbeans.METASCHEMADocument;
import gov.nist.secauto.metaschema.model.xmlbeans.MetaschemaImportType;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MetaschemaLoader
extends AbstractLoader<IMetaschema> {
    private boolean resolveEntities;
    @NonNull
    private final Set<IConstraintSet> registeredConstraintSets;

    public MetaschemaLoader() {
        this(CollectionUtil.emptySet());
    }

    public MetaschemaLoader(@NonNull Set<IConstraintSet> additionalConstraintSets) {
        this.registeredConstraintSets = CollectionUtil.unmodifiableSet(additionalConstraintSets);
    }

    @NonNull
    protected Set<IConstraintSet> getRegisteredConstraintSets() {
        return this.registeredConstraintSets;
    }

    public void allowEntityResolution() {
        this.resolveEntities = true;
    }

    protected IMetaschema newXmlMetaschema(@NonNull URI resource, @NonNull METASCHEMADocument xmlObject, @NonNull List<IMetaschema> importedMetaschemas) throws MetaschemaException {
        XmlMetaschema retval = new XmlMetaschema(resource, xmlObject, importedMetaschemas);
        IConstraintSet.applyConstraintSetToMetaschema(this.getRegisteredConstraintSets(), (IMetaschema)retval);
        return retval;
    }

    @Override
    protected IMetaschema parseResource(@NonNull URI resource, @NonNull Deque<URI> visitedResources) throws IOException {
        LinkedHashMap<URI, IMetaschema> importedMetaschema;
        METASCHEMADocument xmlObject = this.parseMetaschema(resource);
        int size = xmlObject.getMETASCHEMA().sizeOfImportArray();
        if (size == 0) {
            importedMetaschema = (LinkedHashMap<URI, IMetaschema>)ObjectUtils.notNull(Collections.emptyMap());
        } else {
            try {
                importedMetaschema = new LinkedHashMap<URI, IMetaschema>();
                for (MetaschemaImportType imported : xmlObject.getMETASCHEMA().getImportList()) {
                    URI importedResource = URI.create(imported.getHref());
                    importedResource = (URI)ObjectUtils.notNull((Object)resource.resolve(importedResource));
                    importedMetaschema.put(importedResource, (IMetaschema)this.loadInternal(importedResource, visitedResources));
                }
            }
            catch (MetaschemaException ex) {
                throw new IOException(ex);
            }
        }
        Collection values = importedMetaschema.values();
        try {
            return this.newXmlMetaschema(resource, xmlObject, new ArrayList<IMetaschema>(values));
        }
        catch (MetaschemaException ex) {
            throw new IOException(ex);
        }
    }

    protected METASCHEMADocument parseMetaschema(final @NonNull URI resource) throws IOException {
        METASCHEMADocument metaschemaXml;
        try {
            XmlOptions options = new XmlOptions();
            if (this.resolveEntities) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                try {
                    factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
                    factory.setFeature("http://xml.org/sax/features/external-general-entities", true);
                    factory.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
                    SAXParser parser = factory.newSAXParser();
                    parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "file");
                    XMLReader reader = parser.getXMLReader();
                    reader.setEntityResolver(new EntityResolver(){

                        @Override
                        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                            return null;
                        }
                    });
                    options.setLoadUseXMLReader(reader);
                }
                catch (ParserConfigurationException | SAXException ex) {
                    throw new IOException(ex);
                }
                options.setEntityResolver(new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        String effectiveSystemId = systemId;
                        if (effectiveSystemId.startsWith("file://file://")) {
                            effectiveSystemId = effectiveSystemId.substring(14);
                        }
                        URI resolvedSystemId = resource.resolve(effectiveSystemId);
                        return new InputSource(resolvedSystemId.toString());
                    }
                });
                options.setLoadDTDGrammar(true);
            }
            options.setBaseURI(resource);
            options.setLoadLineNumbers();
            metaschemaXml = (METASCHEMADocument)METASCHEMADocument.Factory.parse(resource.toURL(), options);
        }
        catch (XmlException ex) {
            throw new IOException(ex);
        }
        return metaschemaXml;
    }
}

