/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.model.MarkupStringConverter;
import gov.nist.secauto.metaschema.model.common.constraint.AbstractConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.AbstractKeyConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultAllowedValue;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultCardinalityConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultExpectConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultIndexConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultKeyField;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultMatchesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultUniqueConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.metapath.MetapathExpression;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.xmlbeans.AllowedValuesType;
import gov.nist.secauto.metaschema.model.xmlbeans.ConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.EnumType;
import gov.nist.secauto.metaschema.model.xmlbeans.ExpectConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.HasCardinalityConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.IndexHasKeyConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.KeyConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.MatchesConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.PropertyType;
import gov.nist.secauto.metaschema.model.xmlbeans.RemarksType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedAllowedValuesType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedExpectConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedIndexConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedIndexHasKeyConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedKeyConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedMatchesConstraintType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;

final class ModelFactory {
    private ModelFactory() {
    }

    @NonNull
    private static MetapathExpression target(@Nullable MetapathExpression target) {
        return target == null ? IConstraint.DEFAULT_TARGET : target;
    }

    @NonNull
    private static IConstraint.Level level(@Nullable IConstraint.Level level) {
        return level == null ? IConstraint.DEFAULT_LEVEL : level;
    }

    @NonNull
    private static MarkupMultiline remarks(@NonNull RemarksType remarks) {
        return MarkupStringConverter.toMarkupString(remarks);
    }

    @NonNull
    static Map<QName, Set<String>> toProperties(@NonNull List<PropertyType> properties) {
        return properties.stream().map(prop -> {
            String name = prop.getName();
            String namespace = prop.isSetNamespace() ? prop.getNamespace() : "http://csrc.nist.gov/ns/oscal/metaschema/1.0";
            QName qname = new QName(namespace, name);
            String value = prop.getValue();
            return Map.entry(qname, value);
        }).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toSet())));
    }

    @NonNull
    static Map<String, DefaultAllowedValue> toAllowedValues(@NonNull AllowedValuesType xmlConstraint) {
        LinkedHashMap<String, DefaultAllowedValue> allowedValues = new LinkedHashMap<String, DefaultAllowedValue>(xmlConstraint.sizeOfEnumArray());
        for (EnumType xmlEnum : xmlConstraint.getEnumList()) {
            DefaultAllowedValue allowedValue = new DefaultAllowedValue(xmlEnum.getValue(), MarkupStringConverter.toMarkupString(xmlEnum));
            allowedValues.put(allowedValue.getValue(), allowedValue);
        }
        return CollectionUtil.unmodifiableMap(allowedValues);
    }

    @NonNull
    static DefaultAllowedValuesConstraint newAllowedValuesConstraint(@NonNull ScopedAllowedValuesType xmlConstraint, @NonNull IConstraint.ISource source) {
        return ModelFactory.newAllowedValuesConstraint(xmlConstraint, ModelFactory.target(xmlConstraint.getTarget()), source);
    }

    @NonNull
    static DefaultAllowedValuesConstraint newAllowedValuesConstraint(@NonNull AllowedValuesType xmlConstraint, @NonNull IConstraint.ISource source) {
        return ModelFactory.newAllowedValuesConstraint(xmlConstraint, MetapathExpression.CONTEXT_NODE, source);
    }

    @NonNull
    static DefaultAllowedValuesConstraint newAllowedValuesConstraint(@NonNull AllowedValuesType xmlConstraint, @NonNull MetapathExpression target, @NonNull IConstraint.ISource source) {
        DefaultAllowedValuesConstraint.Builder builder = DefaultAllowedValuesConstraint.builder();
        ModelFactory.applyToBuilder(xmlConstraint, target, source, builder);
        if (xmlConstraint.isSetRemarks()) {
            builder.remarks(ModelFactory.remarks((RemarksType)ObjectUtils.notNull((Object)xmlConstraint.getRemarks())));
        }
        builder.allowedValues(ModelFactory.toAllowedValues(xmlConstraint));
        if (xmlConstraint.isSetAllowOther()) {
            builder.allowedOther(xmlConstraint.getAllowOther().booleanValue());
        }
        if (xmlConstraint.isSetExtensible()) {
            builder.extensible((IAllowedValuesConstraint.Extensible)ObjectUtils.notNull((Object)xmlConstraint.getExtensible()));
        }
        return (DefaultAllowedValuesConstraint)builder.build();
    }

    @NonNull
    private static <T extends AbstractConstraint.AbstractConstraintBuilder<T, ?>> T applyToBuilder(@NonNull ConstraintType xmlConstraint, @NonNull MetapathExpression target, @NonNull IConstraint.ISource source, @NonNull T builder) {
        if (xmlConstraint.isSetId()) {
            builder.identifier((String)ObjectUtils.notNull((Object)xmlConstraint.getId()));
        }
        builder.target(target);
        builder.source(source);
        builder.level(ModelFactory.level(xmlConstraint.getLevel()));
        return builder;
    }

    @NonNull
    static DefaultMatchesConstraint newMatchesConstraint(@NonNull ScopedMatchesConstraintType xmlConstraint, @NonNull IConstraint.ISource source) {
        return ModelFactory.newMatchesConstraint(xmlConstraint, ModelFactory.target(xmlConstraint.getTarget()), source);
    }

    @NonNull
    static DefaultMatchesConstraint newMatchesConstraint(@NonNull MatchesConstraintType xmlConstraint, @NonNull IConstraint.ISource source) {
        return ModelFactory.newMatchesConstraint(xmlConstraint, MetapathExpression.CONTEXT_NODE, source);
    }

    @NonNull
    static DefaultMatchesConstraint newMatchesConstraint(@NonNull MatchesConstraintType xmlConstraint, @NonNull MetapathExpression target, @NonNull IConstraint.ISource source) {
        DefaultMatchesConstraint.Builder builder = DefaultMatchesConstraint.builder();
        ModelFactory.applyToBuilder(xmlConstraint, target, source, builder);
        if (xmlConstraint.isSetRemarks()) {
            builder.remarks(ModelFactory.remarks((RemarksType)ObjectUtils.notNull((Object)xmlConstraint.getRemarks())));
        }
        if (xmlConstraint.isSetRegex()) {
            builder.regex((Pattern)ObjectUtils.notNull((Object)xmlConstraint.getRegex()));
        }
        if (xmlConstraint.isSetDatatype()) {
            builder.datatype((IDataTypeAdapter)ObjectUtils.notNull((Object)xmlConstraint.getDatatype()));
        }
        return (DefaultMatchesConstraint)builder.build();
    }

    static void buildKeyFields(@NonNull KeyConstraintType xmlConstraint, @NonNull AbstractKeyConstraint.AbstractKeyConstraintBuilder<?, ?> builder) {
        for (KeyConstraintType.KeyField xmlKeyField : xmlConstraint.getKeyFieldList()) {
            DefaultKeyField keyField = new DefaultKeyField(xmlKeyField.getTarget(), xmlKeyField.isSetPattern() ? xmlKeyField.getPattern() : null, xmlKeyField.isSetRemarks() ? ModelFactory.remarks(xmlKeyField.getRemarks()) : null);
            builder.keyField(keyField);
        }
    }

    @NonNull
    static DefaultUniqueConstraint newUniqueConstraint(@NonNull ScopedKeyConstraintType xmlConstraint, @NonNull IConstraint.ISource source) {
        DefaultUniqueConstraint.Builder builder = DefaultUniqueConstraint.builder();
        ModelFactory.applyToBuilder(xmlConstraint, ModelFactory.target(xmlConstraint.getTarget()), source, builder);
        if (xmlConstraint.isSetRemarks()) {
            builder.remarks(ModelFactory.remarks((RemarksType)ObjectUtils.notNull((Object)xmlConstraint.getRemarks())));
        }
        ModelFactory.buildKeyFields(xmlConstraint, builder);
        return (DefaultUniqueConstraint)builder.build();
    }

    @NonNull
    static DefaultIndexConstraint newIndexConstraint(@NonNull ScopedIndexConstraintType xmlConstraint, @NonNull IConstraint.ISource source) {
        DefaultIndexConstraint.Builder builder = DefaultIndexConstraint.builder();
        ModelFactory.applyToBuilder(xmlConstraint, ModelFactory.target(xmlConstraint.getTarget()), source, builder);
        if (xmlConstraint.isSetRemarks()) {
            builder.remarks(ModelFactory.remarks((RemarksType)ObjectUtils.notNull((Object)xmlConstraint.getRemarks())));
        }
        builder.name((String)ObjectUtils.requireNonNull((Object)xmlConstraint.getName()));
        ModelFactory.buildKeyFields(xmlConstraint, builder);
        return (DefaultIndexConstraint)builder.build();
    }

    @NonNull
    static DefaultIndexHasKeyConstraint newIndexHasKeyConstraint(@NonNull ScopedIndexHasKeyConstraintType xmlConstraint, @NonNull IConstraint.ISource source) {
        return ModelFactory.newIndexHasKeyConstraint(xmlConstraint, ModelFactory.target(xmlConstraint.getTarget()), source);
    }

    @NonNull
    static DefaultIndexHasKeyConstraint newIndexHasKeyConstraint(@NonNull IndexHasKeyConstraintType xmlConstraint, @NonNull IConstraint.ISource source) {
        return ModelFactory.newIndexHasKeyConstraint(xmlConstraint, MetapathExpression.CONTEXT_NODE, source);
    }

    @NonNull
    static DefaultIndexHasKeyConstraint newIndexHasKeyConstraint(@NonNull IndexHasKeyConstraintType xmlConstraint, @NonNull MetapathExpression target, @NonNull IConstraint.ISource source) {
        DefaultIndexHasKeyConstraint.Builder builder = DefaultIndexHasKeyConstraint.builder();
        ModelFactory.applyToBuilder(xmlConstraint, target, source, builder);
        if (xmlConstraint.isSetRemarks()) {
            builder.remarks(ModelFactory.remarks((RemarksType)ObjectUtils.notNull((Object)xmlConstraint.getRemarks())));
        }
        builder.name((String)ObjectUtils.requireNonNull((Object)xmlConstraint.getName()));
        ModelFactory.buildKeyFields(xmlConstraint, builder);
        return (DefaultIndexHasKeyConstraint)builder.build();
    }

    @NonNull
    static DefaultExpectConstraint newExpectConstraint(@NonNull ScopedExpectConstraintType xmlConstraint, @NonNull IConstraint.ISource source) {
        return ModelFactory.newExpectConstraint(xmlConstraint, ModelFactory.target(xmlConstraint.getTarget()), source);
    }

    @NonNull
    static DefaultExpectConstraint newExpectConstraint(@NonNull ExpectConstraintType xmlConstraint, @NonNull IConstraint.ISource source) {
        return ModelFactory.newExpectConstraint(xmlConstraint, MetapathExpression.CONTEXT_NODE, source);
    }

    @NonNull
    static DefaultExpectConstraint newExpectConstraint(@NonNull ExpectConstraintType xmlConstraint, @NonNull MetapathExpression target, @NonNull IConstraint.ISource source) {
        DefaultExpectConstraint.Builder builder = DefaultExpectConstraint.builder();
        ModelFactory.applyToBuilder(xmlConstraint, target, source, builder);
        if (xmlConstraint.isSetRemarks()) {
            builder.remarks(ModelFactory.remarks((RemarksType)ObjectUtils.notNull((Object)xmlConstraint.getRemarks())));
        }
        if (xmlConstraint.isSetMessage()) {
            builder.message((String)ObjectUtils.notNull((Object)xmlConstraint.getMessage()));
        }
        builder.test((MetapathExpression)ObjectUtils.requireNonNull((Object)xmlConstraint.getTest()));
        return (DefaultExpectConstraint)builder.build();
    }

    @NonNull
    static DefaultCardinalityConstraint newCardinalityConstraint(@NonNull HasCardinalityConstraintType xmlConstraint, @NonNull IConstraint.ISource source) {
        DefaultCardinalityConstraint.Builder builder = DefaultCardinalityConstraint.builder();
        ModelFactory.applyToBuilder(xmlConstraint, ModelFactory.target(xmlConstraint.getTarget()), source, builder);
        if (xmlConstraint.isSetRemarks()) {
            builder.remarks(ModelFactory.remarks((RemarksType)ObjectUtils.notNull((Object)xmlConstraint.getRemarks())));
        }
        if (xmlConstraint.isSetMinOccurs()) {
            builder.minOccurs(xmlConstraint.getMinOccurs().intValueExact());
        }
        if (xmlConstraint.isSetMaxOccurs()) {
            builder.maxOccurs(xmlConstraint.getMaxOccurs().intValueExact());
        }
        return (DefaultCardinalityConstraint)builder.build();
    }
}

