/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.ModelFactory;
import gov.nist.secauto.metaschema.model.common.constraint.DefaultAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IExpectConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IMatchesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IValueConstraintSupport;
import gov.nist.secauto.metaschema.model.common.metapath.MetapathException;
import gov.nist.secauto.metaschema.model.xmlbeans.AllowedValuesType;
import gov.nist.secauto.metaschema.model.xmlbeans.DefineFieldConstraintsType;
import gov.nist.secauto.metaschema.model.xmlbeans.DefineFlagConstraintsType;
import gov.nist.secauto.metaschema.model.xmlbeans.ExpectConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.IndexHasKeyConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.MatchesConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedAllowedValuesType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedExpectConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedIndexHasKeyConstraintType;
import gov.nist.secauto.metaschema.model.xmlbeans.ScopedMatchesConstraintType;
import java.util.LinkedList;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.values.XmlValueNotSupportedException;

class ValueConstraintSupport
implements IValueConstraintSupport {
    private static final String PATH = "declare namespace m='http://csrc.nist.gov/ns/oscal/metaschema/1.0';$this/m:allowed-values|$this/m:matches|$this/m:index-has-key|$this/m:expect";
    @NonNull
    private final List<IConstraint> constraints = new LinkedList<IConstraint>();
    @NonNull
    private final List<IAllowedValuesConstraint> allowedValuesConstraints = new LinkedList<IAllowedValuesConstraint>();
    @NonNull
    private final List<IMatchesConstraint> matchesConstraints = new LinkedList<IMatchesConstraint>();
    @NonNull
    private final List<IIndexHasKeyConstraint> indexHasKeyConstraints = new LinkedList<IIndexHasKeyConstraint>();
    @NonNull
    private final List<IExpectConstraint> expectConstraints = new LinkedList<IExpectConstraint>();

    public ValueConstraintSupport() {
    }

    public ValueConstraintSupport(@NonNull DefineFlagConstraintsType xmlConstraints, @NonNull IConstraint.ISource source) {
        try (XmlCursor cursor = xmlConstraints.newCursor();){
            cursor.selectPath(PATH);
            while (cursor.toNextSelection()) {
                DefaultAllowedValuesConstraint constraint;
                XmlObject obj = cursor.getObject();
                if (obj instanceof AllowedValuesType) {
                    constraint = ModelFactory.newAllowedValuesConstraint((AllowedValuesType)obj, source);
                    this.addConstraint((IAllowedValuesConstraint)constraint);
                    continue;
                }
                if (obj instanceof MatchesConstraintType) {
                    constraint = ModelFactory.newMatchesConstraint((MatchesConstraintType)obj, source);
                    this.addConstraint((IMatchesConstraint)constraint);
                    continue;
                }
                if (obj instanceof IndexHasKeyConstraintType) {
                    constraint = ModelFactory.newIndexHasKeyConstraint((IndexHasKeyConstraintType)obj, source);
                    this.addConstraint((IIndexHasKeyConstraint)constraint);
                    continue;
                }
                if (!(obj instanceof ExpectConstraintType)) continue;
                constraint = ModelFactory.newExpectConstraint((ExpectConstraintType)obj, source);
                this.addConstraint((IExpectConstraint)constraint);
            }
        }
        catch (MetapathException | XmlValueNotSupportedException ex) {
            if (ex.getCause() instanceof MetapathException) {
                throw new MetapathException(String.format("Unable to compile a Metapath in '%s'. %s", source.getSource(), ex.getLocalizedMessage()), ex);
            }
            throw ex;
        }
    }

    public ValueConstraintSupport(@NonNull DefineFieldConstraintsType xmlConstraints, @NonNull IConstraint.ISource source) {
        try (XmlCursor cursor = xmlConstraints.newCursor();){
            cursor.selectPath(PATH);
            while (cursor.toNextSelection()) {
                DefaultAllowedValuesConstraint constraint;
                XmlObject obj = cursor.getObject();
                if (obj instanceof ScopedAllowedValuesType) {
                    constraint = ModelFactory.newAllowedValuesConstraint((ScopedAllowedValuesType)obj, source);
                    this.addConstraint((IAllowedValuesConstraint)constraint);
                    continue;
                }
                if (obj instanceof ScopedMatchesConstraintType) {
                    constraint = ModelFactory.newMatchesConstraint((ScopedMatchesConstraintType)obj, source);
                    this.addConstraint((IMatchesConstraint)constraint);
                    continue;
                }
                if (obj instanceof ScopedIndexHasKeyConstraintType) {
                    constraint = ModelFactory.newIndexHasKeyConstraint((ScopedIndexHasKeyConstraintType)obj, source);
                    this.addConstraint((IIndexHasKeyConstraint)constraint);
                    continue;
                }
                if (!(obj instanceof ScopedExpectConstraintType)) continue;
                constraint = ModelFactory.newExpectConstraint((ScopedExpectConstraintType)obj, source);
                this.addConstraint((IExpectConstraint)constraint);
            }
        }
        catch (MetapathException | XmlValueNotSupportedException ex) {
            if (ex.getCause() instanceof MetapathException) {
                throw new MetapathException(String.format("Unable to compile a Metapath in '%s'. %s", source.getSource(), ex.getLocalizedMessage()), ex);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IConstraint> getConstraints() {
        ValueConstraintSupport valueConstraintSupport = this;
        synchronized (valueConstraintSupport) {
            return this.constraints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IAllowedValuesConstraint> getAllowedValuesConstraints() {
        ValueConstraintSupport valueConstraintSupport = this;
        synchronized (valueConstraintSupport) {
            return this.allowedValuesConstraints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMatchesConstraint> getMatchesConstraints() {
        ValueConstraintSupport valueConstraintSupport = this;
        synchronized (valueConstraintSupport) {
            return this.matchesConstraints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IIndexHasKeyConstraint> getIndexHasKeyConstraints() {
        ValueConstraintSupport valueConstraintSupport = this;
        synchronized (valueConstraintSupport) {
            return this.indexHasKeyConstraints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IExpectConstraint> getExpectConstraints() {
        ValueConstraintSupport valueConstraintSupport = this;
        synchronized (valueConstraintSupport) {
            return this.expectConstraints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConstraint(@NonNull IAllowedValuesConstraint constraint) {
        ValueConstraintSupport valueConstraintSupport = this;
        synchronized (valueConstraintSupport) {
            this.constraints.add((IConstraint)constraint);
            this.allowedValuesConstraints.add(constraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConstraint(@NonNull IMatchesConstraint constraint) {
        ValueConstraintSupport valueConstraintSupport = this;
        synchronized (valueConstraintSupport) {
            this.constraints.add((IConstraint)constraint);
            this.matchesConstraints.add(constraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConstraint(@NonNull IIndexHasKeyConstraint constraint) {
        ValueConstraintSupport valueConstraintSupport = this;
        synchronized (valueConstraintSupport) {
            this.constraints.add((IConstraint)constraint);
            this.indexHasKeyConstraints.add(constraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConstraint(@NonNull IExpectConstraint constraint) {
        ValueConstraintSupport valueConstraintSupport = this;
        synchronized (valueConstraintSupport) {
            this.constraints.add((IConstraint)constraint);
            this.expectConstraints.add(constraint);
        }
    }
}

