/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.MarkupStringConverter;
import gov.nist.secauto.metaschema.model.ModelFactory;
import gov.nist.secauto.metaschema.model.XmlModelParser;
import gov.nist.secauto.metaschema.model.common.AbstractAssemblyInstance;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IModelContainer;
import gov.nist.secauto.metaschema.model.common.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.XmlGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.xmlbeans.AssemblyReferenceType;
import gov.nist.secauto.metaschema.model.xmlbeans.MarkupLineDatatype;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

class XmlAssemblyInstance
extends AbstractAssemblyInstance {
    private final AssemblyReferenceType xmlAssembly;

    public XmlAssemblyInstance(@NonNull AssemblyReferenceType xmlAssembly, @NonNull IModelContainer parent) {
        super(parent);
        this.xmlAssembly = xmlAssembly;
    }

    protected AssemblyReferenceType getXmlAssembly() {
        return this.xmlAssembly;
    }

    public IAssemblyDefinition getDefinition() {
        return (IAssemblyDefinition)ObjectUtils.notNull((Object)this.getContainingMetaschema().getScopedAssemblyDefinitionByName(this.getName()));
    }

    public String getFormalName() {
        return this.getXmlAssembly().isSetFormalName() ? this.getXmlAssembly().getFormalName() : null;
    }

    public Map<QName, Set<String>> getProperties() {
        return ModelFactory.toProperties(CollectionUtil.listOrEmpty(this.getXmlAssembly().getPropList()));
    }

    public MarkupLine getDescription() {
        MarkupLine retval = null;
        if (this.getXmlAssembly().isSetDescription()) {
            MarkupLineDatatype description = this.getXmlAssembly().getDescription();
            assert (description != null);
            retval = MarkupStringConverter.toMarkupString(description);
        }
        return retval;
    }

    public String getName() {
        return this.getXmlAssembly().getRef();
    }

    public String getUseName() {
        return this.getXmlAssembly().isSetUseName() ? this.getXmlAssembly().getUseName() : null;
    }

    public String getGroupAsName() {
        return this.getXmlAssembly().isSetGroupAs() ? this.getXmlAssembly().getGroupAs().getName() : null;
    }

    public int getMinOccurs() {
        return XmlModelParser.getMinOccurs(this.getXmlAssembly().getMinOccurs());
    }

    public int getMaxOccurs() {
        return XmlModelParser.getMaxOccurs(this.getXmlAssembly().getMaxOccurs());
    }

    public JsonGroupAsBehavior getJsonGroupAsBehavior() {
        return XmlModelParser.getJsonGroupAsBehavior(this.getXmlAssembly().getGroupAs());
    }

    public XmlGroupAsBehavior getXmlGroupAsBehavior() {
        return XmlModelParser.getXmlGroupAsBehavior(this.getXmlAssembly().getGroupAs());
    }

    public MarkupMultiline getRemarks() {
        return this.getXmlAssembly().isSetRemarks() ? MarkupStringConverter.toMarkupString(this.getXmlAssembly().getRemarks()) : null;
    }

    public Object getValue(@NonNull Object parentInstance) {
        return null;
    }

    public Collection<?> getItemValues(Object instanceValue) {
        return Collections.emptyList();
    }
}

