/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.MarkupStringConverter;
import gov.nist.secauto.metaschema.model.ModelFactory;
import gov.nist.secauto.metaschema.model.XmlModelParser;
import gov.nist.secauto.metaschema.model.common.AbstractFieldInstance;
import gov.nist.secauto.metaschema.model.common.IFieldDefinition;
import gov.nist.secauto.metaschema.model.common.IModelContainer;
import gov.nist.secauto.metaschema.model.common.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.XmlGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.xmlbeans.FieldReferenceType;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

class XmlFieldInstance
extends AbstractFieldInstance {
    @NonNull
    private final FieldReferenceType xmlField;

    public XmlFieldInstance(@NonNull FieldReferenceType xmlField, @NonNull IModelContainer container) {
        super(container);
        this.xmlField = xmlField;
    }

    protected FieldReferenceType getXmlField() {
        return this.xmlField;
    }

    public IFieldDefinition getDefinition() {
        return (IFieldDefinition)ObjectUtils.notNull((Object)this.getContainingMetaschema().getScopedFieldDefinitionByName(this.getName()));
    }

    public boolean isInXmlWrapped() {
        boolean retval;
        if (this.getDefinition().getJavaTypeAdapter().isUnrappedValueAllowedInXml()) {
            retval = true;
            if (this.getXmlField().isSetInXml()) {
                retval = this.getXmlField().getInXml();
            }
        } else {
            retval = true;
        }
        return retval;
    }

    public String getFormalName() {
        return this.getXmlField().isSetFormalName() ? this.getXmlField().getFormalName() : null;
    }

    public MarkupLine getDescription() {
        return this.getXmlField().isSetDescription() ? MarkupStringConverter.toMarkupString(this.getXmlField().getDescription()) : null;
    }

    public Map<QName, Set<String>> getProperties() {
        return ModelFactory.toProperties(CollectionUtil.listOrEmpty(this.getXmlField().getPropList()));
    }

    public String getName() {
        return this.getXmlField().getRef();
    }

    public String getUseName() {
        return this.getXmlField().isSetUseName() ? this.getXmlField().getUseName() : null;
    }

    public String getXmlNamespace() {
        return this.getContainingDefinition().getContainingMetaschema().getXmlNamespace().toASCIIString();
    }

    public String getGroupAsName() {
        return this.getXmlField().isSetGroupAs() ? this.getXmlField().getGroupAs().getName() : null;
    }

    public String getGroupAsXmlNamespace() {
        return this.getContainingDefinition().getContainingMetaschema().getXmlNamespace().toASCIIString();
    }

    public int getMinOccurs() {
        return XmlModelParser.getMinOccurs(this.getXmlField().getMinOccurs());
    }

    public int getMaxOccurs() {
        return XmlModelParser.getMaxOccurs(this.getXmlField().getMaxOccurs());
    }

    public JsonGroupAsBehavior getJsonGroupAsBehavior() {
        return XmlModelParser.getJsonGroupAsBehavior(this.getXmlField().getGroupAs());
    }

    public XmlGroupAsBehavior getXmlGroupAsBehavior() {
        return XmlModelParser.getXmlGroupAsBehavior(this.getXmlField().getGroupAs());
    }

    public MarkupMultiline getRemarks() {
        return this.getXmlField().isSetRemarks() ? MarkupStringConverter.toMarkupString(this.getXmlField().getRemarks()) : null;
    }

    public Object getValue(@NonNull Object parentValue) {
        return null;
    }

    public Collection<?> getItemValues(Object instanceValue) {
        return Collections.emptyList();
    }
}

