/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.XmlFlagInstance;
import gov.nist.secauto.metaschema.model.XmlInlineFlagDefinition;
import gov.nist.secauto.metaschema.model.common.AbstractFlagInstance;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IFieldDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.xmlbeans.FlagReferenceType;
import gov.nist.secauto.metaschema.model.xmlbeans.GlobalAssemblyDefinitionType;
import gov.nist.secauto.metaschema.model.xmlbeans.GlobalFieldDefinitionType;
import gov.nist.secauto.metaschema.model.xmlbeans.InlineAssemblyDefinitionType;
import gov.nist.secauto.metaschema.model.xmlbeans.InlineFieldDefinitionType;
import gov.nist.secauto.metaschema.model.xmlbeans.InlineFlagDefinitionType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

class XmlFlagContainerSupport {
    @NonNull
    private final Map<String, IFlagInstance> flagInstances;

    public XmlFlagContainerSupport(@NonNull GlobalFieldDefinitionType xmlField, @NonNull IFieldDefinition container) {
        this.flagInstances = xmlField.getFlagList().size() > 0 || xmlField.getDefineFlagList().size() > 0 ? XmlFlagContainerSupport.parseLocalFlags(xmlField, (IFlagContainer)container) : CollectionUtil.emptyMap();
    }

    public XmlFlagContainerSupport(@NonNull InlineFieldDefinitionType xmlField, @NonNull IFieldDefinition container) {
        this.flagInstances = xmlField.getFlagList().size() > 0 || xmlField.getDefineFlagList().size() > 0 ? XmlFlagContainerSupport.parseLocalFlags(xmlField, (IFlagContainer)container) : CollectionUtil.emptyMap();
    }

    public XmlFlagContainerSupport(@NonNull GlobalAssemblyDefinitionType xmlAssembly, @NonNull IAssemblyDefinition container) {
        this.flagInstances = xmlAssembly.getFlagList().size() > 0 || xmlAssembly.getDefineFlagList().size() > 0 ? XmlFlagContainerSupport.parseLocalFlags(xmlAssembly, (IFlagContainer)container) : CollectionUtil.emptyMap();
    }

    public XmlFlagContainerSupport(@NonNull InlineAssemblyDefinitionType xmlAssembly, @NonNull IAssemblyDefinition container) {
        this.flagInstances = xmlAssembly.getFlagList().size() > 0 || xmlAssembly.getDefineFlagList().size() > 0 ? XmlFlagContainerSupport.parseLocalFlags(xmlAssembly, (IFlagContainer)container) : CollectionUtil.emptyMap();
    }

    @NonNull
    public Map<String, ? extends IFlagInstance> getFlagInstanceMap() {
        return this.flagInstances;
    }

    @NonNull
    private static Map<String, IFlagInstance> parseLocalFlags(@NonNull XmlObject xmlObject, @NonNull IFlagContainer parent) {
        LinkedHashMap<String, AbstractFlagInstance> flagInstances = new LinkedHashMap<String, AbstractFlagInstance>();
        try (XmlCursor cursor = xmlObject.newCursor();){
            cursor.selectPath("declare namespace m='http://csrc.nist.gov/ns/oscal/metaschema/1.0';$this/m:flag|$this/m:define-flag");
            while (cursor.toNextSelection()) {
                AbstractFlagInstance flagInstance;
                XmlObject obj = cursor.getObject();
                if (obj instanceof FlagReferenceType) {
                    flagInstance = new XmlFlagInstance((FlagReferenceType)obj, parent);
                    flagInstances.put(flagInstance.getEffectiveName(), flagInstance);
                    continue;
                }
                if (!(obj instanceof InlineFlagDefinitionType)) continue;
                flagInstance = new XmlInlineFlagDefinition((InlineFlagDefinitionType)obj, parent);
                flagInstances.put(flagInstance.getEffectiveName(), flagInstance);
            }
        }
        Map<String, IFlagInstance> retval = flagInstances.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(flagInstances);
        return retval;
    }
}

