/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.MarkupStringConverter;
import gov.nist.secauto.metaschema.model.ModelFactory;
import gov.nist.secauto.metaschema.model.common.AbstractFlagInstance;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.IFlagDefinition;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.xmlbeans.FlagReferenceType;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

class XmlFlagInstance
extends AbstractFlagInstance {
    @NonNull
    private final FlagReferenceType xmlFlag;

    public XmlFlagInstance(@NonNull FlagReferenceType xmlFlag, @NonNull IFlagContainer parent) {
        super(parent);
        this.xmlFlag = xmlFlag;
    }

    protected FlagReferenceType getXmlFlag() {
        return this.xmlFlag;
    }

    public IFlagDefinition getDefinition() {
        return (IFlagDefinition)ObjectUtils.notNull((Object)this.getContainingDefinition().getContainingMetaschema().getScopedFlagDefinitionByName(this.getName()));
    }

    public String getFormalName() {
        return this.getXmlFlag().isSetFormalName() ? this.getXmlFlag().getFormalName() : null;
    }

    public MarkupLine getDescription() {
        return this.getXmlFlag().isSetDescription() ? MarkupStringConverter.toMarkupString(this.getXmlFlag().getDescription()) : null;
    }

    public Map<QName, Set<String>> getProperties() {
        return ModelFactory.toProperties(CollectionUtil.listOrEmpty(this.getXmlFlag().getPropList()));
    }

    public String getName() {
        return this.getXmlFlag().getRef();
    }

    public String getXmlNamespace() {
        return null;
    }

    public MarkupMultiline getRemarks() {
        return this.getXmlFlag().isSetRemarks() ? MarkupStringConverter.toMarkupString(this.getXmlFlag().getRemarks()) : null;
    }

    public boolean isRequired() {
        return this.getXmlFlag().isSetRequired() ? this.getXmlFlag().getRequired() : false;
    }

    public String getUseName() {
        return this.getXmlFlag().isSetUseName() ? this.getXmlFlag().getUseName() : null;
    }

    public Object getValue(@NonNull Object parentValue) {
        return null;
    }
}

