/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.model.AssemblyConstraintSupport;
import gov.nist.secauto.metaschema.model.MarkupStringConverter;
import gov.nist.secauto.metaschema.model.ModelFactory;
import gov.nist.secauto.metaschema.model.XmlFlagContainerSupport;
import gov.nist.secauto.metaschema.model.XmlMetaschema;
import gov.nist.secauto.metaschema.model.XmlModelContainerSupport;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IAssemblyInstance;
import gov.nist.secauto.metaschema.model.common.IChoiceInstance;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.IFieldInstance;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import gov.nist.secauto.metaschema.model.common.IModelContainer;
import gov.nist.secauto.metaschema.model.common.IModelInstance;
import gov.nist.secauto.metaschema.model.common.INamedModelInstance;
import gov.nist.secauto.metaschema.model.common.ModuleScopeEnum;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IAssemblyConstraintSupport;
import gov.nist.secauto.metaschema.model.common.constraint.ICardinalityConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IExpectConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IIndexConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IMatchesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IUniqueConstraint;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.xmlbeans.GlobalAssemblyDefinitionType;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import nl.talsmasoftware.lazy4j.Lazy;

class XmlGlobalAssemblyDefinition
implements IAssemblyDefinition {
    @NonNull
    private final GlobalAssemblyDefinitionType xmlAssembly;
    @NonNull
    private final XmlMetaschema metaschema;
    private final Lazy<XmlFlagContainerSupport> flagContainer;
    private final Lazy<XmlModelContainerSupport> modelContainer;
    private final Lazy<AssemblyConstraintSupport> constraints;

    public XmlGlobalAssemblyDefinition(@NonNull GlobalAssemblyDefinitionType xmlAssembly, @NonNull XmlMetaschema metaschema) {
        this.xmlAssembly = xmlAssembly;
        this.metaschema = metaschema;
        this.flagContainer = Lazy.lazy(() -> new XmlFlagContainerSupport(xmlAssembly, (IAssemblyDefinition)this));
        this.modelContainer = Lazy.lazy(() -> new XmlModelContainerSupport(xmlAssembly, (IModelContainer)this));
        this.constraints = Lazy.lazy(() -> AssemblyConstraintSupport.newInstance(xmlAssembly, IConstraint.ExternalModelSource.instance((URI)metaschema.getLocation())));
    }

    @NonNull
    protected GlobalAssemblyDefinitionType getXmlAssembly() {
        return this.xmlAssembly;
    }

    public XmlMetaschema getContainingMetaschema() {
        return this.metaschema;
    }

    protected XmlFlagContainerSupport getFlagContainer() {
        return (XmlFlagContainerSupport)this.flagContainer.get();
    }

    @NonNull
    private Map<String, ? extends IFlagInstance> getFlagInstanceMap() {
        return this.getFlagContainer().getFlagInstanceMap();
    }

    public IFlagInstance getFlagInstanceByName(String name) {
        return this.getFlagInstanceMap().get(name);
    }

    public Collection<? extends IFlagInstance> getFlagInstances() {
        return this.getFlagInstanceMap().values();
    }

    protected XmlModelContainerSupport getModelContainer() {
        return (XmlModelContainerSupport)this.modelContainer.get();
    }

    private Map<String, ? extends INamedModelInstance> getNamedModelInstanceMap() {
        return this.getModelContainer().getNamedModelInstanceMap();
    }

    @Nullable
    public INamedModelInstance getModelInstanceByName(String name) {
        return this.getNamedModelInstanceMap().get(name);
    }

    @NonNull
    public Collection<? extends INamedModelInstance> getNamedModelInstances() {
        return this.getNamedModelInstanceMap().values();
    }

    private Map<String, ? extends IFieldInstance> getFieldInstanceMap() {
        return this.getModelContainer().getFieldInstanceMap();
    }

    public IFieldInstance getFieldInstanceByName(String name) {
        return this.getFieldInstanceMap().get(name);
    }

    public Collection<? extends IFieldInstance> getFieldInstances() {
        return this.getFieldInstanceMap().values();
    }

    private Map<String, ? extends IAssemblyInstance> getAssemblyInstanceMap() {
        return this.getModelContainer().getAssemblyInstanceMap();
    }

    public IAssemblyInstance getAssemblyInstanceByName(String name) {
        return this.getAssemblyInstanceMap().get(name);
    }

    public Collection<? extends IAssemblyInstance> getAssemblyInstances() {
        return this.getAssemblyInstanceMap().values();
    }

    public List<? extends IChoiceInstance> getChoiceInstances() {
        return this.getModelContainer().getChoiceInstances();
    }

    public List<? extends IModelInstance> getModelInstances() {
        return this.getModelContainer().getModelInstances();
    }

    protected IAssemblyConstraintSupport getConstraintSupport() {
        return (IAssemblyConstraintSupport)this.constraints.get();
    }

    public List<? extends IConstraint> getConstraints() {
        return this.getConstraintSupport().getConstraints();
    }

    public List<? extends IAllowedValuesConstraint> getAllowedValuesConstraints() {
        return this.getConstraintSupport().getAllowedValuesConstraints();
    }

    public List<? extends IMatchesConstraint> getMatchesConstraints() {
        return this.getConstraintSupport().getMatchesConstraints();
    }

    public List<? extends IIndexHasKeyConstraint> getIndexHasKeyConstraints() {
        return this.getConstraintSupport().getIndexHasKeyConstraints();
    }

    public List<? extends IExpectConstraint> getExpectConstraints() {
        return this.getConstraintSupport().getExpectConstraints();
    }

    public List<? extends IIndexConstraint> getIndexConstraints() {
        return this.getConstraintSupport().getIndexConstraints();
    }

    public List<? extends IUniqueConstraint> getUniqueConstraints() {
        return this.getConstraintSupport().getUniqueConstraints();
    }

    public List<? extends ICardinalityConstraint> getHasCardinalityConstraints() {
        return this.getConstraintSupport().getHasCardinalityConstraints();
    }

    public void addConstraint(@NonNull IAllowedValuesConstraint constraint) {
        this.getConstraintSupport().addConstraint(constraint);
    }

    public void addConstraint(@NonNull IMatchesConstraint constraint) {
        this.getConstraintSupport().addConstraint(constraint);
    }

    public void addConstraint(@NonNull IIndexHasKeyConstraint constraint) {
        this.getConstraintSupport().addConstraint(constraint);
    }

    public void addConstraint(@NonNull IExpectConstraint constraint) {
        this.getConstraintSupport().addConstraint(constraint);
    }

    public void addConstraint(@NonNull IIndexConstraint constraint) {
        this.getConstraintSupport().addConstraint(constraint);
    }

    public void addConstraint(@NonNull IUniqueConstraint constraint) {
        this.getConstraintSupport().addConstraint(constraint);
    }

    public void addConstraint(@NonNull ICardinalityConstraint constraint) {
        this.getConstraintSupport().addConstraint(constraint);
    }

    public boolean isInline() {
        return false;
    }

    public IAssemblyInstance getInlineInstance() {
        return null;
    }

    public String getName() {
        return this.getXmlAssembly().getName();
    }

    public String getUseName() {
        return this.getXmlAssembly().isSetUseName() ? this.getXmlAssembly().getUseName() : null;
    }

    public String getFormalName() {
        return this.getXmlAssembly().isSetFormalName() ? this.getXmlAssembly().getFormalName() : null;
    }

    public MarkupLine getDescription() {
        return this.getXmlAssembly().isSetDescription() ? MarkupStringConverter.toMarkupString(this.getXmlAssembly().getDescription()) : null;
    }

    public Map<QName, Set<String>> getProperties() {
        return ModelFactory.toProperties(CollectionUtil.listOrEmpty(this.getXmlAssembly().getPropList()));
    }

    public boolean hasJsonKey() {
        return this.getXmlAssembly().isSetJsonKey();
    }

    public IFlagInstance getJsonKeyFlagInstance() {
        IFlagInstance retval = null;
        if (this.hasJsonKey()) {
            retval = this.getFlagInstanceByName(this.getXmlAssembly().getJsonKey().getFlagRef());
        }
        return retval;
    }

    public boolean isRoot() {
        return this.getXmlAssembly().isSetRootName();
    }

    public String getRootName() {
        return this.getXmlAssembly().isSetRootName() ? this.getXmlAssembly().getRootName() : null;
    }

    public ModuleScopeEnum getModuleScope() {
        return this.getXmlAssembly().isSetScope() ? this.getXmlAssembly().getScope() : IDefinition.DEFAULT_DEFINITION_MODEL_SCOPE;
    }

    public MarkupMultiline getRemarks() {
        return this.getXmlAssembly().isSetRemarks() ? MarkupStringConverter.toMarkupString(this.getXmlAssembly().getRemarks()) : null;
    }
}

