/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.model.MarkupStringConverter;
import gov.nist.secauto.metaschema.model.ModelFactory;
import gov.nist.secauto.metaschema.model.ValueConstraintSupport;
import gov.nist.secauto.metaschema.model.XmlFlagContainerSupport;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.IFieldDefinition;
import gov.nist.secauto.metaschema.model.common.IFieldInstance;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.ModuleScopeEnum;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IExpectConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IMatchesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IValueConstraintSupport;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.adapter.MetaschemaDataTypeProvider;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.xmlbeans.DefineFieldConstraintsType;
import gov.nist.secauto.metaschema.model.xmlbeans.GlobalFieldDefinitionType;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

class XmlGlobalFieldDefinition
implements IFieldDefinition {
    @NonNull
    private final GlobalFieldDefinitionType xmlField;
    @NonNull
    private final IMetaschema metaschema;
    @Nullable
    private final Object defaultValue;
    private XmlFlagContainerSupport flagContainer;
    private IValueConstraintSupport constraints;

    public XmlGlobalFieldDefinition(@NonNull GlobalFieldDefinitionType xmlField, @NonNull IMetaschema metaschema) {
        this.xmlField = xmlField;
        this.metaschema = metaschema;
        Object defaultValue = null;
        if (xmlField.isSetDefault()) {
            defaultValue = this.getJavaTypeAdapter().parse((String)ObjectUtils.requireNonNull((Object)xmlField.getDefault()));
        }
        this.defaultValue = defaultValue;
    }

    @NonNull
    protected final GlobalFieldDefinitionType getXmlField() {
        return this.xmlField;
    }

    public IMetaschema getContainingMetaschema() {
        return this.metaschema;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IValueConstraintSupport initModelConstraints() {
        XmlGlobalFieldDefinition xmlGlobalFieldDefinition = this;
        synchronized (xmlGlobalFieldDefinition) {
            if (this.constraints == null) {
                this.constraints = this.getXmlField().isSetConstraint() ? new ValueConstraintSupport((DefineFieldConstraintsType)ObjectUtils.notNull((Object)this.getXmlField().getConstraint()), IConstraint.ExternalModelSource.instance((URI)this.getContainingMetaschema().getLocation())) : new ValueConstraintSupport();
            }
            return this.constraints;
        }
    }

    public List<? extends IConstraint> getConstraints() {
        return this.initModelConstraints().getConstraints();
    }

    public List<? extends IAllowedValuesConstraint> getAllowedValuesConstraints() {
        return this.initModelConstraints().getAllowedValuesConstraints();
    }

    public List<? extends IMatchesConstraint> getMatchesConstraints() {
        return this.initModelConstraints().getMatchesConstraints();
    }

    public List<? extends IIndexHasKeyConstraint> getIndexHasKeyConstraints() {
        return this.initModelConstraints().getIndexHasKeyConstraints();
    }

    public List<? extends IExpectConstraint> getExpectConstraints() {
        return this.initModelConstraints().getExpectConstraints();
    }

    public void addConstraint(@NonNull IAllowedValuesConstraint constraint) {
        this.initModelConstraints().addConstraint(constraint);
    }

    public void addConstraint(@NonNull IMatchesConstraint constraint) {
        this.initModelConstraints().addConstraint(constraint);
    }

    public void addConstraint(@NonNull IIndexHasKeyConstraint constraint) {
        this.initModelConstraints().addConstraint(constraint);
    }

    public void addConstraint(@NonNull IExpectConstraint constraint) {
        this.initModelConstraints().addConstraint(constraint);
    }

    public boolean isInline() {
        return false;
    }

    public IFieldInstance getInlineInstance() {
        return null;
    }

    public String getName() {
        return this.getXmlField().getName();
    }

    public String getUseName() {
        return this.getXmlField().isSetUseName() ? this.getXmlField().getUseName() : null;
    }

    public String getFormalName() {
        return this.getXmlField().isSetFormalName() ? this.getXmlField().getFormalName() : null;
    }

    public MarkupLine getDescription() {
        return this.getXmlField().isSetDescription() ? MarkupStringConverter.toMarkupString(this.getXmlField().getDescription()) : null;
    }

    public Map<QName, Set<String>> getProperties() {
        return ModelFactory.toProperties(CollectionUtil.listOrEmpty(this.getXmlField().getPropList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XmlFlagContainerSupport initFlagContainer() {
        XmlGlobalFieldDefinition xmlGlobalFieldDefinition = this;
        synchronized (xmlGlobalFieldDefinition) {
            if (this.flagContainer == null) {
                this.flagContainer = new XmlFlagContainerSupport(this.getXmlField(), (IFieldDefinition)this);
            }
            return this.flagContainer;
        }
    }

    @NonNull
    private Map<String, ? extends IFlagInstance> getFlagInstanceMap() {
        return this.initFlagContainer().getFlagInstanceMap();
    }

    public IFlagInstance getFlagInstanceByName(String name) {
        return this.getFlagInstanceMap().get(name);
    }

    public Collection<? extends IFlagInstance> getFlagInstances() {
        return this.getFlagInstanceMap().values();
    }

    public final IDataTypeAdapter<?> getJavaTypeAdapter() {
        return this.getXmlField().isSetAsType() ? this.getXmlField().getAsType() : MetaschemaDataTypeProvider.DEFAULT_DATA_TYPE;
    }

    public boolean hasJsonValueKeyFlagInstance() {
        return this.getXmlField().isSetJsonValueKeyFlag() && this.getXmlField().getJsonValueKeyFlag().isSetFlagRef();
    }

    public IFlagInstance getJsonValueKeyFlagInstance() {
        IFlagInstance retval = null;
        if (this.getXmlField().isSetJsonValueKeyFlag() && this.getXmlField().getJsonValueKeyFlag().isSetFlagRef()) {
            retval = this.getFlagInstanceByName(this.getXmlField().getJsonValueKeyFlag().getFlagRef());
        }
        return retval;
    }

    public String getJsonValueKeyName() {
        String retval = null;
        if (this.getXmlField().isSetJsonValueKey()) {
            retval = this.getXmlField().getJsonValueKey();
        }
        if (retval == null || retval.isEmpty()) {
            retval = this.getJavaTypeAdapter().getDefaultJsonValueKey();
        }
        return retval;
    }

    public boolean hasJsonKey() {
        return this.getXmlField().isSetJsonKey();
    }

    public IFlagInstance getJsonKeyFlagInstance() {
        IFlagInstance retval = null;
        if (this.hasJsonKey()) {
            retval = this.getFlagInstanceByName(this.getXmlField().getJsonKey().getFlagRef());
        }
        return retval;
    }

    public boolean isCollapsible() {
        return this.getXmlField().isSetCollapsible() ? this.getXmlField().getCollapsible() : false;
    }

    public ModuleScopeEnum getModuleScope() {
        return this.getXmlField().isSetScope() ? this.getXmlField().getScope() : IDefinition.DEFAULT_DEFINITION_MODEL_SCOPE;
    }

    public MarkupMultiline getRemarks() {
        return this.getXmlField().isSetRemarks() ? MarkupStringConverter.toMarkupString(this.getXmlField().getRemarks()) : null;
    }

    public Object getFieldValue(@NonNull Object parentFieldValue) {
        return null;
    }
}

