/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.model.MarkupStringConverter;
import gov.nist.secauto.metaschema.model.ModelFactory;
import gov.nist.secauto.metaschema.model.ValueConstraintSupport;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.ModuleScopeEnum;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IExpectConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IMatchesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IValueConstraintSupport;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.adapter.MetaschemaDataTypeProvider;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.xmlbeans.DefineFlagConstraintsType;
import gov.nist.secauto.metaschema.model.xmlbeans.GlobalFlagDefinitionType;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

class XmlGlobalFlagDefinition
implements IFlagDefinition {
    @NonNull
    private final GlobalFlagDefinitionType xmlFlag;
    @NonNull
    private final IMetaschema metaschema;
    @Nullable
    private final Object defaultValue;
    private IValueConstraintSupport constraints;

    public XmlGlobalFlagDefinition(@NonNull GlobalFlagDefinitionType xmlFlag, @NonNull IMetaschema metaschema) {
        this.xmlFlag = xmlFlag;
        this.metaschema = metaschema;
        Object defaultValue = null;
        if (xmlFlag.isSetDefault()) {
            defaultValue = this.getJavaTypeAdapter().parse((String)ObjectUtils.requireNonNull((Object)xmlFlag.getDefault()));
        }
        this.defaultValue = defaultValue;
    }

    protected final GlobalFlagDefinitionType getXmlFlag() {
        return this.xmlFlag;
    }

    public IMetaschema getContainingMetaschema() {
        return this.metaschema;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IValueConstraintSupport initModelConstraints() {
        XmlGlobalFlagDefinition xmlGlobalFlagDefinition = this;
        synchronized (xmlGlobalFlagDefinition) {
            if (this.constraints == null) {
                this.constraints = this.getXmlFlag().isSetConstraint() ? new ValueConstraintSupport((DefineFlagConstraintsType)ObjectUtils.notNull((Object)this.getXmlFlag().getConstraint()), IConstraint.ExternalModelSource.instance((URI)this.getContainingMetaschema().getLocation())) : new ValueConstraintSupport();
            }
            return this.constraints;
        }
    }

    public List<? extends IConstraint> getConstraints() {
        return this.initModelConstraints().getConstraints();
    }

    public List<? extends IAllowedValuesConstraint> getAllowedValuesConstraints() {
        return this.initModelConstraints().getAllowedValuesConstraints();
    }

    public List<? extends IMatchesConstraint> getMatchesConstraints() {
        return this.initModelConstraints().getMatchesConstraints();
    }

    public List<? extends IIndexHasKeyConstraint> getIndexHasKeyConstraints() {
        return this.initModelConstraints().getIndexHasKeyConstraints();
    }

    public List<? extends IExpectConstraint> getExpectConstraints() {
        return this.initModelConstraints().getExpectConstraints();
    }

    public void addConstraint(@NonNull IAllowedValuesConstraint constraint) {
        this.initModelConstraints().addConstraint(constraint);
    }

    public void addConstraint(@NonNull IMatchesConstraint constraint) {
        this.initModelConstraints().addConstraint(constraint);
    }

    public void addConstraint(@NonNull IIndexHasKeyConstraint constraint) {
        this.initModelConstraints().addConstraint(constraint);
    }

    public void addConstraint(@NonNull IExpectConstraint constraint) {
        this.initModelConstraints().addConstraint(constraint);
    }

    public ModuleScopeEnum getModuleScope() {
        return this.getXmlFlag().isSetScope() ? this.getXmlFlag().getScope() : IDefinition.DEFAULT_DEFINITION_MODEL_SCOPE;
    }

    public boolean isInline() {
        return false;
    }

    public IFlagInstance getInlineInstance() {
        return null;
    }

    public String getName() {
        return this.getXmlFlag().getName();
    }

    public String getUseName() {
        String retval = this.getXmlFlag().getUseName();
        if (retval == null) {
            retval = this.getName();
        }
        return retval;
    }

    public String getFormalName() {
        return this.getXmlFlag().isSetFormalName() ? this.getXmlFlag().getFormalName() : null;
    }

    public MarkupLine getDescription() {
        return this.getXmlFlag().isSetDescription() ? MarkupStringConverter.toMarkupString(this.getXmlFlag().getDescription()) : null;
    }

    public Map<QName, Set<String>> getProperties() {
        return ModelFactory.toProperties(CollectionUtil.listOrEmpty(this.getXmlFlag().getPropList()));
    }

    public final IDataTypeAdapter<?> getJavaTypeAdapter() {
        return this.getXmlFlag().isSetAsType() ? this.getXmlFlag().getAsType() : MetaschemaDataTypeProvider.DEFAULT_DATA_TYPE;
    }

    public MarkupMultiline getRemarks() {
        return this.getXmlFlag().isSetRemarks() ? MarkupStringConverter.toMarkupString(this.getXmlFlag().getRemarks()) : null;
    }
}

